
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "xferPlugin_opt.h"

opt_matrix mat;
#ifdef PROFILING
static double sum_filter = 0.0;
static unsigned int num_filter = 0;
static double sum_nofilter = 0.0;
static unsigned int num_nofilter = 0;
#endif

static unsigned int total_opt_calls = 0;
static unsigned int perform_opt_calls = 0;
static unsigned int skip_thresh_calls = 0;
static unsigned int skip_pressure_calls = 0;

static unsigned int total_blocks = 0;
static unsigned int xdisk_blocks = 0;
static unsigned int net_blocks = 0;

static unsigned int hint_tracker = 0;

static bool opt_now = false;
static double opt_time = 0;

extern list<client, &client::link> clientlist;

bool
pressure_from_client()
{
#ifdef NO_PRESSURE
    return false;
#endif
    
    client *obj = clientlist.first;
    if (!obj) {
	DPRINTF(DEBUG_OPT, "pressure_from_client:: No client connected\n");
	return(false);
    }
	
    ref<axprt_unix> x = obj->x;
    assert(x);
    int bytes = x->outlen();
    if (bytes > CLIENT_OUTSTANDING_THRESHOLD) {
	DPRINTF(DEBUG_OPT, "pressure_from_client:: Bytes are %d\n", bytes);
	return(true);
    }

    DPRINTF(DEBUG_OPT, "pressure_from_client:: NONE\n");
    return(false);
}

extern ihash<const str, conn_entry, &conn_entry::key, &conn_entry::hlink> connCache;

bool
pressure_from_network()
{
#ifdef NO_PRESSURE
    return false;
#endif
    
    int fd = -1;

    conn_entry *cne = connCache.first();
    while (cne != NULL) {
	fd = cne->fd;

	struct timeval ztv = { 0, 0 };
    	if (fdwait(fd, fd, true, false, &ztv) > 0) {
	    DPRINTF(DEBUG_OPT, "pressure_from_network:: %s | %d is set\n",
		    cne->key.cstr(), fd);
	    return true;
	}
	
	cne = connCache.next(cne);
    } 

    DPRINTF(DEBUG_OPT, "pressure_from_network:: NONE\n");
    return(false);
}

void
heap_impl::print_vec(std::vector<os_entry *> &t)
{
    //debug
    fprintf(stderr, debug_sep);
    for (unsigned int i = 0; i < t.size(); i++)
	fprintf(stderr, "%s --> %f\n", (t[i])->id.cstr(), (t[i])->cpb);
    fprintf(stderr, debug_sep);
}

void
heap_impl::heap_insert(os_entry *ose)
{
    v.push_back(ose);
    push_heap(v.begin(), v.end(), Compare_os_entry());
}

void
heap_impl::heap_pop(os_entry *ose)
{
    //warnx("Before heap pop\n");
    //print_vec(v);
    
    os_entry *t = v.front();
    if (t->id != ose->id) {
        fatal << "not popping first element\n";
    }
    pop_heap(v.begin(), v.end(), Compare_os_entry());
    os_entry *g = v[v.size()-1];
    v.pop_back();

    if (g->id != t->id) {
	fatal << "What did i pop\n";
    }
    
    //warnx("After heap pop\n");
    //print_vec(v);
}

os_entry *
heap_impl::heap_top()
{
    os_entry *ret = v.front();
    return(ret);
}

void
heap_impl::heap_make()
{
    //warnx << "heap_impl::heap_make()\n";
    make_heap(v.begin(), v.end(), Compare_os_entry());
    //print_vec(v);
}

void
heap_impl::heap_sort(ptr<vec<str > > op)
{
    std::vector<os_entry *> s = v;
    
    //warnx("After heap copy\n");
    //print_vec(s);
    
    sort_heap(s.begin(), s.end(), Compare_os_entry());

    //warnx << "After heap sort " << s.size() << "\n";
    //print_vec(s);
    
    for (int i = s.size() - 1; i >= 0; i--) {
	op->push_back((s[i])->id);
    }
}
/*********************/
void
opt_matrix::dump_table()
{
    warnx << debug_sep << "Cols -->\n";
    ds_entry *dse = mat.desc_store.first();
    while (dse != NULL) {
	warnx << dse->desc << "\n";
	dse = mat.desc_store.next(dse);
    }
    warnx << "Rows -->\n";
    os_entry *ose = mat.op_store.first();
    while (ose != NULL) {
	warnx << ose->id << "\n";
	ose = mat.op_store.next(ose);
    }
    warnx << debug_sep << "Hints -->\n";
    ht_entry *hte = mat.hint_store.first();
    while (hte != NULL) {
	warnx << "hint\n";
	hte = mat.hint_store.next(hte);
    }
    warnx << debug_sep;
}

void
opt_matrix::add_col(ds_entry *dse)
{
    desc_store.insert(dse);
}

/* void */
/* opt_matrix::clean_col(ds_entry *dse) */
/* { */
/*     assert(dse->status == DELETED); */
/*     desc_store.remove(dse); */
/*     delete dse; */
/* } */

/* void */
/* opt_matrix::delete_col(dot_desc d) */
/* { */
/*     ds_entry *dse = desc_store[d]; */
/*     dse->status = DELETED; */
/* } */

void
opt_matrix::delete_col(dot_desc d)
{
    ds_entry *dse = desc_store[d];
    desc_store.remove(dse);
    delete dse;
}

void
opt_matrix::add_row(os_entry *ose)
{
    op_store.insert(ose);
    if (mode != BFS_WHOLE)
	heap->heap_insert(ose);
}

void
opt_matrix::delete_row_complete(str opid)
{
    os_entry *ose = op_store[opid];
    op_store.remove(ose);
    delete ose;
}

void
opt_matrix::delete_row_start(str opid)
{
    assert(0);
    os_entry *ose = op_store[opid];
    if (mode != BFS_WHOLE)
	heap->heap_pop(ose);
}

void
opt_matrix::refresh_rows_complete()
{
    heap->heap_make();
}

void
opt_matrix::refresh_rows_partial()
{
    assert(0);
    os_entry *ose = heap->heap_top();
    heap->heap_pop(ose);
    heap->heap_insert(ose);
}

void
opt_matrix::sort_rows(ptr<vec<str > > op)
{
    heap->heap_sort(op);
}

void
opt_matrix::sort_cols()
{
    s.clear();
        
    ht_entry *hte = mat.hint_store.first();
    while (hte != NULL) {
	s.push_back(hte);
	hte = mat.hint_store.next(hte);
    }
    
    sort(s.begin(), s.end(), Compare_ht_entry());

   /*  fprintf(stderr, "--------------------------------------------\n"); */
/*     fprintf(stderr, "After sort_cols\n"); */
/*     for (unsigned int i = 0; i < s.size(); i++) { */
/* 	fprintf(stderr, "%d --> %f\n", s[i]->num, (s[i])->avail); */
/*     } */
/*     fprintf(stderr, "--------------------------------------------\n"); */
}


os_entry *
opt_matrix::extract_min_row()
{
    return(heap->heap_top());
}

/*****************************************/
static str
hash_hint_function(ref<vec<oid_hint> > oh)
{
    hint_vec v;
    v.hints = *oh;

    hint_hash h;
    if (!sha1_hashxdr (&h, v))
	return NULL;
    return str(h.base(), h.size());
}

ht_entry::ht_entry(str k, ref<vec<oid_hint> > oh,
		   ds_entry *a)
    :oidhint(oh)
{
    key = k;
    
    counter = 0;
    
    a->hint_index = 0 ; //counter;
    desc_vec = New refcounted<vec<ds_entry *> >;
    desc_vec->push_back(a);
    counter++;
    
    hints = New refcounted<vec<xdisk_hint> >;

    mat.hint_store.insert(this);
    mat.s.push_back(this);

    num = hint_tracker;
    hint_tracker++;

    dwarn(DEBUG_OPT & DEBUG_L1) << "Creating new hint " << num << "\n";
}

ht_entry::~ht_entry()
{
    dwarn(DEBUG_OPT & DEBUG_L1) << "Deleting hint " << num << "\n";
    mat.hint_store.remove(this);
    unsigned int size = mat.s.size();
    for (unsigned int i = 0; i < size; i++) {
	if (mat.s[i] == this) {
	    mat.s[i] = NULL;
	    break;
	}
    }
}

void
ht_entry::add_desc(ds_entry *a)
{
    //dwarn(DEBUG_OPT) << "Adding descriptor to hint "
    //	     << a->desc << "\n";
    
    desc_vec->push_back(a);
    a->hint_index = desc_vec->size() - 1; //counter;
    counter++;
}

void
ht_entry::remove_desc(ds_entry *a)
{
    (*desc_vec)[a->hint_index] = NULL;
    counter--;
}

ds_entry::ds_entry(chunk_cb cb, dot_descriptor dot_des, 
		   ref<vec<oid_hint> > oh, xferPlugin_opt *xp)
    : dd(dot_des)
{
    ccb.push_back(cb);
    desc = dot_des.id;
    mat.add_col(this);

#ifdef GTC_SUPPORT
    ask = false;
#endif

    ordernum = total_blocks;

    //check for cache here
    //if cache hit put in cache hint grp
    bool is_hit = false;
    xp->xfplugins[XDISK]->extract_chit_op(dot_des, &is_hit);
    
    if (is_hit) {
	str key("CACHE_HIT");
	dwarn(DEBUG_OPT & DEBUG_L1) << "Creating cache hit\n";
	ht_entry *hte = mat.hint_store[key];
	if (hte) {
	    hte->add_desc(this);
	}
	else {
	    hte = New ht_entry(key, oh, this);
	}
	
	hint_ptr = hte;
	dwarn(DEBUG_OPT & DEBUG_L1) << "Create Hint " << dot_des.id << " " << hint_ptr->num << " " <<
	    hint_index << "\n";
	return;
    }
    
    //now make a pointer to my hints;
    str key = hash_hint_function(oh);
    ht_entry *hte = mat.hint_store[key];
    if (hte) {
	hte->add_desc(this);
    }
    else {
	hte = New ht_entry(key, oh, this);
	xp->update_rows(hte);
    }

    hint_ptr = hte;

    dwarn(DEBUG_OPT & DEBUG_L1) << "Hint " << dot_des.id << " " << hint_ptr->num << " " <<
	hint_index << "\n";
    
    //warnx << "ds_entry::ds_entry: Creating entry for " << desc << "\n";
    //for (unsigned int i = 0; i < oidhint->size(); i++) {
    //warnx << (*oidhint)[i].name << "\n";
    //}
}

ds_entry::~ds_entry()
{
    //warnx << "ds_entry::ds_entry: Destroying entry for " << desc << "\n";
    delete_from_hint();
}

void
ds_entry::delete_from_hint()
{
    hint_ptr->remove_desc(this);
    if (hint_ptr->counter <= 0)
	delete hint_ptr;
}

void
ds_entry::print_hints()
{
    warnx << "ds_entry::ds_entry: Printing hints for " << desc << "\n";
    for (unsigned int i = 0; i < hint_ptr->oidhint->size(); i++) {
	warnx << (*(hint_ptr->oidhint))[i].name << "\n";
    }
}

void
ds_entry::update_info(ref<vec<oid_hint> > oh, chunk_cb cb,
		      xferPlugin_opt *xp)
{
    ccb.push_back(cb);

    //check for cache here
    //if cache hit put in cache hint grp
    if (hint_ptr->key != "CACHE_HIT") {
	bool is_hit = false;
	xp->xfplugins[XDISK]->extract_chit_op(dd, &is_hit);
	
	if (is_hit)
	    fatal << "How possible is it?\n";
    }
    else {
	//i am in the cache hit grp what else to do
	return;
    }
    
    ref<vec<oid_hint> > mine = hint_ptr->oidhint;
    
    //update the hints
    for (unsigned int j = 0; j < oh->size(); j++) {
	bool match = false;
	for (unsigned int i = 0; i < mine->size(); i++) {
	    if ((*oh)[j].name == (*mine)[i].name) {
		match = true;
		break;
	    }
	}
	
	if (!match) {
	    oh->push_back((*mine)[j]);
	    //warnx << "ds_entry::ds_entry: Updating entry for " << desc
	    //  << (*oh)[j].name << "\n";
	}
	else {
	    //warnx << "ds_entry::ds_entry: Skipping entry for " << desc
	    //  << (*oh)[j].name << "\n";
	}
    }

    //assertion is new hints must be there
    
    //update the order num too
    ordernum = total_blocks;

    dwarn(DEBUG_OPT & DEBUG_L1) << "Update Hint " << dd.id << " "
				<< hint_ptr->num << " " << hint_index << "\n";
    
    //delete myself from my old hint
    delete_from_hint();

    //now make a pointer to my hints;
    str key = hash_hint_function(oh);
    ht_entry *hte = mat.hint_store[key];
    if (hte) {
	hte->add_desc(this);
    }
    else {
	hte = New ht_entry(key, oh, this);
	xp->update_rows(hte);
    }

    hint_ptr = hte;

    dwarn(DEBUG_OPT & DEBUG_L1) << "Update Hint " << dd.id << " "
				<< hint_ptr->num << " " << hint_index << "\n";
}


bool
xferPlugin_opt::configure(str s)
{
    //for debugging
    char *hn = NULL;
    char *name = NULL;
    
    if (!s || s == "")
        return true;
    
    name = strdup(s.cstr());
    if ((hn = strchr(name, ' '))) {
        *hn++ = '\0';
        path.setbuf(name, strlen(name));
        op_mode = atoi(hn);
    }
    else
        return false;

    warnx << "Setting " << path << " " << op_mode << "\n";

    warnx << "**************MODE is " << mode << "\n";

#ifdef NO_PRESSURE
    warnx << "**************NO PRESSURE\n";
#endif
    
    return true;
}

void
xferPlugin_opt::set_more_plugins(vec<xferPlugin*> xplist)
{
    warn << "xferPlugin_opt::set_more_plugins setting more plugins\n";
    xfplugins = xplist;
}

void
xferPlugin_opt::dump_rusage(struct rusage *rs1, struct rusage *rs2)
{
    double u1 = (1.0*(rs1->ru_utime.tv_sec + rs1->ru_utime.tv_usec/1000000.0));
    double u2 = (1.0*(rs2->ru_utime.tv_sec + rs2->ru_utime.tv_usec/1000000.0));
    fprintf(stderr, "User time used %f %f %f\n", u1, u2, (u2-u1));
    
    double s1 = (1.0*(rs1->ru_stime.tv_sec + rs1->ru_stime.tv_usec/1000000.0));
    double s2 = (1.0*(rs2->ru_stime.tv_sec + rs2->ru_stime.tv_usec/1000000.0));
    fprintf(stderr, "System time used %f %f %f\n", s1, s2, (s2-s1));

    fprintf(stderr, "Maximum resident set size %ld %ld %ld\n", rs1->ru_maxrss,
	    rs2->ru_maxrss, (rs2->ru_maxrss - rs1->ru_maxrss));

    fprintf(stderr, "Integral shared memory size %ld %ld %ld\n", rs1->ru_ixrss,
	    rs2->ru_ixrss, (rs2->ru_ixrss - rs1->ru_ixrss));

    fprintf(stderr, "Integral unshared data size %ld %ld %ld\n", rs1->ru_idrss,
	    rs2->ru_idrss, (rs2->ru_idrss - rs1->ru_idrss));

     fprintf(stderr, "Integral unshared stack size %ld %ld %ld\n", rs1->ru_isrss,
	     rs2->ru_isrss, (rs2->ru_isrss - rs1->ru_isrss));

     fprintf(stderr, "Page reclaims %ld %ld %ld\n", rs1->ru_minflt,
	     rs2->ru_minflt, (rs2->ru_minflt - rs1->ru_minflt));

     fprintf(stderr, "Page faults %ld %ld %ld\n", rs1->ru_majflt,
	     rs2->ru_majflt, (rs2->ru_majflt - rs1->ru_majflt));

     fprintf(stderr, "Swaps %ld %ld %ld\n", rs1->ru_nswap,
	     rs2->ru_nswap, (rs2->ru_nswap - rs1->ru_nswap));

     fprintf(stderr, "Block input operations %ld %ld %ld\n", rs1->ru_inblock,
	     rs2->ru_inblock, (rs2->ru_inblock - rs1->ru_inblock));

     fprintf(stderr, "Block output operations %ld %ld %ld\n", rs1->ru_oublock,
	     rs2->ru_oublock, (rs2->ru_oublock - rs1->ru_oublock));

     fprintf(stderr, "Messages sent %ld %ld %ld\n", rs1->ru_msgsnd,
	     rs2->ru_msgsnd, (rs2->ru_msgsnd - rs1->ru_msgsnd));

     fprintf(stderr, "Messages received %ld %ld %ld\n", rs1->ru_msgrcv,
	     rs2->ru_msgrcv, (rs2->ru_msgrcv - rs1->ru_msgrcv));

     fprintf(stderr, "Signals received %ld %ld %ld\n", rs1->ru_nsignals,
	     rs2->ru_nsignals, (rs2->ru_nsignals - rs1->ru_nsignals));

     fprintf(stderr, "Voluntary context switches %ld %ld %ld\n", rs1->ru_nvcsw,
	     rs2->ru_nvcsw, (rs2->ru_nvcsw - rs1->ru_nvcsw));

     fprintf(stderr, "Involuntary context switches %ld %ld %ld\n", rs1->ru_nivcsw,
	     rs2->ru_nivcsw, (rs2->ru_nivcsw - rs1->ru_nivcsw));

}

//can't use BLOCK in the functions below since the get_descriptors 
// and the get_chunks calls in xferPlugin_gtc etc call back multiple times
// and TAME thinks that the function is overcalled.
// TAME probably keeps a counter as to how many times a function call was made with in BLOCK
// and hence allows only that many callbacks

# 605 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__get_descriptors__closure_t : public closure_t { public:   xferPlugin_opt__get_descriptors__closure_t (xferPlugin_opt *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (xferPlugin_opt::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  descriptors_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T:617: in function xferPlugin_opt::get_bitmap", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_opt__get_descriptors__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) {}      str err;      ptr< vec< dot_descriptor > > descs;      bool end;   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      descriptors_cb cb;   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 605 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::get_descriptors( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  descriptors_cb __tame_cb, ptr<closure_t> __cls_g)
{
    
# 608 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__get_descriptors__closure_t *__cls;   ptr<xferPlugin_opt__get_descriptors__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__get_descriptors__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::get_descriptors);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__get_descriptors__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< vec< dot_descriptor > > &descs = __cls->_stack.descs;    bool &end = __cls->_stack.end;    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    descriptors_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_opt__get_descriptors__label_1;     break;   default:     break;   }
# 612 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"


    
# 614 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 614 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

	//first see if there is a cache hit in disk plugin
	xfplugins[XDISK]->get_descriptors(oid, hints,
				  (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb3<TTT(err), TTT( descs), TTT( end)>, __cls_r, 1, pointer_set3_t<TTT(err), TTT( descs), TTT( end)> (&(err), &( descs), &( end)))));
    
# 618 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_opt__get_descriptors__label_1:     ;
# 618 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

    
    if (err) {
	xfplugins[NET]->get_descriptors(oid, hints, cb);
    }
    else {
	(*cb)(err, descs, end);
    }
# 626 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 626 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

# 628 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__get_chunk__closure_t : public closure_t { public:   xferPlugin_opt__get_chunk__closure_t (xferPlugin_opt *_self,  ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (d, hints, cb), _args (d, hints, cb) {}   typedef void  (xferPlugin_opt::*method_type_t) ( ref< dot_descriptor > ,  ref< vec< oid_hint > > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : d (d), hints (hints), cb (cb) {}      ref< dot_descriptor > d;      ref< vec< oid_hint > > hints;      chunk_cb cb;   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 628 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::get_chunk( ref< dot_descriptor > __tame_d,  ref< vec< oid_hint > > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 631 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__get_chunk__closure_t *__cls;   ptr<xferPlugin_opt__get_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__get_chunk__closure_t> (this, __tame_d, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::get_chunk);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__get_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 631 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

    fatal << "xferPlugin_opt::get_chunk: called\n";
# 633 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 633 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

# 635 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__get_chunks__closure_t : public closure_t { public:   xferPlugin_opt__get_chunks__closure_t (xferPlugin_opt *_self,  ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (dv, hints, cb), _args (dv, hints, cb) {}   typedef void  (xferPlugin_opt::*method_type_t) ( ref< vec< dot_descriptor > > ,  ref< hv_vec > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.dv, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) : dv (dv), hints (hints), cb (cb) {}      ref< vec< dot_descriptor > > dv;      ref< hv_vec > hints;      chunk_cb cb;   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 635 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::get_chunks( ref< vec< dot_descriptor > > __tame_dv,  ref< hv_vec > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 638 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__get_chunks__closure_t *__cls;   ptr<xferPlugin_opt__get_chunks__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__get_chunks__closure_t> (this, __tame_dv, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::get_chunks);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__get_chunks__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< vec< dot_descriptor > > &dv = __cls->_args.dv;    ref< hv_vec > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (dv);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 638 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

    //create columns for the incoming chunks
    unsigned int dv_size =  dv->size();
    for (unsigned int i = 0; i < dv_size; i++) {
	dot_desc cid = (*dv)[i].id;
	ds_entry *dse = mat.desc_store[cid];
	total_blocks++;
	if (!dse) {
	    dse = New ds_entry(cb, (*dv)[i], (*hints)[i], this);
	    cur_change_chunks++;
	}
	else {
	    dse->update_info((*hints)[i], cb, this);
	}
	//dwarn(DEBUG_OPT & DEBUG_L1) << "Fetching " << dse->desc << "\n";
    }

    //print hints
  /*   for (unsigned int i = 0; i < dv_size; i++) { */
/*     	dot_desc cid = (*dv)[i].id; */
/*     	ds_entry *dse = mat.desc_store[cid]; */
/*     	dse->print_hints(); */
/*     } */
/*     mat.dump_table(); */
    //debug
    
    //create cache hit for the new incoming chunks
   /*  unsigned int num_of_plugins = xfplugins.size(); */
/*     for (unsigned int i = 0; i < num_of_plugins; i++) { */
/*         xfplugins[i]->update_table(NULL, dv); */
/*     } */
    
    if (mode != BFS_WHOLE) {
	cur_change_chunks += get_change_chunks_new_ops();
    }
    
    perform_optimization();
# 675 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 675 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

void
xferPlugin_opt::update_rows(ht_entry *hte)
{
    //create rows for the new incoming chunks
    unsigned int num_of_plugins = xfplugins.size();
    for (unsigned int i = 0; i < num_of_plugins; i++) {
	xfplugins[i]->update_table(hte->key, NULL);
    }
}

void
xferPlugin_opt::get_chunks_cb(str opid, unsigned int plugin, str s, ptr<desc_result> res)
{
    if (res == NULL && s) {
	//error in operation (can be net or disk)
	warnx << "get_chunks_cb:: something wrong in get_chunks "
	    << plugin << "\n";
	if (plugin == XDISK) {
	    disk_busy = false;
	    mat.delete_row_complete(opid);
	}
    }
    else if (res == NULL && !s) {
	//disk operation completed
	assert(plugin == XDISK);
	disk_busy = false;
	
	//change for del row and adding rows
	if (mode != BFS_WHOLE) {
	    cur_change_chunks += get_change_chunks_new_ops();
	    cur_change_chunks += get_change_chunks_del_op(opid);
	}
	
	/*DPRINTF(DEBUG_OPT,*/ fprintf(stderr, "xferPlugin_opt::pick_xdisk_op: Completed %s with %d blocks and Time %f\n",
		mat.op_store[opid]->id.cstr(), mat.op_store[opid]->success, mat.op_store[opid]->time);

	//bindu
	//if (mat.op_store[opid]->success > 0)
	//  fprintf(stderr, "******************USEFUL*******************\n");
	
	mat.delete_row_complete(opid);
	//mat.dump_table();
    }
    else {
	ds_entry *dse = mat.desc_store[res->desc->id];
	
        if (plugin == XDISK) {
	    str b = strbuf() << res->desc->id;
	    DPRINTF(DEBUG_OPT, "xferPlugin_opt::get_chunks_cb: Just got back from XDISK %s %d\n",
		    b.cstr(), dse->ordernum);

	    if (dse) {
		mat.op_store[opid]->success++;
		xdisk_blocks++;
	    }
	}
	else if (plugin == NET) {
	    net_scheduled--;
	    
	    if (net_scheduled < 0)
		net_scheduled = 0;
	    
#ifdef GTC_SUPPORT
	    //PENDING--;
#endif
	    str b = strbuf() << res->desc->id;
	    DPRINTF(DEBUG_OPT, "xferPlugin_opt::get_chunks_cb: Just got back from NET %s\n",
		    b.cstr());
	    if (dse)
		net_blocks++;
	}
	
	if (!dse)
	    DPRINTF(DEBUG_OPT, "xferPlugin_opt::get_chunks_cb: Duplicate work\n");
	else {
	    dot_desc id = dse->desc;
	    cur_change_chunks++;
	    for (unsigned int in = 0; in < dse->ccb.size(); in++) {
		//warnx << "Calling back\n";
		chunk_cb cb = dse->ccb[in];
		(*cb)(s, res);
	    }
	    mat.delete_col(id);
	}
    }

    perform_optimization();
}

double
xferPlugin_opt::get_change_chunks_del_op(str opid)
{
    os_entry *ose = mat.op_store[opid];
    double change = ose->sum_p - ose->success;
    if (change < 0) {
	change = 0;
    }
    return(change);
}

double
xferPlugin_opt::get_change_chunks_new_ops()
{
    double change = 0;

    os_entry *ose = mat.pending_q.first;
    while (ose != NULL) {
	cost_per_block(ose);
	change += ose->sum_p;
	ose->it_num = cur_iteration + 1;
	
	mat.add_row(ose);

	mat.pending_q.remove(ose);
	ose = mat.pending_q.first;
    }
    
    return(change);
}

# 797 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__perform_optimization__closure_t : public closure_t { public:   xferPlugin_opt__perform_optimization__closure_t (xferPlugin_opt *_self) : closure_t (false), _self (_self),  _stack (), _args (), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (xferPlugin_opt::*method_type_t) (ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T:810: in function xferPlugin_opt::get_chunks", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_opt__perform_optimization__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (mkref (this));   }   struct stack_t {     stack_t () {}      str err;      ptr< opt_result > res;   };   struct args_t {     args_t () {}   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 797 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::perform_optimization(ptr<closure_t> __cls_g)
{
    
# 800 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__perform_optimization__closure_t *__cls;   ptr<xferPlugin_opt__perform_optimization__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__perform_optimization__closure_t> (this);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::perform_optimization);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__perform_optimization__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< opt_result > &res = __cls->_stack.res;   switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_opt__perform_optimization__label_1;     break;   default:     break;   }
# 803 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

    
    cur_iteration++;

    DPRINTF(DEBUG_OPT, debug_sep);
   
    
# 809 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 809 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

	pick_op_descs((++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(err), TTT( res)>, __cls_r, 1, pointer_set2_t<TTT(err), TTT( res)> (&(err), &( res))))); 
    
# 811 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_opt__perform_optimization__label_1:     ;
# 811 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"


    if (err) {
	warnx << "Error in optimization\n";
	
# 815 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
return ;
    }
    
    if (res->missing_xdisk_hints && !disk_busy) {
	disk_busy = true;
	//mat.delete_row_start(res->opid);
	xfplugins[XDISK]->get_chunks(res->missing_xdisk, res->missing_xdisk_hints,
				     wrap(this, &xferPlugin_opt::get_chunks_cb, res->opid, XDISK));
    }

    if (res->missing_net) {
	if (prev_missing_net && res->cancel) 
	    xfplugins[NET]->cancel_chunks(prev_missing_net);
	if (res->cancel)
	    prev_missing_net = res->prev_miss_net;

	xfplugins[NET]->get_chunks(res->missing_net, res->missing_net_hints,
				   wrap(this, &xferPlugin_opt::get_chunks_cb, res->opid, NET));
    }
    
    DPRINTF(DEBUG_OPT, debug_sep);
# 836 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 836 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

void
xferPlugin_opt::pick_xdisk_bfs_op(ptr<opt_result> res)
{
    res->missing_xdisk = NULL;
        
    ds_entry *dse = mat.desc_store.first();
    os_entry *ose = mat.op_store.first();
    //no more descriptors or ops
    if (!dse || !ose) {
#ifdef PROFILING
	double avg = -1;
	double avg1 = -1;
	
	if (num_filter > 0)
	    avg = sum_filter/num_filter;
	if (num_nofilter > 0)
	    avg1 = sum_nofilter/num_nofilter;
	
	DPRINTF(DEBUG_OPT, "FILTER TIME %f || COMPLETE TIME %f\n", avg, avg1);
#endif
	
	return;
    }

    str opid;
    ose = mat.hash_q.first;
    if (!ose) {
	ose = mat.stat_q.first;
	if (!ose) {
	    warnx << "There are no more ops\n";
	    return;
	}
	else
	    mat.stat_q.remove(ose);
    }
    else
	mat.hash_q.remove(ose);
    
    opid = ose->id;
    res->opid = opid;

    if (!disk_busy) {
	
	res->missing_xdisk  = New refcounted<vec<dot_descriptor> >; 
/* 	while (dse != NULL) { */
/* 	    res->missing_xdisk->push_back(dse->dd); */
/* 	    dse = mat.desc_store.next(dse); */
/* 	} */
	
	res->missing_xdisk_hints = New refcounted<hv_vec >;
	ref<vec<oid_hint > > new_hint = New refcounted<vec<oid_hint > > ;
	oid_hint h;   hint_res r;
	r.hint2 = opid;
	make_hint(r, "intern", &h);
	new_hint->push_back(h);
	res->missing_xdisk_hints->push_back(new_hint);
	
	DPRINTF(DEBUG_OPT,"xferPlugin_opt::pick_xdisk_bfs_op: picking xdisk bfs op %s with hint %s\n",
		opid.cstr(), h.name.cstr());
    }
}


# 901 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__pick_op_descs__closure_t : public closure_t { public:   xferPlugin_opt__pick_op_descs__closure_t (xferPlugin_opt *_self,  callback< void  ,  str  ,  ptr< opt_result > >::ref cb) : closure_t (false), _self (_self),  _stack (cb), _args (cb) {}   typedef void  (xferPlugin_opt::*method_type_t) ( callback< void  ,  str  ,  ptr< opt_result > >::ref , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.cb, mkref (this));   }   struct stack_t {     stack_t ( callback< void  ,  str  ,  ptr< opt_result > >::ref cb) {}   };   struct args_t {     args_t ( callback< void  ,  str  ,  ptr< opt_result > >::ref cb) : cb (cb) {}      callback< void  ,  str  ,  ptr< opt_result > >::ref cb;   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 901 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::pick_op_descs( callback< void  ,  str  ,  ptr< opt_result > >::ref __tame_cb, ptr<closure_t> __cls_g)
{
# 903 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__pick_op_descs__closure_t *__cls;   ptr<xferPlugin_opt__pick_op_descs__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__pick_op_descs__closure_t> (this, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::pick_op_descs);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__pick_op_descs__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    callback< void  ,  str  ,  ptr< opt_result > >::ref &cb = __cls->_args.cb;    use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 903 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

#ifdef PROFILING
    double time = return_time(SECONDS);
#endif

    total_opt_calls++;
    
    ptr<opt_result> res = New refcounted<opt_result>;

    if (pressure_from_client() || pressure_from_network()) {
	skip_pressure_calls++;
	if (net_scheduled < MIN_BLOCKS) {
	    pick_block_alloc(res, false);
	}
	(*cb)(NULL, res);
	
# 918 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
return ;
    }

    if (mode == BFS_WHOLE) {
	if (!disk_busy) {
	    pick_xdisk_bfs_op(res);
	    
#ifdef PROFILING
	    double time1 = return_time(SECONDS);
	    time = time1 - time;
	    sum_nofilter += time;
	    num_nofilter++;
	    DPRINTF(DEBUG_OPT, "XDISKTime %f\n", time);
	    DPRINTF(DEBUG_OPT, "Computing Time %f\n", time);
#endif
	    
	}

	if (net_scheduled < MIN_BLOCKS) {
	    pick_block_alloc(res, false);
	}
	
	(*cb)(NULL, res);
	
# 941 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
return ;
    }

    DPRINTF(DEBUG_OPT, "xferPlugin_opt::pick_op_descs: change %f %d\n",
	     cur_change_chunks, prev_pending_chunks);

    bool filter = filter_computation();
    if (filter) {
	skip_thresh_calls++;
	if (!disk_busy) {
	    pick_xdisk_op(res, false);
	}

	if (net_scheduled < MIN_BLOCKS) {
	    pick_block_alloc(res, false);
	}
    	
#ifdef PROFILING
	time = return_time(SECONDS) - time;
	DPRINTF(DEBUG_OPT, "Skipping Time %f\n", time);
	sum_filter += time;
	num_filter++;
#endif
	(*cb)(NULL, res);
	
# 965 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
return ;
    }

    perform_opt_calls++;
    pick_xdisk_op(res, true);

#ifdef PROFILING
    double time1 = return_time(SECONDS);
    DPRINTF(DEBUG_OPT, "XDISKTime %f\n", time1-time);
#endif

    if (mode == OPT_WHOLE)
	pick_block_alloc(res, false);
    else
	pick_block_alloc(res, true);
    
#ifdef PROFILING
    double time2 = return_time(SECONDS);
    DPRINTF(DEBUG_OPT, "NETTime %f\n", time2-time1);
    time = time2 - time;
#endif

#ifdef PROFILING
    sum_nofilter += time;
    num_nofilter++;
    
    DPRINTF(DEBUG_OPT, "Computing Time %f\n", time);
#endif
    
    (*cb)(NULL, res);
# 995 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 995 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

bool
xferPlugin_opt::filter_computation()
{
    if (!opt_now)
	return(true);
    
    assert(mode != BFS_WHOLE);
    
    if (mode == OPT_WHOLE) {
	if (disk_busy)
	    return true;
    }
    
    if (prev_pending_chunks <= 0) {
	prev_pending_chunks = mat.desc_store.size();
	cur_change_chunks = 0;
	return false;
    }

    int perc_change = (100 * (int) cur_change_chunks) / prev_pending_chunks;

    DPRINTF(DEBUG_OPT, "Perc_change is %d\n", perc_change);
    
    if (perc_change > THRESH_CHANGE) {
	prev_pending_chunks = mat.desc_store.size();
	cur_change_chunks = 0;
	return false;
    }
    else
	return true;

    prev_pending_chunks = mat.desc_store.size();
    cur_change_chunks = 0;
    return false;
}

void
xferPlugin_opt::cost_per_block(os_entry * ose)
{
    float sum_p = 0;
    float sum_cost = 0;
    ose->sum_p = 0;
    ose->sum_cp = 0;
    ose->cpb = LARGE_COST;

    assert(mode != BFS_WHOLE);
    //bindu
    //return;
    //double time = return_time(SECONDS);

    if (ose->type == DISK_CHIT) {
	ht_entry *hte = mat.hint_store.first();
	while (hte != NULL) {
	    float p = ose->get_benefit(hte);
	    sum_p += p;
	    hte = mat.hint_store.next(hte);
	}
		
	sum_cost = ose->get_xfer_cost(hte) * sum_p;

	ose->sum_p = sum_p;
	ose->sum_cp = sum_cost;
		
	if (ose->sum_p != 0) {
	    ose->cpb = (ose->op_cost + ose->sum_cp)/(ose->sum_p);
	}
    }

    if (ose->type == DISK_HASH) {
	ht_entry *hte = mat.hint_store.first();
	while (hte != NULL) {
	    float p = ose->get_benefit(hte);
	    sum_p += hte->counter * p;
	    hte = mat.hint_store.next(hte);
	}

	ose->sum_p = sum_p;
	ose->sum_cp = sum_cost;
		
	if (ose->sum_p != 0) {
	    ose->cpb = (ose->op_cost + ose->sum_cp)/(ose->sum_p);
	}
    }

    if (ose->type == DISK_STAT) {
	
	double adj = -1;
	
	ht_entry *hte = mat.hint_store.first();
	while (hte != NULL) {
	    float p = ose->get_benefit(hte);
	    sum_p += hte->counter * p;
	    if (p > 0) {
		if (adj == -1)
		    adj = CHUNK_READ_HASH_COST/p;
		else
		    adj = min(adj, CHUNK_READ_HASH_COST/p);
	    }
	    
	    hte = mat.hint_store.next(hte);
	}

	ose->sum_p = sum_p;
	ose->sum_cp = sum_cost;

	if (ose->sum_p != 0) {
	    ose->cpb = (ose->op_cost)/(ose->sum_p);
	}
	ose->cpb += ADJ_WT * adj;
    }
    
    //time = return_time(SECONDS) - time;
    //fprintf(stderr, "CPBTime %f\n", time);
    DPRINTF(DEBUG_OPT & DEBUG_L1, "cost_per_block for %s is %f || %f %f %f\n", ose->id.cstr(),
	    ose->cpb, (ose->sum_cp + ose->op_cost), ose->sum_cp, ose->sum_p);
}

void
xferPlugin_opt::desc_avail(ht_entry * hte, ptr<vec<str > > r)
{
    os_entry *ose;
    float p_prod = 1;
    float avail = 0; //LARGE_COST;
    float p, cost;
   
    assert(mode != BFS_WHOLE && mode != OPT_WHOLE);
    //bindu
    //dse->avail = avail;
    //return;
    //double time = return_time(SECONDS);
        
    //sorted order of ops
    //the formula is Cop1 + (1-p1)Cop2 + (1-p1)(1-p2)Cop2+....
    //we let it fall off the end
    unsigned int k = r->size();
    for (unsigned int i = 0; i < k; i++) {
	ose = mat.op_store[(*r)[i]];
	cost = ose->op_cost + ose->sum_cp;
	avail += p_prod * cost;
	//fprintf(stderr, "Expression is %f * %f", p_prod, cost);
	//bindu
	//p = 0;

	p = ose->get_benefit(hte);
	p_prod = p_prod * (1-p);
    }

    hte->avail = avail;

    //time = return_time(SECONDS) - time;
    //fprintf(stderr, "DATime %f\n", time);
    //str buf = strbuf() << dse->desc;
    //fprintf(stderr, "Avail for %s is %f\n", buf.cstr(), avail);
}

void
xferPlugin_opt::pick_xdisk_op(ptr<opt_result> res, bool compute)
{
    double THRESHOLD_COST_CHANGE = 0.001;
	
    res->missing_xdisk = NULL;
        
    ds_entry *dse = mat.desc_store.first();
    os_entry *ose = mat.op_store.first();
    //no more descriptors or ops
    if (!dse || !ose) {
#ifdef PROFILING
	double avg = -1;
	double avg1 = -1;
	
	if (num_filter > 0)
	    avg = sum_filter/num_filter;
	if (num_nofilter > 0)
	    avg1 = sum_nofilter/num_nofilter;
	
	DPRINTF(DEBUG_OPT, "FILTER TIME %f || COMPLETE TIME %f\n", avg, avg1);
#endif
	///*DPRINTF(DEBUG_OPT,*/ fprintf(stderr, "TOTAL %d , XDISK %d || NET %d\n", total_blocks, xdisk_blocks, net_blocks);
	return;
    }

    double time = return_time(SECONDS);
    str opid;
    if (compute) {
	
	while (ose != NULL) {
	    if (ose->type >= SET_XFER) {
		//not xdisk op
		ose = mat.op_store.next(ose);
		continue;
	    }
	    
	    //update only old ops
	    if (ose->it_num != cur_iteration) {
		cost_per_block(ose);
		ose->it_num = cur_iteration;
	    }
	    
	    ose = mat.op_store.next(ose); 
	}
	
	mat.refresh_rows_complete();
	ose = mat.extract_min_row();
    }
    else {
	while (1) {
	    ose = mat.extract_min_row();
	    mat.heap->heap_pop(ose);

	    if (ose->it_num == cur_iteration)
		break;
	    
	    double c = ose->cpb;

	    cost_per_block(ose);
	    ose->it_num = cur_iteration;
	    
	    double diff = ose->cpb - c;
	    if (diff < 0)
		diff = -1*diff;
	    //old cost is the almost the same as new cost
	    if (diff < THRESHOLD_COST_CHANGE)
		break;

	    DPRINTF(DEBUG_OPT, "Diff is %f for %s\n", diff, ose->id.cstr());
	    mat.heap->heap_insert(ose);  
	    	    
	    os_entry *os_new = mat.extract_min_row();
	    //the second condition is because
	    //the heap top when values are equal
	    //is undeterministic
	    if (os_new->id == ose->id) { // || ose->cpb == os_new->cpb) {
		mat.heap->heap_pop(ose);
		break;
	    }
	}
    }

    opt_time = return_time(SECONDS) - time;
    if (compute)
	/*DPRINTF(DEBUG_OPT, */fprintf(stderr, "FULL %f\n", opt_time);
    else
	DPRINTF(DEBUG_OPT, "PARTIAL %f\n", opt_time);
	
    opid = ose->id;
    res->opid = opid;

    if (!disk_busy) {
	res->missing_xdisk  = New refcounted<vec<dot_descriptor> >; 
	res->missing_xdisk_hints = New refcounted<hv_vec >;
	ref<vec<oid_hint > > new_hint = New refcounted<vec<oid_hint > > ;
	oid_hint h;   hint_res r;
	r.hint2 = opid;
	make_hint(r, "intern", &h);
	new_hint->push_back(h);
	res->missing_xdisk_hints->push_back(new_hint);
	
	DPRINTF(DEBUG_OPT, "xferPlugin_opt::pick_xdisk_op: picking xdisk op %s with hint %s\n",
		 opid.cstr(), h.name.cstr());
    }

}

void
xferPlugin_opt::pick_single_block(ptr<opt_result> res)
{
    res->missing_net = NULL;
    res->missing_net_hints = NULL;
    assert(res->cancel == false);

    DPRINTF(DEBUG_OPT, "Trying to fill netq since sched is %d\n", net_scheduled);
    
    ds_entry *dse = mat.desc_store.first();
    if (dse != NULL) {
	res->missing_net = New refcounted<vec<dot_descriptor> >;
	res->missing_net_hints = New refcounted<hv_vec >;
    }
    else {
	return;
    }

    int size = mat.s.size();
    int ht_size = -1;
    ht_entry *hte;

    //warnx << "Size is " << size << " and last is " << mat.index_set.hint
    //  << " " << mat.index_set.desc << "\n";

    int start_index = mat.index_set.hint;
    int start_in = mat.index_set.desc+1;
    
    for (int i = start_index; i < size; i++) {

	hte = mat.s[i]; 
	if (!hte) continue;
	mat.index_set.hint = i;

	ht_size = hte->desc_vec->size();
	for (int j = start_in; j < ht_size; j++) {

	    if (net_scheduled >= MIN_BLOCKS) break;
	    
	    dse = (*(hte->desc_vec))[j];
	    if (!dse) continue;
	    
	    net_scheduled++;
	    
#ifdef GTC_SUPPORT
	    if (dse->ask) continue;
#endif
	    ptr<vec<oid_hint > > hint = New refcounted<vec<oid_hint > >;
	    unsigned int hsize = dse->hint_ptr->oidhint->size();
	    dwarn(DEBUG_OPT) << "pick_single_alloc sending " << dse->desc << "\n";
	    for (unsigned int lik = 0; lik < hsize; lik++) {
		//warnx << "Hint is " << (*(dse->oidhint))[lik].name << "\n";
		hint->push_back((*(dse->hint_ptr->oidhint))[lik]);
	    }
	    
	    res->missing_net->push_back(dse->dd);
	    res->missing_net_hints->push_back(hint);
	    
	    if (prev_missing_net)
		prev_missing_net->push_back(dse->dd);
	    
#ifdef GTC_SUPPORT
	    //PENDING++;
	    dse->ask = true;
#endif
	    mat.index_set.desc = j;
	}

	start_in = 0;
	if (net_scheduled >= MIN_BLOCKS) break;
    }

    if (mode == OPT_WHOLE || mode == BFS_WHOLE) {
	if (mat.index_set.hint == size - 1 &&
	    mat.s.size() > 0 && mat.index_set.desc == ht_size - 1) {
	    DPRINTF(DEBUG_OPT, "I am clearing my self\n");
	    mat.s.clear();
	    mat.index_set.hint = 0;
	    mat.index_set.desc = -1;
	}
    }
	
    DPRINTF(DEBUG_OPT, "Filled netq to atleast %d\n", net_scheduled);
    return;
}

void
xferPlugin_opt::pick_block_alloc(ptr<opt_result> res, bool compute)
{
    if (!compute) {
	pick_single_block(res);
	return;
    }
	
    res->missing_net = NULL;
    res->missing_net_hints = NULL;
    res->prev_miss_net = NULL;
    res->cancel = true;
    
    ds_entry *dse = mat.desc_store.first();
    if (dse != NULL) {
	res->missing_net = New refcounted<vec<dot_descriptor> >;
	res->missing_net_hints = New refcounted<hv_vec >;
	//clear out the previous
	//generate set to cancel
	res->prev_miss_net = New refcounted<vec<dot_descriptor> >;
    }
    else
	return;
    
    ptr<vec<str > > r = New refcounted<vec<str > >;
    mat.sort_rows(r);

    ht_entry *hte = mat.hint_store.first();
    while (hte != NULL) {
	desc_avail(hte, r);
	hte = mat.hint_store.next(hte);
    }

    mat.sort_cols();
    
    int size = mat.s.size();
    int tosend = 0;

    for (int i = 0; i < size; i++) {
	
	hte = mat.s[i];
	
	if (!hte) continue;

	mat.index_set.hint = i;
	int ht_size = hte->desc_vec->size();
	
	for (int j = 0; j < ht_size; j++) {

	    if (tosend >= MIN_BLOCKS) break;
	    
	    dse = (*(hte->desc_vec))[j];
	    if (!dse) continue;

	    tosend++;

	    dwarn(DEBUG_OPT & DEBUG_L1) << "looking at " << hte->num << " and " << i << " " << j << "\n";
	    dwarn(DEBUG_OPT & DEBUG_L1) << "sending at " << dse->hint_ptr->num << " " << dse->hint_index << "\n";
	    
	    
#ifdef GTC_SUPPORT
	    if (dse->ask) continue;	  
#endif
	    dwarn(DEBUG_OPT) << "pick_block_alloc sending " << dse->desc << "\n";
	    
	    ptr<vec<oid_hint > > hint = New refcounted<vec<oid_hint > >;
	    unsigned int hsize = dse->hint_ptr->oidhint->size();
	    for (unsigned int lik = 0; lik < hsize; lik++) {
		//warnx << "Hint is " << (*(dse->oidhint))[lik].name << "\n";
		hint->push_back((*(dse->hint_ptr->oidhint))[lik]);
	    }
	    
	    res->missing_net->push_back(dse->dd);
	    res->missing_net_hints->push_back(hint);
	    
	    res->prev_miss_net->push_back(dse->dd);
	    
#ifdef GTC_SUPPORT
	    dse->ask = true;
#endif
	    mat.index_set.desc = j;

	    if (tosend >= MIN_BLOCKS) break;
	    	    
	} //for j;

	if (tosend >= MIN_BLOCKS) break;
	
    } //for i

    net_scheduled = tosend;

    DPRINTF(DEBUG_OPT, "Compute filled netq to atleast %d\n", net_scheduled);
    return;
}

void 
xferPlugin_opt::cancel_chunk(ref<dot_descriptor> d)
{
    fatal << "xferPlugin_opt::cancel_chunk: called\n";
}

void 
xferPlugin_opt::cancel_chunks(ref< vec<dot_descriptor> > dv)
{
    fatal << "xferPlugin_opt::cancel_chunks: called\n";
}

void 
xferPlugin_opt::get_default_hint(oid_hint *hint)
{
    //warn << "xferPlugin_opt::get_default_hint: called\n";
    xfplugins[NET]->get_default_hint(hint);
}

void 
xferPlugin_opt::notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs)
{
    //warn << "xferPlugin_opt::notify_descriptors: called\n";
    unsigned int num_of_plugins = xfplugins.size();
    for (unsigned int i = 0; i < num_of_plugins; i++) {
	xfplugins[i]->notify_descriptors(oid, descs);
    }
}

void 
xferPlugin_opt::update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints)
{
    fatal << "xferPlugin_opt::update_hints: called\n";
}

# 1477 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
class xferPlugin_opt__get_bitmap__closure_t : public closure_t { public:   xferPlugin_opt__get_bitmap__closure_t (xferPlugin_opt *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_opt::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  bitmap_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      bitmap_cb cb;   };   xferPlugin_opt *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1477 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
void 
xferPlugin_opt::get_bitmap( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  bitmap_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 1479 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  xferPlugin_opt__get_bitmap__closure_t *__cls;   ptr<xferPlugin_opt__get_bitmap__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_opt__get_bitmap__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_opt::get_bitmap);   } else {     __cls =     reinterpret_cast<xferPlugin_opt__get_bitmap__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    bitmap_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 1479 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"

    dwarn(DEBUG_OPT) << "xferPlugin_opt::get_bitmap: called\n";
    xfplugins[NET]->get_bitmap(oid, hints, cb);
# 1482 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
  return;
# 1482 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_opt.T"
}

xferPlugin_opt::xferPlugin_opt(gtcd *m, xferPlugin *next_xp) :
    m(m), disk_busy(false), net_scheduled(0)
{
    assert(m);
    cur_change_chunks = 0;
    prev_pending_chunks = 0;
    cur_iteration = 0;
    prev_missing_net = NULL;

    delaycb(REOPT_TIME_SEC, REOPT_TIME_NSEC,
	    wrap(this, &xferPlugin_opt::schedule_optimization));
}

void
xferPlugin_opt::schedule_optimization()
{
    double TIME_THRESHOLD = 10;
	
    ds_entry *dse = mat.desc_store.first();
    if (dse) {
	opt_now = true;
	perform_optimization();
    }
    else {
	fprintf(stderr, "TOTAL %d , XDISK %d || NET %d\n", total_blocks, xdisk_blocks, net_blocks);
	fprintf(stderr, "CALLS %d , THRESH %d || PRESSURE %d PERFORM %d\n", total_opt_calls, skip_thresh_calls,
		skip_pressure_calls, perform_opt_calls);
    }

    opt_now = false;
    REOPT_TIME_SEC = (int) (TIME_THRESHOLD * opt_time);
    if (REOPT_TIME_SEC == 0)
	REOPT_TIME_SEC = 1;
    delaycb(REOPT_TIME_SEC, REOPT_TIME_NSEC,
	    wrap(this, &xferPlugin_opt::schedule_optimization));
}

/*TODO
1. IMP - hv_vec structures that are updated are from gtcd.
2. deleting rows in cost matrix when all chunks are fetched
3. deleting from uo_entry
4. consolidate get_costs in net by using add_costs etc
5. get_hints in get_costs in net
6. async notification of hints
7. update_info for dse to ignore existing hints -> double for loop

NEED  to fix hints in cache hint group that go to xfer etc
*/
