/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#ifndef _XFER_NOOP_H_
#define _XFER_NOOP_H_

#include "xferPlugin.h"
#include "gtcd.h"
#include "xferPlugin_gtc_prot.h"

class xferPlugin_noop : public xferPlugin {
  
private:
    gtcd *m;
    xferPlugin *xp;

public:
    bool configure(str s) { return true; }
    
    /* This should only be called after initialization */
    void get_default_hint(oid_hint *hint);

    /* Calls from the GTC */
    void get_descriptors(ref<dot_oid_md> oid, ref<vec<oid_hint> > hints,
			 descriptors_cb cb, CLOSURE);
    void get_bitmap(ref<dot_oid_md> oid, ref<vec<oid_hint> > hints,
		    bitmap_cb cb, CLOSURE);
    void notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs);
    void get_chunk(ref<dot_descriptor> d, ref<vec<oid_hint> > hints,
                   chunk_cb cb, CLOSURE);
    void get_chunks(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints,
		    chunk_cb cb, CLOSURE);

    void cancel_chunk(ref<dot_descriptor> d);
    void cancel_chunks(ref< vec<dot_descriptor> > dv);

    void update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints);
    
    xferPlugin_noop(gtcd *m, xferPlugin *next_xp) : m(m), xp(next_xp)
        { assert(m); assert(xp); }
    ~xferPlugin_noop() { }

 private:
    void get_descriptors_cb(descriptors_cb cb1, str s, ptr<vec<dot_descriptor> > descs, bool end);
    void get_bitmap_cb(bitmap_cb cb1, str s, ptr<bitvec> bmp);
      
};


#endif /* _XFER_NET_H_ */
