
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "xferPlugin_net.h"

static ihash<const dot_oid, oid_netcache_entry, &oid_netcache_entry::oid, &oid_netcache_entry::hlink, do_hash> oidCache;

static oid_hint glob_hint;
extern int odht_port;
extern str odht_ip;

//cache to cache sources per chunk
static ihash<const dot_desc, chunk_cache_entry, &chunk_cache_entry::cid, &chunk_cache_entry::hlink, dd_hash> chunkCache;

//---------------------------------------------------------------------
hint_cache::hint_cache(oid_hint h, str k)
    : hint(h), name(k)
{
    //warn << "hint_cache::hint_cache: Creating hint_cache for " << name << "\n";
}

hint_cache::~hint_cache()
{
    warn << "hint_cache::~hint_cache: Deleting hint_cache for " << name << "\n";
}

//---------------------------------------------------------------------
chunk_cache_entry::chunk_cache_entry(const dot_desc o)
    : cid(o) 
{
    //warn << "chunk_cache_entry::chunk_cache_entry: Creating chunk_cache_entry for " << cid << "\n";
    chunkCache.insert(this);
}

chunk_cache_entry::~chunk_cache_entry()
{
    warn << "chunk_cache_entry::~chunk_cache_entry: Deleting chunk_cache_entry for "
	 << cid << "\n";
    //remove all the hints in the hints_hash too
    hint_cache *drpc;

    while ((drpc = hints_hash.first()) != NULL) {
	warn << "chunk_cache_entry::~chunk_cache_entry: for " << drpc->name <<"\n";
	hints_hash.remove(drpc);
	delete drpc;
    }
    
    chunkCache.remove(this);
}

//---------------------------------------------------------------------
src_info::src_info(oid_hint h, dot_oid oidin, unsigned int size)
{
    hint = h;
    
    strbuf key1;
    hint_res result;
    if (parse_hint(h.name, "gtc", &result) < 0)
	fatal << "No hints in src_info \n";
    key1 << result.hint.hostname << ":" << result.hint.port;
    key = key1;

    time = -1;

    oid = oidin;

    inprogress = false;
    
    bmp = New refcounted<bitvec>(size);

    hints_arg = New refcounted<vec<oid_hint> >;
    hints_arg->push_back(hint);

    oid_arg = New refcounted<dot_oid_md>();
    oid_arg->id = oid;
    
    //warn << "src_info::src_info: Creating src_info for " << key << "\n";
    
}

src_info::~src_info()
{
  //warn << "src_info::~src_info: Deleting src_info for " << key << "\n";
}

//---------------------------------------------------------------------

oid_netcache_entry::oid_netcache_entry(const dot_oid o, update_cb cbin, gtcd *min)
    : oid(o), slist(New refcounted<ordered_descriptor_list>),
      shingles_done(0), oids_done(0), oid_insert_done(0), cb(cbin), m(min)
{
    next_event = false;
    ident_count = 0;
    sim_count = 0;
    //warnx << "oid_netcache_entry::oid_netcache_entry: Creating oid_netcache_entry for " << oid << "\n";
    oidCache.insert(this);
}

oid_netcache_entry::~oid_netcache_entry()
{
    //warnx << "oid_netcache_entry::~oid_netcache_entry: Deleting oid_netcache_entry for " << oid << "\n";
    oidCache.remove(this);
}

void
oid_netcache_entry::net_lookup()
{
    dht_get_cb cb1 = wrap(this, &oid_netcache_entry::get_fp_oids_done);
    
    dwarn(DEBUG_SET) << debug_sep
		     << "oid_netcache_entry::net_lookup: finding shingles for "
		     << oid << "\n";
    
    // Output items in priority_queue using top()
    // and use pop() to get to next item until
    // priority_queue is empty
    
    shingles_done = 0;
    while (!slist->empty()) {

	dot_desc ds = slist->top();
	
	dwarn(DEBUG_SET) << "Lookup shingle " << shingles_done
			 << " " << ds << "\n";
	ref<dht_rpc> dht = New refcounted<odht_rpc>(odht_ip, odht_port);
	status.push_back(dht);
	get_fp_oids(dht, ds, cb1);
	slist->pop();
	shingles_done++;
    }
    
    dwarn(DEBUG_SET) << "Looking up " << shingles_done << " shingles\n"
		     << debug_sep;
    
    //now lookup my own objectid
    oid_info *drpc = oidstatus[oid];
    if (drpc) {
	dwarn(DEBUG_SET) << "oid_netcache_entry::get_fp_oids_done: oidstatus already has this oid for further lookup... may be in progress\n";
    }
    else {
	dwarn(DEBUG_SET) << "Looking up object id " << oid << "\n";
	cbs cb1 = wrap(this, &oid_netcache_entry::net_lookup_oid_done, oid);
	drpc = New oid_info(oid, cb1, self_descs, m);
	dht_get_cb cb2 = wrap(drpc, &oid_info::get_oid_sources_done);
	oidstatus.insert(drpc);
	get_oid_sources(drpc->dht, drpc->oid, cb2);
	oids_done++;
    }
    
    //also start the process for inserting myself as a partial source
    oid_insert_done = 1;
    oidinsert_status = New refcounted<odht_rpc>(odht_ip, odht_port);
    put_oid_source(oidinsert_status, oid, glob_hint, wrap(this, &oid_netcache_entry::put_oid_source_done));


    //timer for refreshing bitmaps
    delaycb(REFRESH_BITMAP, 0, wrap(this, &oid_netcache_entry::get_bitmap_refresh));
    
}

void
oid_netcache_entry::net_lookup_refresh()
{
    //reset variables
    next_event = false;
    shingles_done = 0;
    oids_done = 0;
    oid_insert_done = 0;
    
    oid_info *drpc = oidstatus.first();
    
    while (drpc != NULL) {
	dht_get_cb cb2 = wrap(drpc, &oid_info::get_oid_sources_done);
	get_oid_sources(drpc->dht, drpc->oid, cb2);
	drpc = oidstatus.next(drpc);
	oids_done++;
    }
}

void
oid_netcache_entry::get_fp_oids_done(str err, ptr<vec<bamboo_value> > results)
{
    if (err) {
	dwarn(DEBUG_SET|DEBUG_ERRS) << "oid_netcache_entry::get_fp_oids_done: look up has an error "
 	     << err <<"\n";
    }
    else {

	dwarn(DEBUG_SET) << "oid_netcache_entry::get_fp_oids_done: success\n";
	
	for (unsigned int i = 0; i < results->size(); i++) {
	    
	    odht_val res;
	    oid_info_odht obj;
	    
	    bytes2xdr(res, (*results)[i]);
	    
	    if (res.ok) {
		dwarn(DEBUG_SET) << "oid_netcache_entry::get_fp_oids_done: GETTING VALUES THAT ARE OIDs \n";
		continue;
	    }
	    
	    obj = *(res.cid_info);
	    
	    if (obj.appnum != APPDOT_VERSION) {
		dwarn(DEBUG_SET) << "odht_getcid_rpc::get_fp_oids_done: GETTING VALUES THAT ARE NOT MINE " << obj.appnum << "\n";
		continue;
	    }
	    
	    dwarn(DEBUG_SET) << "OID is " << obj.oid << "\n";

	    oid_info *drpc = oidstatus[obj.oid];
	    if (drpc) {
		dwarn(DEBUG_SET) << "oid_netcache_entry::get_fp_oids_done: oidstatus already has this oid for further lookup... may be in progress\n";
	    }
	    else {
		dwarn(DEBUG_SET) << "oid_netcache_entry::get_fp_oids_done: Starting lookup for " << obj.oid << "\n";
		
		oids_done++;

		cbs cb1 = wrap(this, &oid_netcache_entry::net_lookup_oid_done, obj.oid);
		drpc = New oid_info(obj.oid, cb1, NULL, m);
		dht_get_cb cb2 = wrap(drpc, &oid_info::get_oid_sources_done);
		oidstatus.insert(drpc);
		get_oid_sources(drpc->dht, drpc->oid, cb2);
	    }
	}
	
	dwarn(DEBUG_SET) << debug_sep;
    }

    shingles_done--;

    if (shingles_done <= 0 && oids_done <= 0 && oid_insert_done <= 0) {
	
	//can get rid of cid objects and insert object
	
	//keep the oid objects to refresh the lookup
	if (!next_event) {
	    delaycb(REFRESH_OID_LOOKUP, 0, wrap(this, &oid_netcache_entry::net_lookup_refresh));
	    next_event = true;
	}
    }
}

static int
gtc_hint_to_name(str hint, str *name)
{
    hint_res result;
    if (parse_hint(hint, "gtc", &result) < 0)
	return -1;
    
    *name = strbuf() << result.hint.hostname << ":" << result.hint.port;
    return 0;
}

void
oid_netcache_entry::pick_sources(dot_oid other_oid)
{
    oid_info *drpc = oidstatus[other_oid];

    src_hash *srcs;
    unsigned int *src_count;
    int src_limit;

    if (other_oid == oid) {
	srcs = &ident_srcs;
	src_count = &ident_count;
	src_limit = MAX_PEERS_ALBT - ident_count;
    } else {
	srcs = &sim_srcs;
	src_count = &sim_count;
	src_limit = MAX_PEERS_ALBT - (ident_count + sim_count);
    }
    if (src_limit <= 0) return;
    
    ref<vec<oid_hint> > new_hints = New refcounted<vec<oid_hint> >;
	
    for (unsigned int i = 0; i < drpc->hints->size(); i++) {
	str src_name;
	if (gtc_hint_to_name((*(drpc->hints))[i].name, &src_name)) {
	    fatal << "No hints in pick_sources from\n";
	}
	
	src_info *src = (*srcs)[src_name];
	    
	if (!src) {
	    new_hints->push_back((*(drpc->hints))[i]);
	}
	
	/* only for similar sources */
	/* This is because the same host:port could be serving two similar files
	   and get_bitmap is per oid...so we have another entry to ask for the
	   other similar object*/
	if (src && (other_oid != oid) && src->oid != other_oid) {
	    new_hints->push_back((*(drpc->hints))[i]);
	}
    }

    /* Insert at most src_limit new hints */
    unsigned int nwanted = src_limit;
    unsigned int newhint = 0;
    unsigned int nleft = new_hints->size();
	
    while (nwanted > 0 && nleft > 0) {
	if ((arandom() % nleft) < nwanted) {
	    src_info *src = New src_info((*(new_hints))[newhint], other_oid, drpc->descs->size());
	    srcs->insert(src);
	    *src_count = *src_count + 1;
	    nwanted--;
	}
	nleft--;
	newhint++;
    }
    
    //start getbitmap for everyone with -1 as time
    double cur_time = get_cur_time();

    for (src_info *src = srcs->first(); src; src = srcs->next(src)) {
	if (src->time < 0) {

	    //warn << "Getting bitmap for "<< src->key << "\n";

	    src->time = cur_time;
	    src->inprogress = true;
		
	    bitmap_cb cb_bmp = wrap(this, &oid_netcache_entry::get_bitmap_cb, src);
	    m->xp->get_bitmap(src->oid_arg, src->hints_arg, cb_bmp);
	}
    }
    dwarn(DEBUG_SET) << debug_sep;
}

void
oid_netcache_entry::get_bitmap_cb(src_info *src, str err, ptr<bitvec> bmp)
{
    src->inprogress = false;
    src->time = get_cur_time();
    
    if (err) {
	dwarn(DEBUG_SET|DEBUG_ERRS) << "oid_netcache_entry::get_bitmap_cb:: Error " << err << "\n";
	return;
    }

    assert(bmp->size() == src->bmp->size());
    
    //copy the bmp over
    unsigned int size = bmp->size(); 
    for (unsigned int i = 0; i < size; i++) {
        if ((*bmp)[i] == 1)
            (*src->bmp)[i] = 1;
    }

#ifdef HACK
    int match1 = 0;
    int match2 =0;
    int POS_INF = 3000000;
#endif
    
    oid_info *drpc = oidstatus[src->oid];
    
    ref<vec<dot_descriptor> > missing_descs = New refcounted<vec<dot_descriptor> >;
    ref<hv_vec> missing_hints = New refcounted<hv_vec> ;
    
    //match the descriptors and insert hints into chunk cache and call update finally
    size = drpc->bv->size(); 
    for (unsigned int i = 0; i < size; i++) {

#ifdef HACK
	if (((*(drpc->bv))[i] == 1))
	    match1++;
#endif
	
	if (((*(drpc->bv))[i] == 1) && ((*(src->bmp))[i] == 1)) {

#ifdef HACK
	    match2++;
#endif
	    // i am interested in this descriptor and it is present in this source
	    // add it as hint
	    ref<vec<oid_hint> > new_hints = New refcounted<vec<oid_hint> >;

	    bool fresh_hints = xferPlugin_net::insert_chunk_cache((*(drpc->descs))[i].id, src->hints_arg, new_hints);
	
	    dwarn(DEBUG_SET) << "Adding new hints for " << (*(drpc->descs))[i].id << " from " << src->key << "\n";
    
	    if (fresh_hints) {
		dwarn(DEBUG_SET) << "Really adding new hints for " << (*(drpc->descs))[i].id << "\n";
		missing_descs->push_back((*(drpc->descs))[i]);
		missing_hints->push_back(new_hints);
	    } //fresh_hints
	}
    }

#ifdef HACK
    if (match1 == match2) {
	//I got everything i need so don't refresh bitmap again and again
	src->time = src->time + POS_INF;
    }
#endif

    dwarn(DEBUG_SET) << "oid_netcache_entry::get_bitmap_cb:: Bitmap from "
		     << src->key << " with " << match1
		     << " blocks and has " <<  match2 << "blocks\n";
    
    if (missing_descs->size() > 0) {
	//update_hints call back deployed
	(*cb)(missing_descs, missing_hints);
    }

}

void
oid_netcache_entry::get_bitmap_refresh_sources(src_hash *srcs)
{
    //start getbitmap for everyone who have not gotten a refresh for T seconds
    double cur_time = get_cur_time();
    for (src_info *src = srcs->first(); src; src = srcs->next(src)) {
	assert(src->time != -1);
	
	if ((cur_time - src->time) >= REFRESH_BITMAP_ALBT && !(src->inprogress)) {
	    src->time = cur_time;
	    src->inprogress = true;
	    bitmap_cb cb_bmp = wrap(this, &oid_netcache_entry::get_bitmap_cb, src);
	    m->xp->get_bitmap(src->oid_arg, src->hints_arg, cb_bmp);
	}
    }
}

void
oid_netcache_entry::get_bitmap_refresh()
{
    //printf("Called get_bitmap_refresh at %.2f\n",cur_time);
    get_bitmap_refresh_sources(&sim_srcs);
    get_bitmap_refresh_sources(&ident_srcs);

    delaycb(REFRESH_BITMAP, 0, wrap(this, &oid_netcache_entry::get_bitmap_refresh));
}


void
oid_netcache_entry::net_lookup_oid_done(dot_oid other_oid, str err)
{ 
    oids_done--;
    
    if (err) {
	dwarn(DEBUG_SET|DEBUG_ERRS) << "oid_netcache_entry::net_lookup_oid_done: looking up OID "
	     << oid << " failed: " << err << "\n";
    }
    else {
	
      //warn << "oid_netcache_entry::net_lookup_oid_done: called for oid " << oid << " with other id "<< other_oid << "\n";

	oid_info *drpc = oidstatus[other_oid];
	
	if (!drpc->bv) {

	    drpc->bv = New refcounted<bitvec>((drpc->descs)->size());
	    //clear the bitvector
	    drpc->bv->setrange(0, drpc->bv->size(), 0);

	    unsigned int match = 0;
	
	    //match the descriptors and create a bitvector
	    for (unsigned int i = 0; i < self_descs->size(); i++) {
		
		for (unsigned int j = 0; j < (drpc->descs)->size() ; j++) {
		    
		    if ((*self_descs)[i].id == (*(drpc->descs))[j].id ) {
			
			match++;
			(*(drpc->bv))[j] = 1;

			//break;
			//no break because may be there is intrafile similarity
			
		    } //if
		}
	    } //for all chunks
	    
	    dwarn(DEBUG_SET) << "oid_netcache_entry::net_lookup_oid_done: matched " << match <<"\n";
	    
	} //drpc->bv does not exist

	//pick any sources we want from this new oid
	pick_sources(other_oid);
    }

    if (shingles_done <= 0 && oids_done <= 0 && oid_insert_done <= 0) {
	//can get rid of cid objects and insert object
	//keep the oid objects to refresh the lookup
	if (!next_event) {
	    delaycb(REFRESH_OID_LOOKUP, 0, wrap(this, &oid_netcache_entry::net_lookup_refresh));
	    next_event = true;
	}
    }
}
void
oid_netcache_entry::put_oid_source_done(str err)
{
    oid_insert_done = 0;

    if (err)
	dwarn(DEBUG_SET|DEBUG_ERRS) << "Partial OID status:: " << err << "\n";
    else
	dwarn(DEBUG_SET) << "Partial OID status:: Success\n";
    

    if (shingles_done <= 0 && oids_done <= 0 && oid_insert_done <= 0) {
	
	//can get rid of cid objects and insert object
	//keep the oid objects to refresh the lookup
	if (!next_event) {
	    delaycb(REFRESH_OID_LOOKUP, 0, wrap(this, &oid_netcache_entry::net_lookup_refresh));
	    next_event = true;
	}
    }
}

//--------------------------------------------------------------------

/*
 * OID info functions
 */

oid_info::oid_info(const dot_oid &oid, cbs cb, ptr<vec<dot_descriptor> > descs, gtcd *m)
    : oid(oid), cb(cb), descs(descs), m(m), hints(NULL), bv(NULL)
{
    dht = New refcounted<odht_rpc>(odht_ip, odht_port);
}

void
oid_info::get_oid_sources_done(str err, ptr<vec<bamboo_value> > results) 
{
    if (err) {
	strbuf sb;
	
	sb << "oid_info::get_oid_sources_done:: " << err << "\n";
	dwarn(DEBUG_SET|DEBUG_ERRS) << sb;
	
        //set status in parent
        (*cb)(sb);
        return ;
    }

    ptr<vec<oid_hint> > srcdata = New refcounted<vec<oid_hint> >;
    
    dwarn(DEBUG_SET) << "oid_info::get_oid_sources_done:: Results are --> \n";
    
    for (unsigned int i = 0; i < results->size(); i++) {
	
	odht_val res;
	
	bytes2xdr(res, (*results)[i]);
	    
	if (!res.ok) {
	    dwarn(DEBUG_SET) << "oid_info::get_oid_sources_done:: GETTING VALUES THAT ARE CIDs \n";
	    continue;
	}
	
	oid_hint_odht obj;
	    
	obj = *(res.oid_info);
	    
	if (obj.appnum != APPDOT_VERSION) {
	    dwarn(DEBUG_SET) << "oid_info::get_oid_sources_done:: GETTING VALUES THAT ARE NOT MINE or are CIDs "
		 << obj.appnum << "\n";
	    continue;
	}

	oid_hint obj1;
	strbuf buf;
	buf << "gtc://" << obj.hostname << ":" << obj.port;
	obj1.name = buf;
        
	dwarn(DEBUG_SET) << "oid_info::get_oid_sources_done:: hostname is " << obj.hostname << "\n";

	//if it is myself, skip it
	if (obj1.name == glob_hint.name) {
	    dwarn(DEBUG_SET) << "Skipping " << glob_hint.name << "\n";
	    continue;
	}
        
	//warn << "odht_getoid_rpc::finish_getoid:: hostname is " << obj.hostname << " and strlen is " << strlen(obj.hostname) << "\n";
	//warn << "odht_getoid_rpc::finish_getoid:: hostname is " << obj1.hostname << " and length is " << obj1.hostname.len() << "\n";
        
	srcdata->push_back(obj1);
	
	dwarn(DEBUG_SET) << debug_sep;
    }
    
    if (!hints)
	hints = srcdata;
    else {
	//have existing hints, append srcdata to the existing hints
	for (unsigned int i = 0; i < srcdata->size(); i++) {
	    
	    int found = -1;
		    
	    for (unsigned int j = 0; j < hints->size(); j++) {

		if ((*srcdata)[i].name == (*hints)[j].name) {
		    found = 1;
		    break;
		}
	    }
	    
	    //append hints
	    if (found == -1) {
		hints->push_back((*srcdata)[i]);
	    }
	}
    }
    
    if (descs == NULL) {
	
	dwarn(DEBUG_SET) << "oid_info::start_descriptors: Getting descriptors for " << oid << "\n";
	
	ref<dot_oid_md> new_oid = New refcounted<dot_oid_md>();
	
	new_oid->id = oid;
	
	m->xp->get_descriptors(new_oid, hints, wrap(this, &oid_info::get_descriptors_cb));
	
	return;
    }
    else
	dwarn(DEBUG_SET) << "Have Descriptors of my own\n";
    
    //set status in parent
    (*cb)(NULL);
} 

void
oid_info::get_descriptors_cb(str s, ptr<vec<dot_descriptor> > descsin, bool end)
{
    //warnx << "oid_info::get_descriptors_cb called back\n";
    
    if (s) {
		
	//CHECK
	descs = New refcounted<vec<dot_descriptor> >;
	
	dwarn(DEBUG_SET) << "oid_info::get_descriptors_cb " << s << "\n";
	(*cb)(s);
	return;
    }
    
    if (!descs) {
	descs = descsin;
    }
    else {
	*descs += *descsin;
    }
    
    if (end) {
	(*cb)(NULL);
    } 
}

//--------------------------------------------------------------------

void
xferPlugin_net::get_hints_chunk_cache(dot_desc cid, ref<vec<oid_hint > > hintsin)
{
  chunk_cache_entry *cce = chunkCache[cid];
  
  if (cce) {
      dwarn(DEBUG_SET) << debug_sep;
      dwarn(DEBUG_SET) << "xferPlugin_net::get_hints_chunk_cache: Cache hits for " << cid << "will be --> \n";
      
      hint_cache *he = cce->hints_hash.first();
      while (he != NULL) {

	  dwarn(DEBUG_SET) << "Hint is " << he->name << "\n" << debug_sep;
	  
	  hintsin->push_back(he->hint);
	  he = cce->hints_hash.next(he);
      }
  }
  else {
      //fatal << "I just put in hints\n";
  }
}


bool
xferPlugin_net::insert_chunk_cache(dot_desc cid, ptr<vec<oid_hint> > srcdata, ref<vec<oid_hint> > new_hints)
{
    chunk_cache_entry *cce = chunkCache[cid];
    
    if (cce) {
	//warn << "xferPlugin_net::insert_chunk_cache: chunkCache already has this cid for lookup\n";
    }
    else {
	//warn << "xferPlugin_net::insert_chunk_cache: Making entry for " << cid << "\n";
	cce = New chunk_cache_entry(cid);
    }
    
    bool isnew = false;
    
    //push the hints into cce
    for (unsigned int i = 0; i < srcdata->size() ; i++) {
    
	strbuf key;
	hint_res result;
	if (parse_hint((*srcdata)[i].name, "gtc", &result) < 0) {
	    //warn << "No hints in insert_chunk_cache from gtc\n";
	    continue;
	}
        key << result.hint.hostname << ":" << result.hint.port;

	hint_cache *he = cce->hints_hash[key];
	
	if (he)
	    continue;
	
	isnew = true;
	
	dwarn(DEBUG_SET) << "Inserting new hints " << key << "\n";
	
	he = New hint_cache((*srcdata)[i], key);
	
	cce->hints_hash.insert(he);
	
	//for now
	new_hints->push_back((*srcdata)[i]);
    }
    
    //data in chunkcache is
    //warn << "Cache hits will be --> \n";
    //hint_cache *he = cce->hints_hash.first();
    //while (he != NULL) {
	//warn << "Hint is " << he->name << "\n" << debug_sep;
		
	//he = cce->hints_hash.next(he);
    //}
    
    return(isnew);
    //true indicates that they are fresh hints
}

# 746 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
class xferPlugin_net__get_descriptors__closure_t : public closure_t { public:   xferPlugin_net__get_descriptors__closure_t (xferPlugin_net *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_net::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  descriptors_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      descriptors_cb cb;   };   xferPlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 746 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
void 
xferPlugin_net::get_descriptors( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  descriptors_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 748 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  xferPlugin_net__get_descriptors__closure_t *__cls;   ptr<xferPlugin_net__get_descriptors__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_net__get_descriptors__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_net::get_descriptors);   } else {     __cls =     reinterpret_cast<xferPlugin_net__get_descriptors__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    descriptors_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 748 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"

    //warnx << "xferPlugin_net::get_descriptors: called\n";
    
    xp->get_descriptors(oid, hints, cb);
# 752 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  return;
# 752 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
}

# 754 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
class xferPlugin_net__get_chunk__closure_t : public closure_t { public:   xferPlugin_net__get_chunk__closure_t (xferPlugin_net *_self,  ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (d, hints, cb), _args (d, hints, cb) {}   typedef void  (xferPlugin_net::*method_type_t) ( ref< dot_descriptor > ,  ref< vec< oid_hint > > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : d (d), hints (hints), cb (cb) {}      ref< dot_descriptor > d;      ref< vec< oid_hint > > hints;      chunk_cb cb;   };   xferPlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 754 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
void 
xferPlugin_net::get_chunk( ref< dot_descriptor > __tame_d,  ref< vec< oid_hint > > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 757 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  xferPlugin_net__get_chunk__closure_t *__cls;   ptr<xferPlugin_net__get_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_net__get_chunk__closure_t> (this, __tame_d, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_net::get_chunk);   } else {     __cls =     reinterpret_cast<xferPlugin_net__get_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 757 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"

    dwarn(DEBUG_SET) << "xferPlugin_net::get_chunk: called\n";
# 759 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  return;
# 759 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
}

# 761 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
class xferPlugin_net__get_chunks__closure_t : public closure_t { public:   xferPlugin_net__get_chunks__closure_t (xferPlugin_net *_self,  ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints1,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (dv, hints1, cb), _args (dv, hints1, cb) {}   typedef void  (xferPlugin_net::*method_type_t) ( ref< vec< dot_descriptor > > ,  ref< hv_vec > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.dv, _args.hints1, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints1,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints1,  chunk_cb cb) : dv (dv), hints1 (hints1), cb (cb) {}      ref< vec< dot_descriptor > > dv;      ref< hv_vec > hints1;      chunk_cb cb;   };   xferPlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 761 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
void 
xferPlugin_net::get_chunks( ref< vec< dot_descriptor > > __tame_dv,  ref< hv_vec > __tame_hints1,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 764 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  xferPlugin_net__get_chunks__closure_t *__cls;   ptr<xferPlugin_net__get_chunks__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_net__get_chunks__closure_t> (this, __tame_dv, __tame_hints1, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_net::get_chunks);   } else {     __cls =     reinterpret_cast<xferPlugin_net__get_chunks__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< vec< dot_descriptor > > &dv = __cls->_args.dv;    ref< hv_vec > &hints1 = __cls->_args.hints1;    chunk_cb &cb = __cls->_args.cb;    use_reference (dv);     use_reference (hints1);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 764 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"

    //warn << "xferPlugin_net::get_chunks: called\n";
    
    dot_desc cid;
    
    //first add the hints i have so far into chunk cache
    for (size_t j = 0; j < dv->size(); j++) {
	cid  = (*dv)[j].id;
	//allocated since insert_chunk_cache interface needs it
	//otherwise useless
	ref<vec<oid_hint> > new_hints = New refcounted<vec<oid_hint> >;
	insert_chunk_cache(cid, (*hints1)[j], new_hints);
    }

    //add my hints here per chunk
    for (size_t j = 0; j < dv->size(); j++) {
	cid  = (*dv)[j].id;
	(*hints1)[j]->clear();
	get_hints_chunk_cache(cid, (*hints1)[j]);
    }
    
    xp->get_chunks(dv, hints1, cb);
# 786 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  return;
# 786 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
}


void 
xferPlugin_net::cancel_chunk(ref<dot_descriptor> d)
{
    fatal << "xferPlugin_net::cancel_chunk: called\n";
}

void 
xferPlugin_net::cancel_chunks(ref< vec<dot_descriptor> > dv)
{
    //warn << "xferPlugin_net::cancel_chunks: called\n";
    xp->cancel_chunks(dv);
}

void 
xferPlugin_net::get_default_hint(oid_hint *hint)
{
    //warnx << "xferPlugin_net::get_default_hint: called\n";
    xp->get_default_hint(hint);
}

void 
xferPlugin_net::notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs)
{
    //warnx << "xferPlugin_net::notify_descriptors: called\n";
    
    // check oidCache if a lookup is in progress
    oid_netcache_entry *oce = oidCache[oid->id];
    
    if (oce) {
	dwarn(DEBUG_SET) << "xferPlugin_net::notify_descriptors: oidCache already has this oid for lookup... may be in progress\n";
    }
    else {
	
	update_cb cb = wrap(this, &xferPlugin_net::update_hints);
	oce = New oid_netcache_entry(oid->id, cb, m);
	oce->self_descs = descs;
	
	//add the descriptors to the oce
	for (unsigned int i = 0; i < descs->size(); i++) {
	    
	    dot_descriptor curdes = (*descs)[i];
	    dot_desc descript = curdes.id;
	    
	    int size_q = oce->slist->size();
	    
	    //warn << "xferPlugin_net::notify_descriptors: accumulated " << size_q << " shingles\n";
	    
	    if (size_q > NUM_SHINGLES - 1) {
		
		//warn << "pushing " << descript << " \n";
		oce->slist->push(descript);
		
		//remove the largest element
		//       warn << "popping " << oce->slist->top() << "\n";
		oce->slist->pop();
	    }
	    else {
		//       warn << "pushing " << descript << " \n";
		oce->slist->push(descript);
	    }
	}
	
	//call lookup
	get_default_hint(&glob_hint);
	delaycb(0, 0, wrap(oce, &oid_netcache_entry::net_lookup));
	
    } //else
    
    //pass it along
    xp->notify_descriptors(oid, descs);
}

void 
xferPlugin_net::update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints)
{
    dwarn(DEBUG_SET) << "Updating hints for " << dv->size() << "\n";
    dwarn(DEBUG_SET) << debug_sep;
    
   /*  for (size_t j = 0; j < dv->size(); j++) { */
/* 	dwarn(DEBUG_SET) << "For " << j << " missing descriptor " << (*dv)[j].id << "\n" ; */
/* 	copy current hints as is */
/* 	for (size_t i = 0; i < (*hints)[j]->size(); i++) { */
/* 	    dwarn(DEBUG_SET) << "Hint " << i << " is "<< (*(*hints)[j])[i].name << "\n"; */
/* 	} */
/*     } */
    
    xp->update_hints(dv, hints);
}

xferPlugin_net::~xferPlugin_net()
{
    dwarn(DEBUG_SET) << "xferPlugin_net::~xferPlugin_net deleting\n";
    
    chunk_cache_entry *drpc = chunkCache.first();
    
    while (drpc != NULL) {
	dwarn(DEBUG_SET) << "deleting " << drpc->cid <<"\n";
	delete drpc;
	drpc = chunkCache.first();
    }
}

# 891 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
class xferPlugin_net__get_bitmap__closure_t : public closure_t { public:   xferPlugin_net__get_bitmap__closure_t (xferPlugin_net *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_net::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  bitmap_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      bitmap_cb cb;   };   xferPlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 891 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
void 
xferPlugin_net::get_bitmap( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  bitmap_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 893 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  xferPlugin_net__get_bitmap__closure_t *__cls;   ptr<xferPlugin_net__get_bitmap__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_net__get_bitmap__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_net::get_bitmap);   } else {     __cls =     reinterpret_cast<xferPlugin_net__get_bitmap__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    bitmap_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 893 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"

    dwarn(DEBUG_SET) << "xferPlugin_net::get_bitmap: called for " << oid->id
		     << " from " << (*hints)[0].name << "\n";
    
    xp->get_bitmap(oid, hints, cb);
# 898 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
  return;
# 898 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_net.T"
}

/*optimizer interface*/

//TODOBINDU
/*
1. check push_back hint in insert_chunk_cache - ok
3. detect similar hints in get_chunks when i insert into hintvector - ok
4. what happens when a shingle has no hits in oids or hints --> check - shd be ok
6. check for deletion stuff cid_done and oid_done -- done
7. as soon as the lookup is finished, dht calls update_hints as he gets info. if the xfer plugin - done
does not have any outstanding stuff he can neglect it. also shd put hints in get_chunks call
11. make chunk cache to have unique hints - ok
12. get_chunks -- shd i insert default hint into chunkcache - inserting done
9. when i call update gtc might not have those descriptors in the missing list or waiting q - shd be ok since i am sending the stuff in get_chunks too
16. confirm opendht rpcs new data structures
15. TAME overcalled error
20. when shingle id and oid are same for a file with 1 shingle - use appnum
13. call back finish_getoid is weird since can't call back tamed function


2. look at vec and not vector
5. check oid in getoid_rpc class from derived class
8. get_descriptors from xp directly
10. more efficient matching right now O(N2)
11. share same connection to all rpc calls
12. when hints for oids come back in stages.... get_descriptors will not start until all hints have come back
14. change oidl_cb to cbs call back type - done


17. IMP when u have a ptr<> it has to be initialized can't be NULL
18. all the redefinitions in xfer and storage plugin
19. put 20byte strings in oid
20. Check SEND_SIZE for odht rpc calls
------

partial sources

1. duplication of put procedures - ok
2. global way of getting hints
3. stop the bitmap exchange after the download is done and delete the oid cache entry

 if (shingles_done <= 0 && oids_done <= 0 && oid_insert_done <= 0) {
	
	//all this entry's work is done
	//explicity remove getoid objects from hashtable since they are not ref counted
	dht_getoid_rpc *drpc = oidstatus.first();
	
	while (drpc != NULL) {
	    
	    warn << "oid_netcache_entry::del_getoid_rpc for " << drpc->oid <<"\n";
	    oidstatus.remove(drpc);
	    delete drpc;
	    drpc = oidstatus.first();
	}
	
	//will take care of getcid objects and oidinsert_status
	delete this; 
    }

4. do i refresh the shingle to oid mapping too may be not in the course of this download

5. when refreshing the oid->src mapping, currently doing 2 for loops for choosing unique srcs

6. when obtaining bitmaps, if all descs are present stop refreshing and mark as seed.


	dht_getoid_rpc *drpc = oidstatus[other_oid];
	
	ref<vec<dot_descriptor> > missing_descs = New refcounted<vec<dot_descriptor> >;
	ref<hv_vec> missing_hints = New refcounted<hv_vec> ;
	
	unsigned int match = 0;
	
	//match the descriptors and insert hints into chunk cache and call update finally
	for (unsigned int i = 0; i < self_descs->size(); i++) {
	    
	    ref<vec<oid_hint> > new_hints = New refcounted<vec<oid_hint> >;
	    
	    for (unsigned int j = 0; j < (drpc->descs)->size() ; j++) {
		
		if ((*self_descs)[i].id == (*(drpc->descs))[j].id ) {
		    
		    match++;
		    
		    //warn << "match in descriptors " << (*self_descs)[i].id << "\n";
		    
		    bool fresh_hints = xferPlugin_net::insert_chunk_cache((*self_descs)[i].id, drpc->hints, new_hints);
		    
		    //warn << "New hints " << fresh_hints << "\n";
		    
		    if (fresh_hints) {

			missing_descs->push_back((*(drpc->descs))[j]);
			missing_hints->push_back(new_hints);
		    } //fresh_hints
		    
		    break;
		} //if
	    }
	} //for all chunks
	
	//warn << "oid_netcache_entry::net_lookup_oid_done: matched " << match <<"\n";
	
	if (missing_descs->size() > 0) {
	    //update_hints call back deployed
	    (*cb)(missing_descs, missing_hints);
	}

7. the bitmap once obtained, is always assumed to be true ie new bitmaps are addiitions to old ones not entirely new

8. can't share info across oid lookups

9. take care of deleting src_info

10. if two new hints are the same, they are picked twice
*/
