/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#ifndef _XFER_MSRC_H_
#define _XFER_MSRC_H_

#include "xferPlugin.h"
#include "gtcd.h"
#include "xferPlugin_gtc_prot.h"

#include "se_transfer.h"
#include "params.h"

// for the pending queue structure
struct descs_msrc {
    chunk_cb cb;
    dot_descriptor dd;
    const dot_desc desc_name;
    ref<vec<oid_hint> > oidhint;
    
    oid_hint newhint;
    
    int i; // just for debugging purpose - to be removed
    tailq_entry<descs_msrc> link;
    ihash_entry<descs_msrc> hlink;
    
    int dups;
        
    descs_msrc (chunk_cb cbk, dot_descriptor dot_desc, ref<vec<oid_hint> > hints, int i, int dupin); 
    ~descs_msrc ();
};


struct src_state {
    
    ihash<const dot_desc, descs_msrc, &descs_msrc::desc_name, &descs_msrc::hlink, dd_hash> desc_request_cache;
    
    str hostname;
    unsigned int port;
    unsigned int outstanding_requests;
    
    unsigned int served_requests;
    
    bool isdup;
    
    src_state() {
	outstanding_requests = 0;
	served_requests = 0;
	isdup = false;
    }
    ~src_state() {
	//warn << "came to srcstate delete\n";
	warn << "SRCSTATS@@@@@@@@@@@@@@@@";
	warn << hostname << " " << port << " " << served_requests << "\n";
    }
};


class xferPlugin_msrc : public xferPlugin {
  
private:
    gtcd *m;
    xferPlugin *xp;

    unsigned int num_of_srcs;    
    
    vec<src_state *> wait_list_src;
    //    src_state *wait_list_src;

    // main pending queue
    tailq<descs_msrc, &descs_msrc::link> q_pending_desc;  

    // For cancelling stuff
    ihash<const dot_desc, descs_msrc, &descs_msrc::desc_name, &descs_msrc::hlink, dd_hash> hash_pending_desc;

    void send_descs_to_src();
    void get_chunks_done(unsigned int flag, chunk_cb cb, str s, ptr<desc_result> res);
    int check_srcplugin_exist(str hostname, unsigned int port);
    bool check_src_avail(int index);
    int add_new_src(str hostname, unsigned int port);
    bool delete_empty_srcs();
    void print_wait_list();

    void try_fillup_srcs(ref<vec<descs_msrc> > descs_for_xp);
    void try_duplicate_reqs(ref<vec<descs_msrc> > descs_for_xp);
    bool check_if_serve(dot_descriptor in);
   
public:
    bool configure(str s) { return true; }

    /* This should only be called after initialization */
    void get_default_hint(oid_hint *hint);

    /* Calls from the GTC */
    void get_descriptors(ref<dot_oid_md> oid, ref<vec<oid_hint> > hints,
			 descriptors_cb cb, CLOSURE);
    void notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs);
    void get_bitmap(ref<dot_oid_md> oid, ref<vec<oid_hint> > hints,
		    bitmap_cb cb, CLOSURE);
    void get_chunk(ref<dot_descriptor> d, ref<vec<oid_hint> > hints,
                   chunk_cb cb, CLOSURE);
    void get_chunks(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints,
		    chunk_cb cb, CLOSURE);
    void cancel_chunk(ref<dot_descriptor> d);
    void cancel_chunks(ref< vec<dot_descriptor> > dv);

    void update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints);

    xferPlugin_msrc(gtcd *m, xferPlugin *next_xp);
    ~xferPlugin_msrc() { }

 private:
    // void get_descriptors_cb(descriptors_cb cb1, str s, ptr<vec<dot_descriptor> > descs, bool end);
      
};


#endif /* _XFER_NET_H_ */
