
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "xferPlugin_msrc.h"

#ifdef ANIMATION
FILE *anime_fd;
#endif

#ifdef TIME_TRACE
static int block_count = 0;
static double begin;
static struct timeval start, end;
#endif

struct descs_cont {
    unsigned int numhints;
    descs_msrc *ptr;
};

// The comparison operator used to order the
// priority queue.
//
class Compare {
public:
    int operator()(const descs_cont &x, const descs_cont &y) {
	return x.numhints > y.numhints;
    }
};


typedef std::priority_queue<descs_cont, std::vector<descs_cont>, Compare> rarest_first;

descs_msrc::descs_msrc(chunk_cb cb, dot_descriptor dot_desc, 
		       ref<vec<oid_hint> > oidhints, int i, int dupin)
    : cb(cb), dd(dot_desc), desc_name(dot_desc.id),
      oidhint(oidhints), i(i), dups(dupin)
{
}

descs_msrc::~descs_msrc()
{
}

bool
xferPlugin_msrc::check_if_serve(dot_descriptor in)
{
    //check pending q first
    if (hash_pending_desc[in.id]) {
	return true;
    }

    //check individual src queues
    for (unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {
	if(wait_list_src[i] == NULL) continue;
	descs_msrc *desc = wait_list_src[i]->desc_request_cache[in.id];
	if (desc) 
	    return true;
    }
    
    return false;
}

# 67 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
class xferPlugin_msrc__get_chunks__closure_t : public closure_t { public:   xferPlugin_msrc__get_chunks__closure_t (xferPlugin_msrc *_self,  ref< vec< dot_descriptor > > missing_descs,  ref< hv_vec > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (missing_descs, hints, cb), _args (missing_descs, hints, cb) {}   typedef void  (xferPlugin_msrc::*method_type_t) ( ref< vec< dot_descriptor > > ,  ref< hv_vec > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.missing_descs, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< vec< dot_descriptor > > missing_descs,  ref< hv_vec > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< vec< dot_descriptor > > missing_descs,  ref< hv_vec > hints,  chunk_cb cb) : missing_descs (missing_descs), hints (hints), cb (cb) {}      ref< vec< dot_descriptor > > missing_descs;      ref< hv_vec > hints;      chunk_cb cb;   };   xferPlugin_msrc *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 67 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
void 
xferPlugin_msrc::get_chunks( ref< vec< dot_descriptor > > __tame_missing_descs,  ref< hv_vec > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 70 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  xferPlugin_msrc__get_chunks__closure_t *__cls;   ptr<xferPlugin_msrc__get_chunks__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_msrc__get_chunks__closure_t> (this, __tame_missing_descs, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_msrc::get_chunks);   } else {     __cls =     reinterpret_cast<xferPlugin_msrc__get_chunks__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< vec< dot_descriptor > > &missing_descs = __cls->_args.missing_descs;    ref< hv_vec > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (missing_descs);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 70 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"

    ref<vec<int> > done =  New refcounted<vec<int> >;
    for (unsigned int i = 0; i < missing_descs->size(); i++) 
	done->push_back(0);
      
    rarest_first table;
  
    // created the pending desc queue
    for (unsigned int i = 0; i < missing_descs->size(); i++) {

    choose:
	int num = arandom() % missing_descs->size();
	if ((*done)[num] == 1)
	    goto choose;
	else
	    (*done)[num] = 1;
	
	if (check_if_serve((*missing_descs)[num]))
	    continue;
      
	descs_msrc *d = New descs_msrc(cb, (*missing_descs)[num], (*hints)[num], num, 0);
	
	descs_cont temp;
	temp.numhints = d->oidhint->size();
	temp.ptr = d;

	table.push(temp);
    }
    
    while (!table.empty()) {
	descs_cont temp = table.top();

	//this queue is now in sorted order
	dwarn(DEBUG_MSRC) << "Inserting " << temp.ptr->desc_name << "\n";
	q_pending_desc.insert_tail(temp.ptr);
	hash_pending_desc.insert(temp.ptr);
	
	table.pop();
    }

#ifdef TIME_TRACE
    begin = get_cur_time();
#endif

    // start sending the descs to the xfer plugins
    send_descs_to_src();
# 116 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  return;
# 116 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
}

int
xferPlugin_msrc::check_srcplugin_exist(str hostname, unsigned int port)
{
    for (unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {
	if(wait_list_src[i] == NULL) continue;
	if(wait_list_src[i]->hostname == hostname
	   && wait_list_src[i]->port == port)
	    return i;
    }

    return -1;
}

bool
xferPlugin_msrc::check_src_avail(int index)
{
    return (wait_list_src[index]->outstanding_requests < NUM_ALLOWED_REQS);
}

int
xferPlugin_msrc::add_new_src(str hostname, unsigned int port)
{
    src_state *in = New src_state;
    
    for (unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {
	if (wait_list_src[i] == NULL) {

	    wait_list_src[i] = in;
	    //associate the plugin with hostname and port
	    wait_list_src[i]->hostname = hostname;
	    wait_list_src[i]->port = port;

	    num_of_srcs++;
	    return(i);
	}
    }
    
    fatal << "xferPlugin_msrc::add_new_src: no free slots\n";
    return(-1);
}

bool
xferPlugin_msrc::delete_empty_srcs()
{
    bool isdelete = false;
    for (unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {
	
	if (wait_list_src[i] == NULL) continue;
	
	if (wait_list_src[i]->outstanding_requests <= 0) {
	    dwarn(DEBUG_MSRC) << "delete_empty_srcs:: Deleting source at "
			      << i << "\n";
	    isdelete = true;
	    delete wait_list_src[i];
	    wait_list_src[i] = NULL;
	    num_of_srcs--;
	}
    }
    
    return(isdelete);
}

void 
xferPlugin_msrc::try_fillup_srcs(ref<vec<descs_msrc> > descs_for_xp)
{
    descs_msrc *d_xp = q_pending_desc.first;
    //go through the pending list
    while (d_xp != NULL) {

	//dwarn(DEBUG_MSRC) << "Checking " << d_xp->desc_name << "\n";
	int index = -1; 
	
	//go through its hints 
	for (unsigned int i = 0; i < (d_xp->oidhint)->size(); i++) {
	    hint_res result;
	    if (parse_hint((*(d_xp->oidhint))[i].name, "gtc", &result) < 0) {
		continue;
	    }

	    if ((index = check_srcplugin_exist(result.hint.hostname, result.hint.port)) >= 0) {
		if (check_src_avail(index)) {
		   d_xp->newhint = (*(d_xp->oidhint))[i];
		   break;
		}
		index = -1;
	    }
	}

	if (index < 0 && num_of_srcs < NUM_ALLOWED_SRCS) {
	    for (unsigned int i = 0; i < (d_xp->oidhint)->size(); i++) {
		hint_res result;
		if (parse_hint((*(d_xp->oidhint))[i].name, "gtc", &result) < 0) {
		    continue;
		}
		
		if ((index = check_srcplugin_exist(result.hint.hostname, result.hint.port)) < 0) {
		    d_xp->newhint = (*(d_xp->oidhint))[i];
		    int new_src = add_new_src(result.hint.hostname, result.hint.port);
		    index = new_src;
		    //dwarn(DEBUG_MSRC) << "try_fillup_srcs:: Added new source at " << index << "\n";
		    break;
		}
		index = -1;
	    }
	}
	
	if (index >= 0) {
	    //found some src
	    //dwarn(DEBUG_MSRC) << "try_fillup_srcs:: Source addition at " << index << "\n";

	    hash_pending_desc.remove(d_xp);
	    descs_msrc *d_xp1 = q_pending_desc.next(d_xp);
	    q_pending_desc.remove(d_xp);

	    descs_for_xp->push_back(*d_xp); // issue desc to the xp
	    wait_list_src[index]->desc_request_cache.insert(d_xp); // enqueue desc on wait-q
	    wait_list_src[index]->outstanding_requests++;
	   
	    d_xp = d_xp1;
	}
	else
	    d_xp = q_pending_desc.next(d_xp);

    }
}

void 
xferPlugin_msrc::try_duplicate_reqs(ref<vec<descs_msrc> > descs_for_xp)
{
    dwarn(DEBUG_MSRC) << "try_duplicate_reqs: DUPLICATION BEGINS\n";
    //go through issue qs of each non-duplicate source
    for (unsigned int iter = 0; iter < NUM_ALLOWED_SRCS; iter++) {

	if (num_of_srcs >= NUM_ALLOWED_SRCS) break;
	
	if (wait_list_src[iter] == NULL) continue;
	if (wait_list_src[iter]->isdup) continue;
	
	//go through the hash table in the wait
	descs_msrc *d_xp = wait_list_src[iter]->desc_request_cache.first();
	while (d_xp != NULL) {

	    if (d_xp->dups > 0) {
		d_xp = wait_list_src[iter]->desc_request_cache.next(d_xp);
		continue;
	    }

	    //can i make a new source for this chunk
	    if (num_of_srcs < NUM_ALLOWED_SRCS) {
			
		//edit the hints to have the first nonexistent source
		//go through its hints 
		for (unsigned int i = 0; i < (d_xp->oidhint)->size(); i++) {
		    hint_res result;
		    if (parse_hint((*(d_xp->oidhint))[i].name, "gtc", &result) < 0) {
			//fatal << "No hints to get block 3 from\n";
			continue;
		    }

		    if ((check_srcplugin_exist(result.hint.hostname, result.hint.port)) < 0) {

			dwarn(DEBUG_MSRC) << "Making duplicate connection to "
					  << result.hint.hostname << ":" << result.hint.port <<"\n";
			
			//duplicate the request
			d_xp->dups++;
			
			int new_src = add_new_src(result.hint.hostname, result.hint.port);
			descs_msrc *d = New descs_msrc(d_xp->cb, d_xp->dd, d_xp->oidhint, d_xp->i, 1);
			d->newhint = (*(d_xp->oidhint))[i];
			descs_for_xp->push_back(*d); // issue desc to the xp
			wait_list_src[new_src]->desc_request_cache.insert(d); // enqueue desc on wait-q
			wait_list_src[new_src]->outstanding_requests++;
			wait_list_src[new_src]->isdup = true;
			
			break;
		    }
		}
	    }
	    else
		break;
	    
	    d_xp = wait_list_src[iter]->desc_request_cache.next(d_xp);
	} //while
    } //for 
}

// sends descs from the pending queue to
// the respective xfer plugins
void
xferPlugin_msrc::send_descs_to_src()
{
    ref<vec<descs_msrc> > descs_for_xp = New refcounted<vec<descs_msrc> >;
    try_fillup_srcs(descs_for_xp);
    //check if any xfer plugins are empty at this point
    if (delete_empty_srcs()) {
	try_fillup_srcs(descs_for_xp);
    }

#ifdef DUPLICATION
    descs_msrc *d_xp = q_pending_desc.first;
    if (d_xp == NULL)
	try_duplicate_reqs(descs_for_xp);
#endif

    //sending descs to xp1
    for (unsigned int j = 0; j < descs_for_xp->size(); j++) {
	//sending one chunk at a time such that
	//at least DESC_LIST_SIZE requests are in the pipe
	ref<vec<dot_descriptor> > desc_to_get = New refcounted<vec<dot_descriptor> >;
	desc_to_get->push_back((*descs_for_xp)[j].dd);
	
	ref<hv_vec > hints  = New refcounted<hv_vec >;
	ref<vec<oid_hint> > hints1  = New refcounted<vec<oid_hint> >;
	hints1->push_back((*descs_for_xp)[j].newhint);
	hints->push_back(hints1);
		
	chunk_cb cb = (*descs_for_xp)[j].cb;

	hint_res result;
	if (parse_hint((*descs_for_xp)[j].newhint.name, "gtc", &result) < 0) {
	    continue;
	}
	int srcid = check_srcplugin_exist(result.hint.hostname, result.hint.port);
	if(srcid < 0)
	    fatal << "try_fillup_srcs:: srcid should exist\n";
	
	xp->get_chunks(desc_to_get, hints, 
		       wrap(this, &xferPlugin_msrc::get_chunks_done,
			    srcid, cb));
    }
}

// callback function invoked for some smart book-keeping 
// functions in the future for intelligent loadbalancing and
// multi-path transfers
void
xferPlugin_msrc::get_chunks_done(unsigned int xp_id, 
				 chunk_cb cb, str s, ptr<desc_result> res)
{
#ifdef TIME_TRACE
    str got_host("NOOP");
    int got_id = -1;
#endif

    static int useless_work1 = 0;
    if (s) {
	// XXX - If it fails on one plugin, send to another
	fatal << "error checking code not implemented";	
	//remove fatal and put cleanup
    }
  
    descs_msrc *d = NULL;
    bool xp_id_rem = false;

    dwarn(DEBUG_MSRC) << "get_chunks_done:: Chunk came back for " << xp_id <<
	" and " << res->desc->id << "\n";

    for (unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {

	if (wait_list_src[i] == NULL) {
	    if (i == xp_id)
		warn << "Error: Unable to find descriptor in XP " << 
		    ++useless_work1 << "\n";
	    continue;
	}
	
	d = wait_list_src[i]->desc_request_cache[res->desc->id];
	if (d) {
	    dwarn(DEBUG_MSRC) << "Removing from source " << i << "\n";
	    
	    wait_list_src[i]->desc_request_cache.remove(d);
	    wait_list_src[i]->outstanding_requests--;
	
	    if (i == xp_id) {
#ifdef TIME_TRACE
		got_host = wait_list_src[i]->hostname;
		got_id = d->i;
#endif
#ifdef ANIMATION
		str buf;
		char timebuf[20];
		bzero(timebuf, sizeof(timebuf));
		sprintf(timebuf, "%f", get_cur_time());
		
		buf = strbuf() << timebuf << " " << wait_list_src[xp_id]->hostname << " "
			       << wait_list_src[xp_id]->port << " " << res->desc->id << "\n";
		
		fprintf(anime_fd, "%s", buf.cstr());
		fflush(anime_fd);
#endif	
		xp_id_rem = true;
		wait_list_src[i]->served_requests++;
	    }
	    else //duplicate
		xp->cancel_chunk(New refcounted<dot_descriptor>(d->dd));
	    	    
	    delete d;
	}
	else if (i == xp_id)
	    warn << "Error1: Unable to find descriptor in XP " << 
		++useless_work1 << "\n";
    }
    
    if (xp_id_rem) {
#ifdef TIME_TRACE
	double now = get_cur_time();
	double time_elapsed = now - begin;
	block_count++;
    
	fprintf(stdout,"BLOCKTIME %f %d %d %s\n",time_elapsed, block_count, got_id, got_host.cstr());
	descs_msrc *d_xp = q_pending_desc.first;
	if ((d_xp == NULL)) 
	    fprintf(stdout,"DUP BEGINS\n");

	fflush(stdout);
    
#endif
	// Only if we haven't returned data earlier
	(*cb)(s,res);
	send_descs_to_src();
    }
}


# 443 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
class xferPlugin_msrc__get_descriptors__closure_t : public closure_t { public:   xferPlugin_msrc__get_descriptors__closure_t (xferPlugin_msrc *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_msrc::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  descriptors_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      descriptors_cb cb;   };   xferPlugin_msrc *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 443 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
void 
xferPlugin_msrc::get_descriptors( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  descriptors_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 445 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  xferPlugin_msrc__get_descriptors__closure_t *__cls;   ptr<xferPlugin_msrc__get_descriptors__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_msrc__get_descriptors__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_msrc::get_descriptors);   } else {     __cls =     reinterpret_cast<xferPlugin_msrc__get_descriptors__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    descriptors_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 445 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"

    xp->get_descriptors(oid, hints, cb);
# 447 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  return;
# 447 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
}


void
xferPlugin_msrc::print_wait_list()
{
    warn << debug_sep;
    for(unsigned int i = 0; i < NUM_ALLOWED_SRCS; i++) {
	if(wait_list_src[i] == NULL) continue;

	warn << "Src " << i << " host " << wait_list_src[i]->hostname << ":"
	     << wait_list_src[i]->port << " "
	     << wait_list_src[i]->outstanding_requests << "\n";

    }
    
    warn << debug_sep;
}


void 
xferPlugin_msrc::cancel_chunk(ref<dot_descriptor> d)
{
    //remove from my pending queue
    descs_msrc *desc = hash_pending_desc[d->id];
    if (desc) {
	//warn << "Removing from queue\n";
	hash_pending_desc.remove(desc);
	q_pending_desc.remove(desc);
	delete desc;
    }
}

void 
xferPlugin_msrc::cancel_chunks(ref< vec<dot_descriptor> > dv)
{
    //warn << "xferPlugin_msrc::cancel_chunks: called\n";
    for (unsigned int i = 0; i < dv->size(); i++) {
	ref<dot_descriptor> d = New refcounted<dot_descriptor> ;
	d->id = ((*dv)[i]).id;
	d->length = ((*dv)[i]).length;
	cancel_chunk(d);
    }
}

void 
xferPlugin_msrc::get_default_hint(oid_hint *hint)
{
    xp->get_default_hint(hint);
}

void 
xferPlugin_msrc::notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs)
{
#ifdef TIME_TRACE
    gettimeofday(&start, NULL);
#endif
    
    //warnx << "xferPlugin_msrc::notify_descriptors: called\n";
    xp->notify_descriptors(oid, descs);
}

# 509 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
class xferPlugin_msrc__get_chunk__closure_t : public closure_t { public:   xferPlugin_msrc__get_chunk__closure_t (xferPlugin_msrc *_self,  ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (d, hints, cb), _args (d, hints, cb) {}   typedef void  (xferPlugin_msrc::*method_type_t) ( ref< dot_descriptor > ,  ref< vec< oid_hint > > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : d (d), hints (hints), cb (cb) {}      ref< dot_descriptor > d;      ref< vec< oid_hint > > hints;      chunk_cb cb;   };   xferPlugin_msrc *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 509 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
void 
xferPlugin_msrc::get_chunk( ref< dot_descriptor > __tame_d,  ref< vec< oid_hint > > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 512 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  xferPlugin_msrc__get_chunk__closure_t *__cls;   ptr<xferPlugin_msrc__get_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_msrc__get_chunk__closure_t> (this, __tame_d, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_msrc::get_chunk);   } else {     __cls =     reinterpret_cast<xferPlugin_msrc__get_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 512 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"

    warn << "xferPlugin_msrc::get_chunk: called\n";
# 514 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  return;
# 514 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
}

void 
xferPlugin_msrc::update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints)
{
#ifdef TIME_TRACE
    gettimeofday(&end, NULL);
    fprintf(stderr, "@@@@@xferPlugin_msrc::update_hints time for notifydes-updatehints == %.2f\n",
    	    timeval_diff(&start, &end));
#endif
    
    int pot_use = 0;
    
    //warn << "xferPlugin_msrc::update_hints: called " << dv->size() << "\n";
    //updating hints for the pending queue
    for(unsigned int i = 0; i < dv->size(); i++) {
	descs_msrc *d;
	
	//for each descriptor check if it is in the pending q
	d = hash_pending_desc[(*dv)[i].id];
	
	if(d) {
	    *d->oidhint += *((*hints)[i]);
	    pot_use++;
	}
	else {
	    //could be in the issue queue of srcs
	    //update hints in the issue queue of srcs
	    for (unsigned int k = 0; k < NUM_ALLOWED_SRCS; k++) {
		if(wait_list_src[k] == NULL) continue;
		d = wait_list_src[k]->desc_request_cache[(*dv)[i].id];
		if (d) {
		    *d->oidhint += *((*hints)[i]);
		}
	    }
	}
    }

    warn << "xferPlugin_msrc::update_hints: Potentially useful for " << pot_use << " blocks\n";
    
    //update the queue order
    rarest_first table;
    descs_msrc *d_xp; 
    while ((d_xp = q_pending_desc.first) != NULL) { 
	descs_cont temp;
	temp.numhints = d_xp->oidhint->size();
	temp.ptr = d_xp;
	
	table.push(temp);
	
	q_pending_desc.remove(d_xp);
    }
    
    while (!table.empty()) {
	descs_cont temp = table.top();
	//warn << "Popping " << temp.numhints << " " << temp.ptr->dd.id <<"\n";
	//this queue is now in sorted order
	q_pending_desc.insert_tail(temp.ptr);
	table.pop();
    }
    
    send_descs_to_src();
}

xferPlugin_msrc::xferPlugin_msrc(gtcd *m, xferPlugin *next_xp) : m(m), xp(next_xp), num_of_srcs(0)
{
    assert(m);
    assert(xp);

    //pre init make wait_list_src for all sources. and 
    //then associate each index with a source...i can't keep deleting and adding
    //entries because code uses index into wait_list_src to see whose block came back
    warn << "Num conns " << NUM_ALLOWED_REQS << " num srcs " << NUM_ALLOWED_SRCS << "\n";
    for(unsigned int i = 0; i < NUM_ALLOWED_SRCS ; i++) {
	wait_list_src.push_back(NULL);
    }
    
#ifdef ANIMATION
    str file = strbuf() << "/tmp/animation" ;
    warn << "xferPlugin_msrc::xferPlugin_msrc opening animation file " << file << "\n";
    
    anime_fd = fopen(file.cstr(), "w");
    
    if (anime_fd == NULL) {
	strbuf sb;
	sb.fmt("Could not open input file: %s: %m", file.cstr());
    }
    
    file = "Time SourceIP Sourceport descid\n";
    fprintf(anime_fd, "%s", file.cstr());
    fflush(anime_fd);
#endif
}

# 608 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
class xferPlugin_msrc__get_bitmap__closure_t : public closure_t { public:   xferPlugin_msrc__get_bitmap__closure_t (xferPlugin_msrc *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_msrc::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  bitmap_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      bitmap_cb cb;   };   xferPlugin_msrc *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 608 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
void 
xferPlugin_msrc::get_bitmap( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  bitmap_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 610 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  xferPlugin_msrc__get_bitmap__closure_t *__cls;   ptr<xferPlugin_msrc__get_bitmap__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_msrc__get_bitmap__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_msrc::get_bitmap);   } else {     __cls =     reinterpret_cast<xferPlugin_msrc__get_bitmap__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    bitmap_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 610 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"

    xp->get_bitmap(oid, hints, cb);
# 612 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
  return;
# 612 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_msrc.T"
}

/* TODO

1. fix memory leak -- descs hanging around if chunks_done does not come back make it come back from gtc with failed desc info
2. make the q impl more efficient
3. duplicates it only once

done-

2. send updates to pending stuff in gtc too -  update hints in the issue queue of srcs
3. updating hints will push hints to the main hints memory allocated in gtcd.T
make sure its use is all right.
4. check if hv_vec shd be vec of refs to vecs or vec of vecs????? -- vec of refs
5. optimised for one file at a time due to duplication of requests
*/
