
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "storagePlugin_net.h"
#include "parseopt.h"

static ihash<const dot_sId, net_cache_entry, &net_cache_entry::id, &net_cache_entry::hlink> tempCache;

int odht_port = DEFAULT_DHT_PORT;
str odht_ip = "127.0.0.1";

net_cache_entry::net_cache_entry(const dot_sId sid)
  : id(sid), slist(New refcounted<ordered_descriptor_list>),
    shingles_done(0), oid_done(false)
{
    tempCache.insert(this);
}

net_cache_entry::~net_cache_entry()
{
    warn << "Delete for oid " << oid << "\n";
    tempCache.remove(this);
}

void
net_cache_entry::net_insert(gtcd *m)
{
    oid_hint hint;
    
    warn << debug_sep
	 << "net_cache_entry::net_insert: came to insert all shingles for "
	 << oid << "\n";
    
    // Output items in priority_queue using top()
    // and use pop() to get to next item until
    // priority_queue is empty
    
    shingles_done = 0;
    while (!slist->empty()) {
	dot_desc ds = slist->top();

	warn << "Inserting shingle " << shingles_done << " " << ds << "\n";
	ref<dht_rpc> dht = New refcounted<odht_rpc>(odht_ip, odht_port);
	status.push_back(dht);
	put_fp_to_oid(dht, ds, oid, wrap(this, &net_cache_entry::put_fp_to_oid_done));
	slist->pop();
	shingles_done++;
    }

    warn << "Inserting object id " << oid << "\n";
    oidstatus = New refcounted<odht_rpc>(odht_ip, odht_port);
    m->xp->get_default_hint(&hint); 
    put_oid_source(oidstatus, oid, hint, wrap(this, &net_cache_entry::put_oid_source_done));

    warn << "Inserted " << shingles_done << " shingles\n" << debug_sep;
}

void
net_cache_entry::put_fp_to_oid_done(str err)
{
    shingles_done--;

    if (err)
	warn << "Shingle status:: err\n";
    else
	warn << "Shingle status:: success\n";
        
    if (shingles_done <= 0 && oid_done) {
	
	warn << "All shingle and oid calls returned \n";
		
	//now i kill myself, since the refs to dht_rpc objects go away,
	//they should be garbage collected too
	delete this;
    }
}

void
net_cache_entry::put_oid_source_done(str err)
{
    oid_done = true;

    if (err)
	warn << "Oid status:: err\n";
    else
	warn << "Oid status:: success\n";
    
    if (shingles_done <= 0 && oid_done) {
	
	warn << "All shingle and oid calls returned \n";
	
	//now i kill myself, since the refs to dht_rpc objects go away,
	//they should be garbage collected too
	delete this;
    }
}

bool 
storagePlugin_net::init(dot_sId id)
{
    warn << "storagePlugin_net:: DHT plugin initiated\n";
    
    net_cache_entry *sce = tempCache[id];
    if (sce) {
	warn("storagePlugin_net received duplicate ID: %d\n", id);
	sp->init(id);
	return (false);
    }

    sce = New net_cache_entry(id);

    return(sp->init(id));
}


# 119 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__put_chunk__closure_t : public closure_t { public:   storagePlugin_net__put_chunk__closure_t (storagePlugin_net *_self,  dot_sId id,  ref< dot_descriptor > d,  const char *buf,  int len,  cbs cb) : closure_t (false), _self (_self),  _stack (id, d, buf, len, cb), _args (id, d, buf, len, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (storagePlugin_net::*method_type_t) ( dot_sId ,  ref< dot_descriptor > ,  const char *,  int ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T:151: in function storagePlugin_net::get_bitmap", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &storagePlugin_net__put_chunk__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.id, _args.d, _args.buf, _args.len, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( dot_sId id,  ref< dot_descriptor > d,  const char *buf,  int len,  cbs cb) {}      str err;      str err1;      net_cache_entry *sce;   };   struct args_t {     args_t ( dot_sId id,  ref< dot_descriptor > d,  const char *buf,  int len,  cbs cb) : id (id), d (d), buf (buf), len (len), cb (cb) {}      dot_sId id;      ref< dot_descriptor > d;      const char *buf;      int len;      cbs cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 119 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::put_chunk( dot_sId __tame_id,  ref< dot_descriptor > __tame_d,  const char *__tame_buf,  int __tame_len,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 122 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    
# 123 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__put_chunk__closure_t *__cls;   ptr<storagePlugin_net__put_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__put_chunk__closure_t> (this, __tame_id, __tame_d, __tame_buf, __tame_len, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::put_chunk);   } else {     __cls =     reinterpret_cast<storagePlugin_net__put_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    str &err1 = __cls->_stack.err1;    net_cache_entry *&sce = __cls->_stack.sce;    dot_sId &id = __cls->_args.id;    ref< dot_descriptor > &d = __cls->_args.d;    const char *&buf = __cls->_args.buf;    int &len = __cls->_args.len;    cbs &cb = __cls->_args.cb;    use_reference (id);     use_reference (d);     use_reference (buf);     use_reference (len);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto storagePlugin_net__put_chunk__label_1;     break;   default:     break;   }
# 123 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

  
    //warn << "storagePlugin_net::put_chunk: called\n";
    
    sce = tempCache[id];
    if (!sce) {
	err1 = "Incorrect transfer ID";
	warn << err1 << "\n";
    }
    else {
	//Maintain NUM_SHINGLES ordered hashes
	int size_q = sce->slist->size();
	
	//warn << "storagePlugin_net::put_chunk: accumulated " << size_q << " shingles\n";
	if (size_q > NUM_SHINGLES - 1) {
	    //warn << "pushing " << d->id << " of length " << d->length << "\n";
	    sce->slist->push(d->id);
	    //warn << "popping " << sce->slist->top() << "\n";
	    sce->slist->pop();
	}
	else {
	    //warn << "pushing " << d->id << " of length " << d->length << "\n";
	    sce->slist->push(d->id);
	}
	err1 = NULL;
    }
  
    
# 150 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 150 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

	sp->put_chunk(id, d, buf, len, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 152 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
    if (--__cls->_block1)       return;   } while (0);  storagePlugin_net__put_chunk__label_1:     ;
# 152 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"


    if (err)
	warn << "storagePlugin_net::put_chunk: Error message from child: "
	     << err << "\n";
    
    (*cb)(err1);
# 159 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 159 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 161 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__commit_object__closure_t : public closure_t { public:   storagePlugin_net__commit_object__closure_t (storagePlugin_net *_self,  dot_sId id,  commit_cb cb) : closure_t (false), _self (_self),  _stack (id, cb), _args (id, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (storagePlugin_net::*method_type_t) ( dot_sId ,  commit_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T:173: in function storagePlugin_net::put_chunk", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &storagePlugin_net__commit_object__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.id, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( dot_sId id,  commit_cb cb) {}      str err;      ptr< dot_oid_md > oid;      net_cache_entry *sce;   };   struct args_t {     args_t ( dot_sId id,  commit_cb cb) : id (id), cb (cb) {}      dot_sId id;      commit_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 161 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::commit_object( dot_sId __tame_id,  commit_cb __tame_cb, ptr<closure_t> __cls_g)
{
    
# 164 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__commit_object__closure_t *__cls;   ptr<storagePlugin_net__commit_object__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__commit_object__closure_t> (this, __tame_id, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::commit_object);   } else {     __cls =     reinterpret_cast<storagePlugin_net__commit_object__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< dot_oid_md > &oid = __cls->_stack.oid;    net_cache_entry *&sce = __cls->_stack.sce;    dot_sId &id = __cls->_args.id;    commit_cb &cb = __cls->_args.cb;    use_reference (id);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto storagePlugin_net__commit_object__label_1;     break;   default:     break;   }
# 168 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"


    //warn << "storagePlugin_net::commit_object: called\n";
    
    
# 172 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 172 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

        sp->commit_object(id, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(err), TTT( oid)>, __cls_r, 1, pointer_set2_t<TTT(err), TTT( oid)> (&(err), &( oid)))));
    
# 174 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
    if (--__cls->_block1)       return;   } while (0);  storagePlugin_net__commit_object__label_1:     ;
# 174 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"


    if (err)
	warn << "storagePlugin_net::commit_object: Error message from child: "
	     << err << "\n";
    
    //do something with shingles now
    sce = tempCache[id];
    if (!sce) {
	warn << "Incorrect transfer ID \n";
	err = "Incorrect transfer ID";
    }
    else {
	//set the oid
	//warn("OID is %s\n", oid->id.cstr());
	sce->oid = oid->id;
	delaycb(0, 0, wrap(sce, &net_cache_entry::net_insert, m));
    }
    
    //warn << "storagePlugin_net::commit_object: making callback\n";
    (*cb)(err, oid);
# 195 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 195 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 197 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_descriptors_init__closure_t : public closure_t { public:   storagePlugin_net__get_descriptors_init__closure_t (storagePlugin_net *_self,  ref< dot_oid_md > oid,  oid_cb cb) : closure_t (false), _self (_self),  _stack (oid, cb), _args (oid, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_oid_md > ,  oid_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T:208: in function storagePlugin_net::commit_object", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &storagePlugin_net__get_descriptors_init__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  oid_cb cb) {}      str err;      ptr< dot_oid_md > o;   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  oid_cb cb) : oid (oid), cb (cb) {}      ref< dot_oid_md > oid;      oid_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 197 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_descriptors_init( ref< dot_oid_md > __tame_oid,  oid_cb __tame_cb, ptr<closure_t> __cls_g)
{
    //warnx << "storagePlugin_net::get_descriptors_init: called\n";

    
# 202 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_descriptors_init__closure_t *__cls;   ptr<storagePlugin_net__get_descriptors_init__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_descriptors_init__closure_t> (this, __tame_oid, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_descriptors_init);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_descriptors_init__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< dot_oid_md > &o = __cls->_stack.o;    ref< dot_oid_md > &oid = __cls->_args.oid;    oid_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto storagePlugin_net__get_descriptors_init__label_1;     break;   default:     break;   }
# 205 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

  
    
# 207 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 207 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

      sp->get_descriptors_init(oid, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(err), TTT( o)>, __cls_r, 1, pointer_set2_t<TTT(err), TTT( o)> (&(err), &( o)))));
    
# 209 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
    if (--__cls->_block1)       return;   } while (0);  storagePlugin_net__get_descriptors_init__label_1:     ;
# 209 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

  
    if (err) {
	warnx << "storagePlugin_net::get_descriptors_init: Error message from child: "
	     << err << "\n";
    }
    else {
	//warnx << "storagePlugin_net::get_descriptors_init: Child returned successfully.\n";
	metadata_entry e;
	e.module = "NET";
	e.key = "oid++_key0";
	e.val = "oid++_val0";
	o->md.list.push_back(e);
    }
    
    (*cb)(err, o);
# 225 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 225 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 227 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_descriptors__closure_t : public closure_t { public:   storagePlugin_net__get_descriptors__closure_t (storagePlugin_net *_self,  ref< dot_oid_md > oid,  descriptors_cb cb) : closure_t (false), _self (_self),  _stack (oid, cb), _args (oid, cb) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_oid_md > ,  descriptors_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  descriptors_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  descriptors_cb cb) : oid (oid), cb (cb) {}      ref< dot_oid_md > oid;      descriptors_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 227 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_descriptors( ref< dot_oid_md > __tame_oid,  descriptors_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 229 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_descriptors__closure_t *__cls;   ptr<storagePlugin_net__get_descriptors__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_descriptors__closure_t> (this, __tame_oid, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_descriptors);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_descriptors__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    descriptors_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 229 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    sp->get_descriptors(oid, cb);
# 231 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 231 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 233 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__put_ichunk__closure_t : public closure_t { public:   storagePlugin_net__put_ichunk__closure_t (storagePlugin_net *_self,  ref< dot_descriptor > d,  ref< suio > uiop,  bool retain,  cbs cb) : closure_t (false), _self (_self),  _stack (d, uiop, retain, cb), _args (d, uiop, retain, cb) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_descriptor > ,  ref< suio > ,  bool ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.uiop, _args.retain, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  ref< suio > uiop,  bool retain,  cbs cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  ref< suio > uiop,  bool retain,  cbs cb) : d (d), uiop (uiop), retain (retain), cb (cb) {}      ref< dot_descriptor > d;      ref< suio > uiop;      bool retain;      cbs cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 233 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::put_ichunk( ref< dot_descriptor > __tame_d,  ref< suio > __tame_uiop,  bool __tame_retain,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 236 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__put_ichunk__closure_t *__cls;   ptr<storagePlugin_net__put_ichunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__put_ichunk__closure_t> (this, __tame_d, __tame_uiop, __tame_retain, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::put_ichunk);   } else {     __cls =     reinterpret_cast<storagePlugin_net__put_ichunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    ref< suio > &uiop = __cls->_args.uiop;    bool &retain = __cls->_args.retain;    cbs &cb = __cls->_args.cb;    use_reference (d);     use_reference (uiop);     use_reference (retain);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 236 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    sp->put_ichunk(d, uiop, retain, cb);
# 238 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 238 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 240 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_chunk_init__closure_t : public closure_t { public:   storagePlugin_net__get_chunk_init__closure_t (storagePlugin_net *_self,  ref< dot_descriptor > d,  descriptor_cb cb) : closure_t (false), _self (_self),  _stack (d, cb), _args (d, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_descriptor > ,  descriptor_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T:249: in function storagePlugin_net::put_ichunk", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &storagePlugin_net__get_chunk_init__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  descriptor_cb cb) {}      str err;      ptr< dot_descriptor > desc;   };   struct args_t {     args_t ( ref< dot_descriptor > d,  descriptor_cb cb) : d (d), cb (cb) {}      ref< dot_descriptor > d;      descriptor_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 240 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_chunk_init( ref< dot_descriptor > __tame_d,  descriptor_cb __tame_cb, ptr<closure_t> __cls_g)
{
    
# 243 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_chunk_init__closure_t *__cls;   ptr<storagePlugin_net__get_chunk_init__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_chunk_init__closure_t> (this, __tame_d, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_chunk_init);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_chunk_init__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< dot_descriptor > &desc = __cls->_stack.desc;    ref< dot_descriptor > &d = __cls->_args.d;    descriptor_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto storagePlugin_net__get_chunk_init__label_1;     break;   default:     break;   }
# 246 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"


    
# 248 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 248 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

        sp->get_chunk_init(d, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(err), TTT( desc)>, __cls_r, 1, pointer_set2_t<TTT(err), TTT( desc)> (&(err), &( desc)))));
    
# 250 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
    if (--__cls->_block1)       return;   } while (0);  storagePlugin_net__get_chunk_init__label_1:     ;
# 250 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    
    if (err) {
        warn << "storagePlugin_net::get_chunk_init: Error message from child: "
	     << err << "\n";
    }
    else {
        warn << "storagePlugin_net::get_chunk_init: Child returned successfully.\n";
        metadata_entry e;
        e.module = "NET";
        e.key = "dl++_key0";
        e.val = "dl++_val0";
        desc->md.list.push_back(e);
    }

    (*cb)(err, desc);
# 266 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 266 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 268 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_chunk__closure_t : public closure_t { public:   storagePlugin_net__get_chunk__closure_t (storagePlugin_net *_self,  ref< dot_descriptor > d,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (d, cb), _args (d, cb) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_descriptor > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  chunk_cb cb) : d (d), cb (cb) {}      ref< dot_descriptor > d;      chunk_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 268 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_chunk( ref< dot_descriptor > __tame_d,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 270 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_chunk__closure_t *__cls;   ptr<storagePlugin_net__get_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_chunk__closure_t> (this, __tame_d, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_chunk);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    chunk_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 270 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    sp->get_chunk(d, cb);
# 272 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 272 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

# 274 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_chunks__closure_t : public closure_t { public:   storagePlugin_net__get_chunks__closure_t (storagePlugin_net *_self,  ref< vec< dot_descriptor > > dv,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (dv, cb), _args (dv, cb) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< vec< dot_descriptor > > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.dv, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< vec< dot_descriptor > > dv,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< vec< dot_descriptor > > dv,  chunk_cb cb) : dv (dv), cb (cb) {}      ref< vec< dot_descriptor > > dv;      chunk_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 274 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_chunks( ref< vec< dot_descriptor > > __tame_dv,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 276 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_chunks__closure_t *__cls;   ptr<storagePlugin_net__get_chunks__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_chunks__closure_t> (this, __tame_dv, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_chunks);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_chunks__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< vec< dot_descriptor > > &dv = __cls->_args.dv;    chunk_cb &cb = __cls->_args.cb;    use_reference (dv);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 276 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    sp->get_chunks(dv, cb);
# 278 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 278 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}

bool
storagePlugin_net::configure(str s)
{
    int portnum;
    str addr;
    char *hn = NULL;
    char *name = NULL;
    
    if (!s || s == "")
        return true;

    name = strdup(s.cstr());
    if ((hn = strchr(name, ' '))) {
	*hn++ = '\0';
	addr.setbuf(name, strlen(name));
	portnum = atoi(hn);
    }
    else
	return false;

    odht_port = portnum;
    odht_ip = addr;

    warn << "Setting " << odht_port << " " << odht_ip << "\n";
    
    return true;
}

void 
storagePlugin_net::notify_descriptors(ref<dot_oid_md> oid,
				      ptr<vec<dot_descriptor> > descs)
{
    //warn << "storagePlugin_net::notify_descriptors:: called\n";
    sp->notify_descriptors(oid, descs);
}

# 316 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
class storagePlugin_net__get_bitmap__closure_t : public closure_t { public:   storagePlugin_net__get_bitmap__closure_t (storagePlugin_net *_self,  ref< dot_oid_md > oid,  bitmap_cb cb) : closure_t (false), _self (_self),  _stack (oid, cb), _args (oid, cb) {}   typedef void  (storagePlugin_net::*method_type_t) ( ref< dot_oid_md > ,  bitmap_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  bitmap_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  bitmap_cb cb) : oid (oid), cb (cb) {}      ref< dot_oid_md > oid;      bitmap_cb cb;   };   storagePlugin_net *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 316 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
void 
storagePlugin_net::get_bitmap( ref< dot_oid_md > __tame_oid,  bitmap_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 318 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  storagePlugin_net__get_bitmap__closure_t *__cls;   ptr<storagePlugin_net__get_bitmap__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<storagePlugin_net__get_bitmap__closure_t> (this, __tame_oid, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&storagePlugin_net::get_bitmap);   } else {     __cls =     reinterpret_cast<storagePlugin_net__get_bitmap__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    bitmap_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 318 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"

    sp->get_bitmap(oid, cb);
# 320 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
  return;
# 320 "/Users/dga/Documents/dot/src/trunk/gtcd/storage/storagePlugin_net.T"
}


//TODOBINDU
/*
1. print elements of priority queue without popping -- not necessary
3. if total blocks are less than num_shingles 
4. insert into dht when file is received in get. right now it inserts into dht only when put is called on a file
6. also send port to contact at in put message -- done
7. if same oid is put again, i will put in dht again...since no oid is known -- sheerly transferid based
8. check for errors during insert when to delete sce
10. check references to string in constructor
12. i am using char arrays everywhere is that ok... for example how can i use oid_info directly - xdr2bytes etc


2. what happens if two chunks have the same keys right now
they get inserted into priority queue as separate elements and thus get inserted into the DHT too ****
5. change chunking to rabin ***
9. look at vec and not vector

opendht

11. share same connection to all rpc calls

*/
