
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "gtcd.h"
#include "stllike.h"
#include "gtc_ext_interface.h"
#include "xferPlugin.h"
#include "rxx.h"

list<client, &client::link> clientlist;
static unsigned int numclients = 0;
static struct timeval start, end;

int 
parse_hint(str hint, str protocol, hint_res *res)
{
    static rxx colon(":");
    vec<str> parts;

    if (!hint || !hint.len()) {
	fatal("woah! parse_hint got a null hint!");
	return -1;
    }
    /* hints:
     * gtc://hostname:port
     * xdisk://name:target_dir:size:time:ignore:ing_path
     * intern://name
     */

    char *proto_data = strstr(hint.cstr(), "://");
    if (!proto_data || (protocol != str(hint.cstr(), proto_data-hint.cstr())))
	return -1;
    proto_data += 3; // Skip the '://'

    split(&parts, colon, proto_data);

    if (protocol == "gtc") {
	if (parts.size() < 2) {
	    warn << "Invalid gtc protocol hint: " << proto_data << "\n";
	    return -1;
	}
	
	res->hint.hostname = parts[0];
	/* last component specifies the port */
	res->hint.port = atoi(parts[ parts.size() - 1 ]);
	return 1;
    }
    else if (protocol == "xdisk") {
	if (parts.size() < 5) {
	    warn << "Could not parse xdisk hint: " << proto_data << "\n";
	    return -1;
	}

	res->hint1.name = parts[0];
	res->hint1.target_dir = parts[1];
	res->hint1.size = atoi(parts[2]);
	res->hint1.modtime = atoi(parts[3]);
	res->hint1.ignore_str = parts[4];
	
	if (parts.size() > 5)
	    res->hint1.ignore_path = parts[5];
	else
	    res->hint1.ignore_path = res->hint1.ignore_str;

	char *f = strrchr(res->hint1.name, '.');
	if (f) 
	    res->hint1.file_type = strbuf() << f;
	else
	    res->hint1.file_type = "NONE";
#if 0
	warnx << "parse_hint:: filename " << res->hint1.name
	      << " type " << res->hint1.file_type
	      << " size " << res->hint1.size
	      << " time " << res->hint1.modtime
	      << " target " << res->hint1.target_dir
	      << " ignoring " << res->hint1.ignore_str
	      << " " << res->hint1.ignore_path << "\n";
#endif
	return 1;
    }
    else if (protocol == "intern") {
	res->hint2 = str(proto_data);
	return 1;
    }
    else { /* Unknown protocol! */
	return -1;
    }
    assert(false); /* NOT REACHED */
}

int
make_hint(hint_res ip, str protocol, oid_hint *op)
{
    strbuf buf;
    
    if (protocol == "gtc") {
	buf << "gtc://" << ip.hint.hostname << ":" << ip.hint.port;
	op->name = buf;
	return 1;
    }

    if (protocol == "intern") {
	buf << "intern://" << ip.hint2;
	op->name = buf;
	return 1;
    }
    
    return -1;
}


xferData::xferData() 
    : id(0), xmode(XFER_SEQUENTIAL), descs(NULL), descs_count(0),
      descs_xfered(0), descs_start(0), starting_offset(0), 
      buf_offset(0), fetching(false), xcb(NULL),
      err(NULL), hints(NULL)
{
}

static int chunk_fetch_count;  // A hack for performance analysis.

void
gtcd::get_data(svccb *sbp)
{
    gtc_get_data_arg *arg = sbp->Xtmpl getarg<gtc_get_data_arg>();
    gtc_get_data_res res(false);

    ptr<xferData> pdp = xferTable[*arg];
    if (!pdp) {
        *res.errmsg = strbuf() << "unknown transfer id: " << *arg;
        warn << *res.errmsg << "\n";
        sbp->replyref(res);
        return;
    }

    if ((pdp->buf.resid() > 0) 
	|| (pdp->xmode == XFER_SEQUENTIAL
	    && (*pdp->descs_status)[pdp->descs_count] == DESC_ON_STORAGE)) {
	transfer_data(sbp, *arg);
	return;
    }

    if (pdp->descs_xfered == pdp->descs->size()) {
	res.set_ok(true);
	res.resok->end = true;
	res.resok->count = 0;
	res.resok->offset = 0;
	res.resok->data.setsize(0);
	sbp->replyref(res);
	xferTable.remove(*arg);
	return;
    }

    if (pdp->xmode == XFER_OUT_OF_ORDER) {
	for (unsigned int i = pdp->descs_start; i < pdp->descs->size(); i++) {
	    if ((*pdp->descs_status)[i] == DESC_ON_STORAGE) {
		transfer_data(sbp, *arg);
		return;
	    }
	}
    }

    // Insert a callback so that when we get data transfer data is
    // called.
    if (pdp->fetching) {
	// We are fetching data. Install a cb so a transfer is
	// invoked when that is done
	pdp->xcb = wrap(this, &gtcd::transfer_data, sbp, *arg);
    }
    else {
	pdp->fetching = true;
	pdp->xcb = wrap(this, &gtcd::transfer_data, sbp, *arg);
	delaycb(0, 0, wrap(this, &gtcd::fetch_data, *arg));
    }
}

void
gtcd::fetch_data(dot_xferId xferId)
{
    int refcount;
    bool missing = false;
    
    //warnx << "xferId == " << xferId << "\n";
    ptr<xferData> pdp = xferTable[xferId];
    ref<vec<dot_descriptor> > missing_descs = 
        New refcounted<vec<dot_descriptor> >;

    warn << "Have to fetch " << pdp->descs_status->size() << " blocks\n";
    for (unsigned int i = 0; i < pdp->descs_status->size(); i++) {
        refcount = sp->get_chunk_refcount(&(*pdp->descs)[i]);
        if (refcount >= 0) {
	    sp->inc_chunk_refcount(&(*pdp->descs)[i]);
            (*pdp->descs_status)[i] = DESC_ON_STORAGE;
        }
        else {
            missing = true;
            missing_descs->push_back((*pdp->descs)[i]);
            (*pdp->descs_status)[i] = DESC_REQUESTED;
        }
    }

    // This code is actually never called yet because fetch_data is
    // only called once. This is only here right now in case we ever
    // rate limit the amount of data fetched
    if (pdp->xcb) {

	if ((pdp->xmode == XFER_SEQUENTIAL) 
	    && (*pdp->descs_status)[pdp->descs_count] == DESC_ON_STORAGE) {
	    xfer_cb xcb = pdp->xcb;
	    pdp->xcb = NULL;
	    (*xcb)();
	}
	else if (pdp->xmode == XFER_OUT_OF_ORDER) {
	    for (unsigned int i = 0; i < pdp->descs->size(); i++) {
		if ((*pdp->descs_status)[i] == DESC_ON_STORAGE) {
		    xfer_cb xcb = pdp->xcb;
		    pdp->xcb = NULL;
		    (*xcb)();
		    break;
		}
	    }
	}
    }

    if (missing) {
        // For each descriptor, call into storage plugin stack
        //    Get_get_chunk_md (GGCMD)
        //
//         for (size_t j = 0; j < missing_descs->size(); j++)
//             for (size_t i = 0; i < (*missing_descs)[j].md.list.size(); i++)
//                 warn << "  " << (*missing_descs)[j].md.list[i].module << "."
//                      << (*missing_descs)[j].md.list[i].key << " = "
//                      << (*missing_descs)[j].md.list[i].val << "\n";
      
      //convert pdp->hints to per chunk hints
	ref<hv_vec> vechints = New refcounted<hv_vec > ;
	vechints->setsize(missing_descs->size()); 

	for (size_t j = 0; j < missing_descs->size(); j++) {
	    (*vechints)[j] = New refcounted<vec<oid_hint > >(*(pdp->hints));
	}
      
	xp->get_chunks(missing_descs, vechints,
		       wrap(this, &gtcd::xp_fetch_data_cb, xferId));

    }
}

void
gtcd::xp_fetch_data_cb(dot_xferId xferId, str s, ptr<desc_result> res)
{
    //warnx << "xferId fetch == " << xferId << "\n";
    ptr<xferData> pdp = xferTable[xferId];
    if (!pdp) {
        // This can happen when we get multiple errors and we removed
        // pdp from the xfer table after passing the first error back
        // to the application.
        warn <<"Callback for invalid xferId \n";
        return;
    }

    if (s || !res->data || res->data->resid() == 0) {
        if (s) {
            pdp->err = s;
        }
        else {
            pdp->err = "Unable to fetch data from the xfer plugin";
        } 
        if (pdp->xcb) {
            xfer_cb xcb = pdp->xcb;
            pdp->xcb = NULL;
            (*xcb)();
        }
        return;
    }

    // Find out where this chunk belongs
    unsigned int chunks_put = 0;
    dot_descriptor res_desc = *(res->desc);

    ptr<vec<unsigned int> > vv = (*pdp->descs_hash[res_desc.id]);
    if (vv) {
        for (unsigned int j = 0; j < vv->size(); j++) {
            unsigned int i = (*vv)[j];
            if ((*pdp->descs_status)[i] != DESC_ON_STORAGE &&
                (*pdp->descs_status)[i] != DESC_DONE) {
                (*pdp->descs_status)[i] = DESC_ON_STORAGE;
                if (!chunks_put) {
                    sp->put_ichunk(res->desc, res->data, true,
                                   wrap(this, &gtcd::put_sp_cb));
                } else {
                    sp->inc_chunk_refcount(&res_desc);
                }
                chunks_put++;
            }
        }
    }
    chunk_fetch_count++;

    if ((pdp->xcb && pdp->xmode == XFER_OUT_OF_ORDER && chunks_put) ||
	(pdp->xcb && pdp->xmode == XFER_SEQUENTIAL
	    && ((*pdp->descs_status)[pdp->descs_count] == DESC_ON_STORAGE))) {
	xfer_cb xcb = pdp->xcb;
	pdp->xcb = NULL;
	(*xcb)();
    }
}

void
gtcd::transfer_data(svccb *sbp, dot_xferId xferId)
{
    ptr<xferData> pdp = xferTable[xferId];

    if (pdp->err) {
        actual_transfer_data(sbp, xferId);
        return;
    }

    if (pdp->xmode == XFER_SEQUENTIAL) {
	// Now, check whether we have enough data in the buf?
	if (pdp->buf.resid() < SEND_SIZE
	    && pdp->descs_xfered != pdp->descs->size()) {
	    if ((*pdp->descs_status)[pdp->descs_count] == DESC_ON_STORAGE) {
		// Move contents in from the sp
		pdp->descs_count++;
		sp->get_chunk(New refcounted<dot_descriptor> 
			      ((*pdp->descs)[pdp->descs_count-1]), 
			      wrap(this, &gtcd::get_chunk_cb, sbp, xferId,
				   pdp->descs_count-1, -1));
		return;
	    }
	}
	actual_transfer_data(sbp, xferId);
    }
    else if (pdp->xmode == XFER_OUT_OF_ORDER) {
	if (pdp->buf.resid() > 0) {
	    // We have data that we need to empty first
	    actual_transfer_data(sbp, xferId);
	} 
	else {
	    long offset = pdp->starting_offset;
	    unsigned int pdpds = pdp->descs->size();
	    // Find a chunk from the sp and send that over
            bool all_done = true;
	    for (unsigned int i = pdp->descs_start; i < pdpds; i++) {
                if (all_done && (*pdp->descs_status)[i] == DESC_DONE) {
                    pdp->descs_start++;
		    pdp->starting_offset += (*pdp->descs)[i].length;
                } else {
                    all_done = false;
                }
		if ((*pdp->descs_status)[i] == DESC_ON_STORAGE) {
		    // Move contents in from the sp
		    sp->get_chunk(New refcounted<dot_descriptor> 
				  ((*pdp->descs)[i]), 
				  wrap(this, &gtcd::get_chunk_cb, sbp, 
				       xferId, i, offset));
		    return;
		}
		offset += (*pdp->descs)[i].length;
	    }
	}
    }
}

void
gtcd::get_chunk_cb(svccb *sbp, dot_xferId xferId, unsigned int desc_no, 
		   long offset, str s, ptr<desc_result> res)
{
    ptr<xferData> pdp = xferTable[xferId];

    if (s) {
        pdp->err = s;
        actual_transfer_data(sbp, xferId);
        return;
    }

    // As we always get data from the storage plugin, we should be
    // able to just insert this into an array and then write it out.
    pdp->buf.copyu(res->data);
    // Mark as done
    (*pdp->descs_status)[desc_no] = DESC_DONE;
    //sp->release_ichunk(res->desc);
    pdp->descs_xfered++;


    if (offset >= 0) {
	pdp->buf_offset = offset;
    }

    // Now, if we don't have enough data in the buffer, can we add
    // some more? No matter what the xfer mode is, we can only add the
    // next sequential chunk
    if (pdp->buf.resid() < SEND_SIZE
        && pdp->descs_xfered != pdp->descs->size()
	&& ((desc_no+1) < pdp->descs->size())) {
        if ((*pdp->descs_status)[desc_no+1] == DESC_ON_STORAGE) {
            // Move contents in from the sp
	    if (pdp->xmode == XFER_SEQUENTIAL) {
		assert(pdp->descs_count == (desc_no + 1));
		pdp->descs_count++;
	    }
	    sp->get_chunk(New refcounted<dot_descriptor> 
                          ((*pdp->descs)[desc_no+1]), 
                          wrap(this, &gtcd::get_chunk_cb, sbp, xferId,
			       desc_no+1, -1));
            return;
        }
    }
    actual_transfer_data(sbp, xferId);
}

void
gtcd::actual_transfer_data(svccb *sbp, dot_xferId xferId)
{

    ptr<xferData> pdp = xferTable[xferId];
    gtc_get_data_res res(true);

    if (pdp->err) {
	res.set_ok(false);
        *res.errmsg = pdp->err;
        warn << "actual_transfer_data:: " << *res.errmsg << "\n";
        sbp->replyref(res);
        xferTable.remove(xferId);
        return;
    }

    if (pdp->buf.resid() <= SEND_SIZE) {
        res.resok->count = pdp->buf.resid();
        res.resok->offset = pdp->buf_offset;
        res.resok->data.setsize(res.resok->count);
	pdp->buf_offset += res.resok->count;
        pdp->buf.copyout(res.resok->data.base(), res.resok->data.size());
        pdp->buf.rembytes(res.resok->data.size());
	// XXX - Insert a low-water mark here such that if its hit and
	// only we are not currently fetching more data, get more data
	if (pdp->descs_xfered == pdp->descs->size()) {
	    warn << "had to fetch " << chunk_fetch_count
		 << " blocks from remote end\n";
	    gettimeofday(&end, NULL);

	    res.resok->end = true;
	    sbp->replyref(res);

	    fprintf(stderr, "time for gtcd data start-finish == %.2f\n",
		    timeval_diff(&start, &end));
	    chunk_fetch_count = 0;
	    //so that data is in SET for sharing
	    //for (unsigned int i = 0; i < pdp->descs->size(); i++) {
		//sp->release_ichunk(New refcounted<dot_descriptor> ((*pdp->descs)[i]));
	    //}
	    xferTable.remove(xferId);
	}
        else {
	    res.resok->end = false;
	    sbp->replyref(res);
	}
    }
    else {
        res.resok->end = false;
        res.resok->count = SEND_SIZE;
        res.resok->offset = pdp->buf_offset;
        res.resok->data.setsize(SEND_SIZE);
	pdp->buf_offset += res.resok->count;
        pdp->buf.copyout(res.resok->data.base(), SEND_SIZE);
        pdp->buf.rembytes(SEND_SIZE);
	sbp->replyref(res);
    }
}


void 
gtcd::get_init_cb(svccb *sbp, ref<dot_oid_md> oid, bool last_try, 
                  dot_xferId id, str s, ptr<vec<dot_descriptor> > descs, 
                  bool end)
{
    gtc_get_init_res res(false);

    if (s) {
	if (!last_try) {
	    /* Storage plugin didn't have descriptors;  get from net */
	    ref<xferData> pdp = xferTable[id];
	    
	    xp->get_descriptors(oid, pdp->hints,
				wrap(this, &gtcd::get_init_cb, sbp, oid, true, 
				     id));
	    return;
	}
	else {
	    xferTable.remove(id);
	    res.set_ok(false);
	    *res.errmsg = s;
	    sbp->replyref(res);
	    return;
	}
    }
    
    ref<xferData> pdp = xferTable[id];
    if (!pdp->descs) {
	pdp->descs = descs;
    }
    else {
	*pdp->descs += *descs;
    }
    
    if (end) {
	chunk_fetch_count = 0;
	res.set_ok(true);
	*res.id = id;
	pdp->descs_status = New refcounted<vec<desc_status> >;
	pdp->descs_status->setsize(pdp->descs->size());  
	for (unsigned int i = 0; i < pdp->descs->size(); i++) {
	    (*pdp->descs_status)[i] = DESC_UNKNOWN;
            if (!pdp->descs_hash[(*pdp->descs)[i].id]) {
                ref<vec<unsigned int> > vv = New refcounted<vec<unsigned int> >;
                pdp->descs_hash.insert((*pdp->descs)[i].id, vv);
            }
            (*pdp->descs_hash[(*pdp->descs)[i].id])->push_back(i);
	}
	//collected all the descriptors so notify the transfer plugins of it
	//incase they do not know
	xp->notify_descriptors(oid, pdp->descs);
	
	//the descriptors came from xp so let the sp know about it
	if (last_try)
	    sp->notify_descriptors(oid, pdp->descs);
	
	sbp->replyref(res);
    } 
}

# 536 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
class gtcd__get_init__closure_t : public closure_t { public:   gtcd__get_init__closure_t (gtcd *_self,  svccb *sbp) : closure_t (false), _self (_self),  _stack (sbp), _args (sbp), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (gtcd::*method_type_t) ( svccb *, ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T:594: in function gtcd::get_init", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &gtcd__get_init__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.sbp, mkref (this));   }   struct stack_t {     stack_t ( svccb *sbp) {}      ptr< xferData > pdp;      str errmsg;      ptr< dot_oid_md > oidmd;   };   struct args_t {     args_t ( svccb *sbp) : sbp (sbp) {}      svccb *sbp;   };   gtcd *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 536 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
void 
gtcd::get_init( svccb *__tame_sbp, ptr<closure_t> __cls_g)
{
    ptr<dot_oid_md> oid;

    
# 541 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
  gtcd__get_init__closure_t *__cls;   ptr<gtcd__get_init__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<gtcd__get_init__closure_t> (this, __tame_sbp);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&gtcd::get_init);   } else {     __cls =     reinterpret_cast<gtcd__get_init__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< xferData > &pdp = __cls->_stack.pdp;    str &errmsg = __cls->_stack.errmsg;    ptr< dot_oid_md > &oidmd = __cls->_stack.oidmd;    svccb *&sbp = __cls->_args.sbp;    use_reference (sbp);    switch (__cls->jumpto ()) {   case 1:     goto gtcd__get_init__label_1;     break;   default:     break;   }
# 545 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"


    {
    gtc_get_init_arg *arg = sbp->Xtmpl getarg<gtc_get_init_arg>();
    gtc_get_init_res res(false);

    dot_oid oid_id = arg->oid.id;

    if (oid_id.size() < 1) {
        *res.errmsg = "Received invalid OID for GET";
        warn << *res.errmsg << "\n";
        sbp->replyref(res);
        
# 557 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
return ;
    }
    
    if (arg->hints.size() <= 0) {
        *res.errmsg = "No Hints provided for GET";
        warn << *res.errmsg << "\n";
        sbp->replyref(res);
        
# 564 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
return ;
    }

    if (arg->xmode != XFER_SEQUENTIAL && arg->xmode != XFER_OUT_OF_ORDER) {
        *res.errmsg = "Invalid Transfer mode";
        warn << *res.errmsg << "\n";
        sbp->replyref(res);
        
# 571 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
return ;	
    }

    gettimeofday(&start, NULL);
    ref<vec<oid_hint> > hints = New refcounted<vec<oid_hint> >;
    hints->setsize(arg->hints.size());

    for (unsigned int i = 0; i < arg->hints.size() ;i++) {
        // warn << "gtcd::get_init - Hint at pos " << i << " found\n";
        (*hints)[i] = (arg->hints[i]);
    }

    warn << "Received GET for OID = " << oid_id << "\n";
    oid = New refcounted<dot_oid_md> (arg->oid);
    
    pdp = New refcounted<xferData>;
    xferTable.insert(xferCounter, pdp);
    
    pdp->xmode = arg->xmode;
    pdp->id = xferCounter++;
    pdp->hints = hints;
    }
    
    
# 594 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 594 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
 sp->get_descriptors_init(oid, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(errmsg), TTT( oidmd)>, __cls_r, 1, pointer_set2_t<TTT(errmsg), TTT( oidmd)> (&(errmsg), &( oidmd))))); 
# 594 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
    if (--__cls->_block1)       return;   } while (0);  gtcd__get_init__label_1:     ;
# 594 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"


    sp->get_descriptors(oidmd, wrap(this, &gtcd::get_init_cb, sbp, oidmd,
				    false, pdp->id));
# 598 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
  return;
# 598 "/Users/dga/Documents/dot/src/trunk/gtcd/gtcd.T"
}

void
gtcd::put_commit_cb(svccb *sbp, str s, ptr<dot_oid_md> oid)
{
    gtc_put_commit_res res(false);

    if (s) {
        warn << "Error in put_commit - " << s << "\n";
        *res.errmsg = s;
        sbp->replyref(res);
        return;
    } 

    warn << "Plugin says that the oid is " << oid->id << "\n";
    for (size_t i = 0; i < oid->md.list.size(); i++)
        warn << "  " << oid->md.list[i].module << "."
                     << oid->md.list[i].key << " = "
                     << oid->md.list[i].val << "\n";
    res.set_ok(true);
    res.resok->oid = *oid;
    oid_hint hint;
    // XXX - Allow for multiple hints
    xp->get_default_hint(&hint);
    res.resok->hints.setsize(1);
    res.resok->hints[0] = hint;
    sbp->replyref(res);
}

void
gtcd::put_commit(svccb *sbp)
{
    gtc_put_commit_arg *arg = sbp->Xtmpl getarg<gtc_put_commit_arg>();
    gtc_put_commit_res res(false);

    ptr<xferData> pdp = xferTable[*arg];
    if (!pdp) {
        *res.errmsg = strbuf() << "unknown xferID " << *arg;
        sbp->replyref(res);
        return;
    }

    xferTable.remove(*arg);

    cp->commit_object(pdp->sid, wrap(this, &gtcd::put_commit_cb, sbp));
}

void
gtcd::put_sp_cb(str s)
{
    if (s)
        warn << "Message from put_ichunk is " << s << " \n";

}

void
gtcd::put_data_cb(svccb *sbp, str s)
{
    gtc_put_data_res res(false);

    if (s) {
        warn << "Message from put_data is " << s << " \n";
        *res.errmsg = s;
    } else {
	res.set_ok(true);
    }
    
    sbp->replyref(res);
}

void
gtcd::put_data(svccb *sbp)
{
    gtc_put_data_arg *arg = sbp->Xtmpl getarg<gtc_put_data_arg>();
    gtc_put_data_res res(false);
    
    ptr<xferData> pdp = xferTable[arg->id];
    if (!pdp) {
        *res.errmsg = strbuf() << "unknown xferID " << arg->id;
        sbp->replyref(res);
        return;
    }

    assert (arg->data.size() == arg->count);    
    cp->put_object(pdp->sid, arg->data.base(), arg->data.size(), 
                   wrap(this, &gtcd::put_data_cb, sbp));
}

void
gtcd::put_init(svccb *sbp, bool init_with_path)
{
    //warnx << "gtcd:: put_path_init called\n";
    
    ref<xferData> pdp = New refcounted<xferData>;
    xferTable.insert(xferCounter, pdp);

    gtc_put_init_res res(true);
    *res.id = xferCounter++;
    pdp->id = *res.id;
    ptr<metadata_entry > e = NULL;

    if (init_with_path) {
	e = New refcounted<metadata_entry >;
	gtc_put_init_arg *arg = sbp->Xtmpl getarg<gtc_put_init_arg>();
	for (unsigned int i = 0; i < arg->list.size(); i++) {
	    if (arg->list[i].module == "LOCAL") {
		*e = arg->list[i];
		break;
	    }
	}
	warnx << "gtcd::put_init: Sending metadata " << e->module
	      << " " << e->key << " o ->" << e->val << "e\n";
    }
    
    cp->init(&pdp->sid, e);
    sbp->replyref(res);
}

void
gtcd::put_fd_commit_cb(ref<putfd_state> st, str s, ptr<dot_oid_md> oid)
{
    gtc_put_commit_res res(false);

    if (s) {
        warn << "Error in put_commit - " << s << "\n";
        *res.errmsg = s;
        st->sbp->replyref(res);
        return;
    } 

    warn << "Plugin says that the oid is " << oid->id << "\n";
    for (size_t i = 0; i < oid->md.list.size(); i++)
        warn << "  " << oid->md.list[i].module << "."
                     << oid->md.list[i].key << " = "
                     << oid->md.list[i].val << "\n";
    res.set_ok(true);
    res.resok->oid = *oid;
    oid_hint hint;
    // XXX - Allow for multiple hints
    xp->get_default_hint(&hint);
    res.resok->hints.setsize(1);
    res.resok->hints[0] = hint;
    st->sbp->replyref(res);
}

void
gtcd::put_fd_read_cb(ref<putfd_state> st, str s)
{
    if (s) {
        gtc_put_commit_res res(false);
        warn << "Message from put_chunk is " << s << " \n";
        *res.errmsg = s;
        st->sbp->replyref(res);
        return;
    }

    st->pending--;
    put_fd_main(st);
}

void
gtcd::put_fd_read(ref<putfd_state> st)
{
    if (st->sbp->getsrv()->xprt()->ateof()) {
        warn << "put_fd_read(): client is gone...stopping read from FD\n";
	fdcb(st->fd, selread, NULL);
        st->sbp->ignore();
        return;
    }

    char inbuf[CHUNK_SIZE];
    int nbytes = read(st->fd, inbuf, CHUNK_SIZE);
    
    if (nbytes == -1) {
        gtc_put_commit_res res(false);
        str s = strbuf() << "Could not read from input file descriptor\n";
        *res.errmsg = s;
        st->sbp->replyref(res);
    }
    else if (nbytes == 0) {
	fdcb(st->fd, selread, NULL);
        st->fd = -1;
        put_fd_main(st);
    }
    else {
        st->pending++;
        cp->put_object(st->sid, inbuf, nbytes,
                       wrap(this, &gtcd::put_fd_read_cb, st));
    }
}

void
gtcd::put_fd_main(ref<putfd_state> st)
{
    bool more = false;

    if (st->fd != -1) {
        fdcb(st->fd, selread, wrap(this, &gtcd::put_fd_read, st));
	more = true;
	//	warnx << " [reading]";
    }

    if (!more && st->pending <= 0) {
	//warnx << "s_cb_s:  DONE!\n";
        cp->commit_object(st->sid, wrap(this, &gtcd::put_fd_commit_cb, st));
    }
}

void
gtcd::put_fd(svccb *sbp, bool put_with_path)
{
    //warnx << "put_path_fd called\n";
    
    axprt_unix *x = static_cast<axprt_unix *>(sbp->getsrv()->xprt().get());
    int fd = x->recvfd();
    if (fd < 0) {
        gtc_put_commit_res res(false);
        str s = strbuf() << "Could not receive FD from client\n";
        warn << s;
        *res.errmsg = s;
        sbp->replyref(res);
        return;
    }

    ref<putfd_state> st = New refcounted<putfd_state>;

    ptr<metadata_entry > e = NULL;

    if (put_with_path) {
	e = New refcounted<metadata_entry>;
	gtc_put_init_arg *arg = sbp->Xtmpl getarg<gtc_put_init_arg>();
	for (unsigned int i = 0; i < arg->list.size(); i++) {
	    if (arg->list[i].module == "LOCAL") {
		*e = arg->list[i];
		break;
	    }
	}
	//attach fd to metadata
	e->key = strbuf() << e->key << fd;
    
	warnx << "gtcd::put_fd: Sending metadata " << e->module
	      << " " << e->key << " o ->" << e->val << "e\n";
    }
    
    cp->init(&st->sid, e);
    st->sbp = sbp;
    st->fd = fd;
    st->pending = 0;

    put_fd_main(st);
}

void
gtcd::abort()
{
    for (client *p = clientlist.first; p; p = clientlist.next(p))
        if (p->x->ateof()) {
            delete p;
            break;
        }

    warn("Deleting client connection (%d clients left)\n", numclients);
}

void
gtcd::dispatch(svccb *sbp)
{
     if (!sbp) {
        abort();
        return;
    }

    switch(sbp->proc()) {
    case GTC_PROC_PUT_INIT:
        put_init(sbp, false); /* without path */
        break;
    case GTC_PROC_PUT_PATH_INIT:
        put_init(sbp, true); /* with path */
        break;
    case GTC_PROC_PUT_DATA:
        put_data(sbp);
        break;
    case GTC_PROC_PUT_COMMIT:
        put_commit(sbp);
        break;
    case GTC_PROC_PUT_FD:
        put_fd(sbp, false); /* without path */
        break;
    case GTC_PROC_PUT_PATH_FD:
        put_fd(sbp, true); /* with path */
        break;
    case GTC_PROC_GET_INIT:
        get_init(sbp);
        break;
    case GTC_PROC_GET_DATA:
        get_data(sbp);
        break;
    default:
        sbp->reject(PROC_UNAVAIL);
        break;
    }
}

client::client(int fd, const sockaddr_un &sun, asrv_cb cb)
    : x(axprt_unix::alloc(fd, MAX_PKTSIZE)),
      c(asrv::alloc(x, gtc_program_1, cb))
{
    clientlist.insert_head (this);
    numclients++;

#ifdef HAVE_GETPEEREID
    if (getpeereid (fd, &uid, &gid) < 0) {
        warn ("getpeereid: %m\n");
        // XXX: What do we want to do if we don't know the client?
        //close (fd);
        //delete sa;
        //return;
    }
#endif /* HAVE_GETPEEREID */
    
    warn("Accepted connection from uid=%d, gid=%d\n", uid, gid);
}

client::~client ()
{
    warn("Connection closed for uid=%d, gid=%d\n", uid, gid);
    clientlist.remove (this);
    numclients--;
}
