/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#ifndef _CHUNKALG_H_
#define _CHUNKALG_H_

#include "async.h"
#include "rabinpoly.h"

class chunkAlg {

public:
    virtual ~chunkAlg() {};

    virtual void stop() = 0;

    // These functions return a vector of ints (possibly NULL) that
    // specify where the next block boundaries are as offset from the
    // previous boundary
    virtual ptr<vec<unsigned int> > chunk_data (const unsigned char *data, 
                                       size_t size) = 0;
    // This interface is inefficient. Disabled for now
    // virtual ptr<vec<unsigned int> > chunk_data (suio *in_data) = 0;

};

#endif /* _CHUNKALG_H_ */
