
# 1 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
#include "gcp.h"
#include "dot_fts.h"

static struct timeval tv_hash_start;
static struct timeval tv_data_start; // This is also tv_hash_end
static struct timeval tv_data_end;
static int td_pending;
static bool err_flag;

extern bool passdp;

typedef callback<void, FTSENT *, cbs>::ptr ftsfunc_bl;
void fts_block(vec<char *> paths, int options, ftsfunc_bl cb, cbs cb1, CLOSURE);

gcp_put::gcp_put(str file, str dp, ref<aclnt> gtc,
                 bool passfd, struct stat b, oid_type t,
		 put_done_cb cb)
    : file(file), destpath(dp), gtc_c(gtc),
      cb(cb), statbuf(b), type(t)
{
    pendingRPCs = 0;

    send_file(passfd);
}

gcp_put::gcp_put(ptr<suio> in, ref<aclnt> gtc,
                 oid_type t, put_done_cb cb)
    : gtc_c(gtc), cb(cb), type(t), buf(in)
{
    pendingRPCs = 0;

    vNew put_client_suio(in, gtc_c, wrap(this, &gcp_put::gcp_send));
}

void
gcp_put::send_file(bool passfd)
{
    gettimeofday(&tv_hash_start, NULL);

    //dwarn(DEBUG_CLIENT) << "Sending file " << file << "\n";
    if (!strcmp(file, "-"))
	in_fd = STDIN_FILENO;
    else
	in_fd = open(file, O_RDONLY);
    
    if (in_fd == -1) {
	strbuf sb;
	sb.fmt("Could not open input file: %s: %m", file.cstr());
	(*cb) (sb, NULL);
        delete this;
	return;
    }
    
    if (passfd) {
	if (passdp)
	    vNew put_client_fd(in_fd, file, gtc_c, wrap(this, &gcp_put::gcp_send));
	else
	    vNew put_client_fd(in_fd, gtc_c, wrap(this, &gcp_put::gcp_send));
    }
    else {
	if (passdp)
	    vNew put_client(in_fd, file, gtc_c, wrap(this, &gcp_put::gcp_send));
	else
	    vNew put_client(in_fd, gtc_c, wrap(this, &gcp_put::gcp_send));
    }
}

void 
gcp_put::gcp_send(str err, ptr<dot_oid_md> oid, ptr<vec<oid_hint> > hints)
{
    if (err) {
        strbuf sb;
	sb << "gcp_put:  Putting to the GTC failed! " << err << "\n";
	(*cb) (err, NULL);
        delete this;
	return;
    }
    
    ptr<gcp_put_arg> arg = New refcounted<gcp_put_arg>;
    arg->oid = *oid;
    arg->hints.set(hints->base(), hints->size());
    arg->type = type;
    if (type == OID_FILE) {
	//dwarn(DEBUG_CLIENT) << "Just put " << file << " with oid " << oid->id <<"\n";
	arg->file.size = statbuf.st_size;
	arg->file.uid = statbuf.st_uid;
	arg->file.gid = statbuf.st_gid;
	arg->file.mode = statbuf.st_mode;
	arg->file.modtime = statbuf.st_mtime;
	
	strbuf filename;
	char *lastslash = strrchr(file, '/');
	if (lastslash) {
	    filename << (lastslash + 1);
	} else {
	    filename << file;
	}
	
	arg->file.filename = filename;
	arg->file.destpath = destpath;
    }
    else
	dwarn(DEBUG_CLIENT) << "Just put TD with oid " << oid->id <<"\n";

    //dwarn(DEBUG_CLIENT) << "-------------------------------------------------\n";
    (*cb) (NULL, arg);
    delete this;
}

gcp_put::~gcp_put()
{
    dwarn(DEBUG_CLIENT) << "Destroying gcp_put\n";
}

extern struct timeval gcp_start;
void
put_oid_done(ref<gcp_put_res> res, clnt_stat err)
{
    if (err) {
	strbuf sb;
        sb << "Could not send put command to receiver: " << err << "\n";
	exit(1);
    }
    if (!res->ok) {
        strbuf sb;
	sb << "put_done returned " << *res->errmsg << "\n";
        exit(1);
    }
    
    gettimeofday(&tv_data_end, NULL);
    
    // XXX - Why does warn not support floats??
    printf ("Put succeeded - Hash Time: %.2f, Data Time %.2f, Total Running Time %.2f \n ",
	    timeval_diff(&tv_hash_start, &tv_data_start),
	    timeval_diff(&tv_data_start, &tv_data_end),
	    timeval_diff(&gcp_start, &tv_data_end));

    exit(0);
}

void
put_oid(ptr<aclnt> gcp_c, char *destpath,
	str err, ptr<gcp_put_arg > arg)
{
    if (err) {
	warnx << err << "\n";
        return;
    }

    if (gcp_c == NULL) {
	str foo = strbuf() << arg->oid.id;
	printf("PUT_OID:%s\n", foo.cstr());
	exit(0);
    }

    //put in the destination directory
    arg->file.destpath = str(destpath);

    //dont care if i include file name here for single oid transfers
    //dwarn(DEBUG_CLIENT) << "Hence my destination is " << arg->file.destpath << "\n";

    ref<gcp_put_res> cli_res = New refcounted<gcp_put_res>;
    gettimeofday(&tv_data_start, NULL);
    gcp_c->call(GCP_PROC_PUT, arg, cli_res,
                wrap(put_oid_done, cli_res));
}


static void
do_putinto_td(ptr<aclnt> gcp_c, ptr<gcp_sput_arg> td, ref<aclnt> gtc_c,
	      char *destpath, cbs cb, str err, ptr<gcp_put_arg> arg)
{
    td_pending--;
    
    if (err) {
        warnx << err << "\n";
	err_flag = true;
	(*cb)(err);
        return;
    }

    td->list.push_back(*arg);
    (*cb)(NULL);
}

static str
get_rel_path(FTSENT *ftsentp)
{
    char *r = ftsentp->fts_path + ftsentp->fts_pathlen;
    int level = ftsentp->fts_level + 1;
    str rel_path;

    if (level == 1)
        rel_path = "./";
    else {
        while (r >= ftsentp->fts_path && level > 0) {
            if (*r == '/')
                level--;
            r--;
        }
        char *p = strrchr(++r, '/');
        assert(p);
        rel_path = str(r, p-r+1);
    }

    dwarn(DEBUG_CLIENT) << "Relative path " << rel_path << "\n";
    return rel_path;
}

static str
xreadlink(const char *path)
{
    char buf[256];
    int n = readlink(path, buf, sizeof(buf) - 1);
    if (n < 0) {
        warn("readlink failed: %m: %s\n", path);
        return "";
    }
    buf[n] = '\0';
    return str(buf, n);
}

void
process_ent(char *path, ref<aclnt> gtc_c, ptr<aclnt> gcp_c,
            bool passfd, ptr<gcp_sput_arg > td, char *destpath,
	    FTSENT *ftsentp, cbs cb)
{
    /* ignore post-order entry */
    if (ftsentp->fts_info == FTS_DP) {
	(*cb)(NULL);
        return;
    }
    
    dwarn(DEBUG_CLIENT)
        << "User-specific path = " << path
        << "\nfts_path = " << ftsentp->fts_path
        << "\nfts_level = " << ftsentp->fts_level
        << "\n";
    
    switch (ftsentp->fts_info) {
    case FTS_SL:
    case FTS_D:
    {
        dwarn(DEBUG_CLIENT) << ((ftsentp->fts_info == FTS_D) ? "DIRECTORY" : "SYMLINK") << "\n";

        str rel_path = get_rel_path(ftsentp);
        struct stat statbuf = *(ftsentp->fts_statp);
        td_pending++;
	    
        ptr<gcp_put_arg> arg = New refcounted<gcp_put_arg>;
        arg->file.size = statbuf.st_size;
        arg->file.uid = statbuf.st_uid;
        arg->file.gid = statbuf.st_gid;
        arg->file.mode = statbuf.st_mode;
        arg->file.modtime = statbuf.st_mtime;
        arg->file.destpath = strbuf() << rel_path << ftsentp->fts_name;
        if (ftsentp->fts_info == FTS_SL) {
            arg->type = OID_SYMLINK;
            arg->file.filename = xreadlink(ftsentp->fts_accpath);
        }
        else {
            arg->type = OID_DIR;
            arg->file.filename = "";
        }
        do_putinto_td(gcp_c, td, gtc_c, destpath, cb, NULL, arg);
        break;
    }
    case FTS_F:
    {
        dwarn(DEBUG_CLIENT) << "FILE\n";

        str rel_path = get_rel_path(ftsentp);
        struct stat statbuf = *(ftsentp->fts_statp);
        td_pending++;
        
        str cname = strbuf() << ftsentp->fts_path;
        vNew gcp_put(cname, rel_path, gtc_c, passfd, statbuf, OID_FILE,
                     wrap(do_putinto_td, gcp_c, td, gtc_c, destpath, cb));
        break;
    }
    case FTS_ERR:
        warnx("[Error: %s]\n", strerror(ftsentp->fts_errno));
	(*cb)(NULL);
        break;
    default:
        warnx("???\n");
	(*cb)(NULL);
    }
}

# 291 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
class do_put__closure_t : public closure_t { public:   do_put__closure_t ( char  * *files,  int numfiles,  ref< aclnt > gtc_c,  ptr< aclnt > gcp_c,  char *destpath,  bool passfd) : closure_t (false),  _stack (files, numfiles, gtc_c, gcp_c, destpath, passfd), _args (files, numfiles, gtc_c, gcp_c, destpath, passfd), _block1 (0), _cb_num_calls1 (0) {}   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T:316: in function fts_block", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &do_put__closure_t::reenter));   }   void reenter ()   {     do_put (_args.files, _args.numfiles, _args.gtc_c, _args.gcp_c, _args.destpath, _args.passfd, mkref (this));   }   struct stack_t {     stack_t ( char  * *files,  int numfiles,  ref< aclnt > gtc_c,  ptr< aclnt > gcp_c,  char *destpath,  bool passfd) {}      ptr< gcp_sput_arg > td;      str err;      vec< char *> paths;      ftsfunc_bl cb;   };   struct args_t {     args_t ( char  * *files,  int numfiles,  ref< aclnt > gtc_c,  ptr< aclnt > gcp_c,  char *destpath,  bool passfd) : files (files), numfiles (numfiles), gtc_c (gtc_c), gcp_c (gcp_c), destpath (destpath), passfd (passfd) {}      char  * *files;      int numfiles;      ref< aclnt > gtc_c;      ptr< aclnt > gcp_c;      char *destpath;      bool passfd;   };   stack_t _stack;   args_t _args;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 291 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
void 
do_put( char  * *__tame_files,  int __tame_numfiles,  ref< aclnt > __tame_gtc_c,  ptr< aclnt > __tame_gcp_c,  char *__tame_destpath,  bool __tame_passfd, ptr<closure_t> __cls_g)
{
# 294 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

    
# 295 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  do_put__closure_t *__cls;   ptr<do_put__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<do_put__closure_t> (__tame_files, __tame_numfiles, __tame_gtc_c, __tame_gcp_c, __tame_destpath, __tame_passfd);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;   } else {     __cls =     reinterpret_cast<do_put__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< gcp_sput_arg > &td = __cls->_stack.td;    str &err = __cls->_stack.err;    vec< char *> &paths = __cls->_stack.paths;    ftsfunc_bl &cb = __cls->_stack.cb;    char  * *&files = __cls->_args.files;    int &numfiles = __cls->_args.numfiles;    ref< aclnt > &gtc_c = __cls->_args.gtc_c;    ptr< aclnt > &gcp_c = __cls->_args.gcp_c;    char *&destpath = __cls->_args.destpath;    bool &passfd = __cls->_args.passfd;    use_reference (files);     use_reference (numfiles);     use_reference (gtc_c);     use_reference (gcp_c);     use_reference (destpath);     use_reference (passfd);    switch (__cls->jumpto ()) {   case 1:     goto do_put__label_1;     break;   default:     break;   }
# 300 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

    
    td_pending = 0;
    err_flag = false;
    
    if (numfiles <= 0)
        exit(0);

    td = New refcounted<gcp_sput_arg>;

    while (numfiles-- > 0) {
	paths.clear();
        paths.push_back(*files);
        paths.push_back(NULL);
        cb = wrap(process_ent, *files, gtc_c, gcp_c, passfd, td, destpath);
        
# 315 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 315 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

            fts_block(paths, FTS_PHYSICAL | FTS_XDEV | FTS_NOCHDIR, cb, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
        
# 317 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
    if (--__cls->_block1)       return;   } while (0);  do_put__label_1:     ;
# 317 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

	*files++;
    }

    if (td_pending <= 0) {

	warnx << "Done putting " << td->list.size() << " files\n";

	if (err_flag) {
	    warnx << "Error in one of the files\n";
	    exit(1);
	}
	    	
        if (td->list.size() == 0) {
            warnx << "No valid files found\n";
            exit(1);
        }
        else if (td->list.size() == 1) {
            //If only one file, send it directly;  don't use a TD
	    ptr<gcp_put_arg> arg = New refcounted<gcp_put_arg>;
	    *arg = td->list[0];
	    put_oid(gcp_c, destpath, NULL, arg);
        }
        else {
	    rpc_bytes<> value;
	    ptr<suio> in = New refcounted<suio>;
	    if (!xdr2bytes(value, *td))
                fatal << "Could not marshal tree descriptor\n";
	    in->copy(value.base(), value.size());
	    dwarn(DEBUG_CLIENT) << "Putting TD of size "
				<< value.size() << "\n";
	    vNew gcp_put(in, gtc_c, OID_TREE,
			 wrap(put_oid, gcp_c, destpath));
        }
    }
# 352 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  return;
# 352 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
}

# 354 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
class fts_block__closure_t : public closure_t { public:   fts_block__closure_t ( vec< char *> paths,  int options,  ftsfunc_bl cb,  cbs cb1) : closure_t (false),  _stack (paths, options, cb, cb1), _args (paths, options, cb, cb1), _block1 (0), _cb_num_calls1 (0) {}   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T:371: in function do_put", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &fts_block__closure_t::reenter));   }   void reenter ()   {     fts_block (_args.paths, _args.options, _args.cb, _args.cb1, mkref (this));   }   struct stack_t {     stack_t ( vec< char *> paths,  int options,  ftsfunc_bl cb,  cbs cb1) {}      FTS *ftsp;      FTSENT *ftsentp;      str err;   };   struct args_t {     args_t ( vec< char *> paths,  int options,  ftsfunc_bl cb,  cbs cb1) : paths (paths), options (options), cb (cb), cb1 (cb1) {}      vec< char *> paths;      int options;      ftsfunc_bl cb;      cbs cb1;   };   stack_t _stack;   args_t _args;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 354 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
void 
fts_block( vec< char *> __tame_paths,  int __tame_options,  ftsfunc_bl __tame_cb,  cbs __tame_cb1, ptr<closure_t> __cls_g)
{
    
# 357 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  fts_block__closure_t *__cls;   ptr<fts_block__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<fts_block__closure_t> (__tame_paths, __tame_options, __tame_cb, __tame_cb1);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;   } else {     __cls =     reinterpret_cast<fts_block__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    FTS *&ftsp = __cls->_stack.ftsp;    FTSENT *&ftsentp = __cls->_stack.ftsentp;    str &err = __cls->_stack.err;    vec< char *> &paths = __cls->_args.paths;    int &options = __cls->_args.options;    ftsfunc_bl &cb = __cls->_args.cb;    cbs &cb1 = __cls->_args.cb1;    use_reference (paths);     use_reference (options);     use_reference (cb);     use_reference (cb1);    switch (__cls->jumpto ()) {   case 1:     goto fts_block__label_1;     break;   default:     break;   }
# 361 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

    
    ftsp = fts_open(paths.base(), options, NULL);
    if (!ftsp) {
        warn("fts_open: %m\n");
        
# 366 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
return ;
    }

    while ((ftsentp = fts_read(ftsp))) {
	
# 370 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 370 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

	    (*cb) (ftsentp, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
	
# 372 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
    if (--__cls->_block1)       return;   } while (0);  fts_block__label_1:     ;
# 372 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"

    }
    if (errno) {
        warn("fts_read: %m\n");
        
# 376 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
return ;
    }
    
    fts_close(ftsp);
    (*cb1)(err);
# 381 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
  return;
# 381 "/Users/dga/Documents/dot/src/trunk/gcp/gcp_put.T"
}
