#include "dot_fts.h"

void
process_ent(FTSENT *ftsentp)
{
    /* ignore post-order entry */
    if (ftsentp->fts_info == FTS_DP)
        return;

    warnx("%-50s", ftsentp->fts_path);
    switch (ftsentp->fts_info) {
    case FTS_D:
        warnx("DIRECTORY\n");
        break;
    case FTS_SL:
        warnx("SYMLINK\n");
        break;
    case FTS_F:
        warnx("%lu\n", ftsentp->fts_statp->st_size);
        break;
    case FTS_ERR:
        warnx("[Error: %s]\n", strerror(ftsentp->fts_errno));
        break;
    default:
        warnx("???\n");
    }
}

int
main(int argc, char **argv)
{
    int ret;
    vec<char *> paths;

    argv++;
    argc--;

    if (argc <= 0)
        return 0;

    while (argc-- > 0)
        paths.push_back(*argv++);
    paths.push_back(NULL);

    ret = fts(paths, FTS_PHYSICAL | FTS_XDEV, wrap(process_ent));
    return ret;
}
