import java.lang.*; 
import java.net.*;
import java.io.*;
import java.util.*;

public class VoiceThread extends Thread {

  private String addr; //where to communicate
  private int port; //to which port it is listening to
  private UDPSend receiver;
  private String voiceFile;
  private long filesize;
  private int  rate;
  private int  duplex;
  private int  sleepinterval;
  private static final int verbose = 1;

  public VoiceThread(String paddr, int pport, int pduplex, String pvoiceFile,
		     long pfilesize, int prate, int psleepinterval) {

    addr = new String(paddr);
    port = pport;
    voiceFile = new String(pvoiceFile);
    filesize = pfilesize;
    rate = prate;
    duplex = pduplex;
    sleepinterval= psleepinterval;
    
    System.out.println(" VoiceThread CREATE: send " + pfilesize + "B @ "+rate+" to " 
                       + addr + ":" + port);
    receiver = new UDPSend(addr, port, null, filesize); 
  }

  public void run() {
    long startT, endT, next_sleep;
    byte [] voice_data = new byte[Constants.voice_pkt_size];
    FileInputStream voiceStream;
    long pktinterval;
    int len, totalwritten;
 
    totalwritten = 0;
    startT = System.currentTimeMillis();
    System.out.println(" VoiceThread START: send " + filesize + "B @ "+rate+" to " 
                       + addr + ":" + port);

    // Constant bit rate
    pktinterval = Constants.timethreshold / rate;

    try {      
      voiceStream = new FileInputStream(voiceFile);      
    } catch (Exception e) {
      System.out.println("Can't open '" + voiceFile + "' -- " + e);
      return;
    }
   
    try {

      //If I am generated automatically as a reply call then start with a sleep interval
      if (duplex == 1) {
        gotoSleep(sleepinterval*1000);
      }
      next_sleep = System.currentTimeMillis() + sleepinterval*1000;

      while(voiceStream.available() !=0 ) {

	len = voiceStream.read(voice_data);
	
	if (len == -1)  {
	  if (verbose > 2) {System.out.println("VoiceThread: EOF");}
	  break;
	}

	totalwritten += len;
	receiver.sendData(voice_data, len);
	
	if (System.currentTimeMillis() >= next_sleep) {
	  if (verbose > 3) { System.out.println(" sleeping..."); }
	  gotoSleep(sleepinterval*1000);
	  if (verbose > 3) { System.out.println(" done with sleep."); }
	  next_sleep = System.currentTimeMillis() + sleepinterval*1000;
	} else {
	  gotoSleep(pktinterval);
	}
      } // end of while data available in file

    } catch (Exception e) {
      System.out.println("VoiceThread: loop " + e.getMessage());
      // Fall through
    }

    try {

      voiceStream.close();
      receiver.close();
 
    } catch (IOException e) {
      System.out.println("VoiceThread: closing down " + e.getMessage());
    }

    endT = System.currentTimeMillis();
    if (verbose > 0) {
      System.out.print("Sent " + totalwritten + " in " + (endT - startT) + " msec");
      System.out.println("   BW " + (totalwritten * 1000 / (endT - startT)));
    }
    
    if (verbose > 0) { System.out.println("VoiceThread: END\n"); }
  }

  private boolean gotoSleep(long how_long) {
    try {
      if (verbose > 3) { System.out.println(" Sleeping for " + how_long); }
      sleep(how_long);
    }
    catch (InterruptedException e) {
      return(true);
    }
    return(false);
  }
}
