//The main module that handles voice application data

import java.io.*;
import java.net.*;
import java.util.*;

public class Voice extends Thread {
  
  private Random rand;
  private VoiceParameters vparams;
  private UDPServer udp;
  private boolean call_in_progress;
  private List TimerList;

  private boolean verbose = true;

  public Voice () {
    
    rand = new Random();
    call_in_progress = false;

    Parser vparser = new Parser();
    try {
      vparams = vparser.getVoice();
    } catch(IOException e) {
      System.out.println(e.getMessage());
      System.exit(0);
    }
    
  }

  public void run() {
	  long startT, endT, currentT;
	  int sendrate;
	  int destnode, inputfile;
	  VoiceThread mythread; // do it a vector
	  VoiceThreadData ThreadData;
	  long next_call;
	  
	  // Start the UDP Server which is responsible for serving call and file
	  // tranfer requests
	  udp = new UDPServer(Constants.serverport, this);
	  udp.start();
	  System.out.println(" Started UDP server for Voice traffic\n");

	  // Check if we can initiate calls
	  if (vparams.status_enabled == 0) {
		  System.out.println(" Will not initiate any calls\n");
		  return;
	  }

	  while(true) {

		  /* pick a delay so the average wait is hourtime / (#call/hr) */
		  next_call =  Math.round(rand.nextFloat() * 2 * (Constants.hourtimer / vparams.nch));
		  if (verbose) System.out.println("Voice: sleeping for " + next_call);
		  gotoSleep(next_call);
		  if (verbose) System.out.println("Voice: awaking now");

		  // Select randomly a destination node and a file
		  destnode = Math.round((vparams.ncbe-1)*(new Random().nextFloat())); 
		  inputfile = Math.round((vparams.nfiles-1)*(new Random().nextFloat()));
		  sendrate = Math.round((vparams.nrates-1)*(new Random().nextFloat())); 
		  
		  ThreadData = new VoiceThreadData(((CallBook)vparams.cbook.elementAt(destnode)).address,
						   ((Files)vparams.files.elementAt(inputfile)).name);
		  
		  mythread = new VoiceThread(((CallBook)vparams.cbook.elementAt(destnode)).address,
					     Constants.serverport, 0,
					     ((Files)vparams.files.elementAt(inputfile)).name, 
					     ((Files)vparams.files.elementAt(inputfile)).length,
					     ((Integer)vparams.rates.elementAt(sendrate)).intValue(),
					     vparams.interval); 


		  call_in_progress = true;

		  mythread.start();
		  try {
			  mythread.join();
		  } catch (InterruptedException e) {
			  System.out.println("While waiting for voice call to finish " + e);
			  System.exit(-1);
		  }
		  
		  call_in_progress = false;
	  }
  }

  public void GenerateAnswerCall(String paddr) {
    int inputfile, sendrate;
    VoiceThread mythread;

    if (verbose) System.out.println("considering answer call to '"+paddr+"'");

    if (call_in_progress) {
	    if (verbose) 
		    System.out.println("Call already in progress - skipping return call to "+paddr);
	    return;
    }

    if (verbose) {
	    System.out.println(" --------------------------------- ");
	    System.out.println(" Generate Answering voice call to " + paddr);
	    System.out.println(" --------------------------------- ");
    }

    inputfile = Math.round((vparams.nfiles-1)*(new Random().nextFloat())); 
    sendrate = Math.round((vparams.nrates-1)*(new Random().nextFloat())); 
    mythread = new VoiceThread(paddr, Constants.serverport, 1,
			       ((Files)vparams.files.elementAt(inputfile)).name,
			       ((Files)vparams.files.elementAt(inputfile)).length,
			       ((Integer)vparams.rates.elementAt(sendrate)).intValue(),
			       vparams.interval);
    mythread.start();
  }


  // Used by the GUI to inform the application to initiate a manual call
  public void ManualCall(String paddr) {
    int inputfile, sendrate;
    VoiceThread mythread;

    
    System.out.println(" --------------------------------- ");
    System.out.println(" Duplex Call to " + paddr);
    System.out.println(" --------------------------------- ");

    inputfile = Math.round((vparams.nfiles-1)*(new Random().nextFloat())); 
    sendrate = Math.round((vparams.nrates-1)*(new Random().nextFloat())); 
    mythread = new VoiceThread(
			       paddr, Constants.serverport, 1,
			       ((Files)vparams.files.elementAt(inputfile)).name,
			       ((Files)vparams.files.elementAt(inputfile)).length,
			       ((Integer)vparams.rates.elementAt(sendrate)).intValue(),
			       vparams.interval);
    mythread.start();
  }


  //Do it
  public synchronized void ThreadDied() {
  }

  private boolean gotoSleep(long howlong) {
    try {
      sleep(howlong);
    } catch(InterruptedException e) {
      return (true);
    }

    return (false);
  }

  public void CallEnded(String addr, int port) {

  }

}
