import java.lang.*; 
import java.net.*;
import java.io.*;
import java.util.*;

public class VIMSThread extends Thread {

  private String addr; //where to communicate
  private int port; //to which port it is listening to
  private TCPSend receiver;
  private String vimsFile;
  private long filesize;

  public VIMSThread(String paddr, int pport, String pvimsFile, long pfilesize) {

    addr = new String(paddr);
    port = pport;
    vimsFile = new String(pvimsFile);
    filesize = pfilesize;
    receiver = new TCPSend(addr, port, null); 
    System.out.println(" Addr " + addr + " Port " + port + " File " + vimsFile);
  }

  public void run() {
    System.out.println(" VIMS THread launched");
    receiver.sendData(vimsFile, filesize);
    receiver.close();
  }

  private boolean gotoSleep(long how_long) {
      try {
        sleep(how_long);
      }
      catch (InterruptedException e) {
        return(true);
      }
      return(false);
  }

}


