//The main module that handles voice application data

import java.io.*;
import java.net.*;
import java.util.*;

public class VIMS extends Thread {

 private VimsParameters vimsparams;
 private TCPServer tcp;
 private Hashtable HourThread; //which nodes have been called within an hour
 private List TimerList;
 private static final boolean verbose = false;

 public VIMS () {

   Parser vimsparser = new Parser();

   try {
     vimsparams = vimsparser.getVims();
   }
   catch(IOException e) {
     System.out.println(e.getMessage());
     System.exit(0);
   }

   HourThread = new Hashtable();
   TimerList = new List();
 }

 public void run() {
   long startT, endT, currentT;
   int hourcallcounter, destnode, inputfile, combinations, partialcounter;
   VIMSThread mythread;
   VIMSThreadData ThreadData;
   String myKey;
   long leftSleep, rightSleep; //ranges where I have to sleep. The diff is the
                               //amount of ms

   tcp = new TCPServer(Constants.tcpVIMSport, null);
   tcp.start();

   // Check if we can initiate calls
   System.out.println("In VIMS.java");
   if (vimsparams.status_enabled == 0) {
        System.out.println(" Will not initiate any calls\n");
	return;
   }

   System.out.println(" Calls/hr " + vimsparams.nch);


   TimerList.GenerateData(vimsparams.nch);
   //TimerList.print();

   while(true) {
     startT = ((new Date()).getTime());
     currentT = startT;
     hourcallcounter = 0;
     partialcounter = 0; // counter used in case the combinations are less
     // than the maximum calls per hour
     HourThread.clear();
     combinations = vimsparams.ncbe * vimsparams.nfiles;

     leftSleep = 0;
     rightSleep = TimerList.getNext(); 
     System.out.println("VIMS: Sleeping for " + (rightSleep - leftSleep));
     gotoSleep((rightSleep - leftSleep));
     leftSleep = rightSleep;

     while(((currentT - startT) < Constants.hourtimer) &&
	   (hourcallcounter < vimsparams.nch)) {

       // Select randomly a destination node and a file
       destnode= Math.round((vimsparams.ncbe-1)*(new Random().nextFloat())); 
       inputfile=Math.round((vimsparams.nfiles-1)*(new Random().nextFloat())); 

       //Construct a key for the HashTable
       myKey = new String(((CallBook)vimsparams.cbook.elementAt(destnode)).address
                           +((Files)vimsparams.files.elementAt(inputfile)).name);

       ThreadData = new VIMSThreadData(((CallBook)vimsparams.cbook.elementAt(destnode)).address, 
				       ((Files)vimsparams.files.elementAt(inputfile)).name);

       if (HourThread.containsKey(myKey) == false) {
	 HourThread.put(myKey, ThreadData);
       } else {
	 gotoSleep(1); //without this line GUI is not able to start.
	 //else it is a spin loop.
	 continue;
       }

       if (verbose) System.out.println(myKey);
          
       mythread = new VIMSThread(
				 ((CallBook)vimsparams.cbook.elementAt(destnode)).address,
				 Constants.tcpVIMSport,
				 ((Files)vimsparams.files.elementAt(inputfile)).name,
				 ((Files)vimsparams.files.elementAt(inputfile)).length);
       mythread.start();

       hourcallcounter++;
       partialcounter++;
       currentT = ((new Date()).getTime());
       if ((partialcounter == combinations)&&(combinations <vimsparams.nch)){
	 HourThread.clear();
	 partialcounter=0;
       }
       rightSleep = TimerList.getNext(); 
       System.out.println(" Sleeping for " + (rightSleep - leftSleep));
       gotoSleep((rightSleep - leftSleep));
       leftSleep = rightSleep;
     }
     if (hourcallcounter == vimsparams.nch) {
       System.out.println(" Going to sleep for a long time...");
       try {
	 sleep(Constants.hourtimer - (((new Date()).getTime())-startT));
       }
       catch(Exception e) {
	 System.out.println(e.getMessage());
       }     
     }
   } // end while true
 }

  private boolean gotoSleep(long howlong) {
    try {
      sleep(howlong);
    }
    catch(InterruptedException e) {
      return (true);
    }

    return (false);
  }

}
