import java.net.*;
import java.io.*;
import java.util.*;

public class UDPSend extends Thread {
  int port; 
  DatagramSocket socket;
  Socket controlSocket;
  InetAddress addr;
  DatagramPacket packet;
  FileWriter log;
  Calendar now = new GregorianCalendar();
  String s = new String("");
  boolean SingleFile = false;
  int localPort;
  BufferedWriter out;

  private static final boolean verbose = false;

  private ConnData conn = null;
  private Node node = null;
  private long totalwritten = 0;
  private long totalfilesize;

  public UDPSend(String hostname, int serverport, FileWriter logFile, 
		 long totalfilesize) {

    // Reset local variable fileSize
    this.totalfilesize = totalfilesize;
    
    // Open (or append) a new log file
    // If logFile != null, use this file instead
    if (logFile==null) {
      SingleFile = false;
      try {
        if (Constants.Logging)
          log = new FileWriter(Constants.LogDir+hostname+":"+serverport+".log", true);
      } catch (Exception e) {
        System.out.println("UDPSend logging error: "+e);
      }
    } else {
      SingleFile = true;
      log = logFile;
    }

    // Try to find the address and prepare the socket
    this.port = serverport;
    try {
      addr = InetAddress.getByName(hostname);
    } catch (UnknownHostException e) {
      System.out.println("UDPSend error: "+e);
    }
    try {
      socket = new DatagramSocket();
    } catch (SocketException e) {
      System.out.println("UDPSend error: "+e);
    }
    localPort = socket.getLocalPort();

    // Write start message
    Date trial = new Date();
    now.setTime(trial);
    s = "O "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
      " "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
	":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
      " UDP "+addr.getHostName()+" "+serverport+" "+totalfilesize;
    if (Constants.Logging)
      try {
      log.write(s+"\n");
      log.flush();
    } catch (Exception e) {
      System.out.println("UDPSend writing log error: "+e);
    }
    if (verbose) System.out.println(s);
    

    try {
	    InetAddress tempAddr = null;
	    tempAddr = InetAddress.getByName(Constants.LocalHost);
	    conn = new ConnData(PacketType.Voice, ConnMode.Sender, ConnStatus.Begin,
				socket.getLocalPort(), addr.getHostAddress(),
				totalfilesize, (new Date()).getTime());
	    
	    node = new Node(conn.type, conn.mode, conn.status, conn.port,
			    conn.correspondent, conn.bytes, conn.updatetime);
    } catch (UnknownHostException e){
	    System.out.println("Starting UDPsender: "+ e);
	    System.exit(-1);
    }
  }

  public void sendData(byte data[], int len) {
    // Send the data
    try {
      packet = new DatagramPacket(data, len, addr, port); 
      socket.send(packet);
      totalwritten += len;
      node.UpdateData(totalwritten, System.currentTimeMillis());
    } catch (Exception e) {
      System.out.println("UDPSend.sendData error: "+e);
    }
    // Write to log file
    String sdata = new String(data);
    Date trial = new Date();
    now.setTime(trial);
    s = "S "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
      " "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
      ":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
      " UDP "+addr.getHostName()+" "+port;
    
    if (Constants.Logging)
      try {
      log.write(s+"\n");
      log.flush();
    } catch (Exception e) {
      System.out.println("UDPSend.sendData logging error: "+e);
    }
  }
  
  public void close() {

    node.EndConn(totalwritten, (new Date()).getTime());

    // Write finish message
    Date trial = new Date();
    now.setTime(trial);
    s = "C "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
	" "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
	":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
	" UDP "+addr.getHostName()+" "+port;
    if (Constants.Logging)
      try {
        log.write(s+"\n");
        log.flush();
      } catch (Exception e) {
        System.out.println("UDPSend error: "+e);
      }
    if (verbose) System.out.println(s);

    // Send close signal to the server
    try {
      controlSocket = new Socket(addr, port+1);
      out = new BufferedWriter(new OutputStreamWriter(
			       controlSocket.getOutputStream()));
    } catch (Exception e) {
      System.out.println("UDPSend ControlSocket open: "+e);
    }

    try {
      out.write(""+localPort);
      out.newLine();
      out.write(""+totalfilesize);
      out.newLine();
      out.flush();
    } catch (Exception e) {
      System.out.println("UDPSend ControlSocket write: "+e);
    }

    try {
      out.close();
      controlSocket.close();
    } catch (Exception e) {
      System.out.println("UDPSend ControlSocket close: "+e);
    }

    // Close the log file if we're responsible
    if ((!SingleFile)&&(Constants.Logging)) {
      try {
	log.close();
      } catch (Exception e) {
	System.out.println("UDPSend error: "+e);
      }
    }
  }

}
