import java.net.*;
import java.io.*;
import java.util.*;

public class UDPHandler {

	private static final boolean verbose = false;

	String s;
	String ls;
	FileWriter out,log;
	String address;
        int port;
	Voice parent;
        private long datasend=0;
        int totalWritten;

        ConnData conn = null;
        Node node = null;

	public UDPHandler(DatagramPacket data, Voice myparent) {

                totalWritten = 0;

		try {
			if (Constants.Logging)
				log = new FileWriter(Constants.LogDir+data.getAddress().getHostName()+
						     ":"+data.getPort()+".log");
			if (Constants.AudioStore)
				out = new FileWriter(Constants.LogDir+data.getAddress().getHostName()+
						     ":"+data.getPort()+".wav");
		} catch (Exception e) {
			System.out.println("UDPHandler :"+e);
		}

		parent = myparent;
		port = data.getPort();
		address = data.getAddress().getHostName();
		
		if (Constants.Logging) {
			Calendar now = new GregorianCalendar();
			Date trial = new Date();
			now.setTime(trial);
			ls = "A "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
				" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
				now.get(Calendar.MINUTE)+":"+
				now.get(Calendar.SECOND)+
				"."+now.get(Calendar.MILLISECOND) + 
				" UDP "+ address+" "+port;
			
			try {
				log.write(ls+"\n",0,ls.length()+1);
			} catch (IOException e) {
				System.out.println("UDPHandler: "+e);
			}
		}

                conn = new ConnData(PacketType.Voice, ConnMode.Receiver,
				    ConnStatus.Begin, data.getPort(),
				    data.getAddress().getHostAddress(), 
				    0, (new Date()).getTime());

               node = new Node(conn.type, conn.mode, conn.status, conn.port,
			       conn.correspondent, conn.bytes, conn.updatetime);

	       Process(data);
	}

	public void Process(DatagramPacket data) {
		int dataLen = data.getLength();
		
		s = new String(data.getData(),0,dataLen);
		if (((s.charAt(dataLen-1)=='a')&&(dataLen%2==0))||
		    ((s.charAt(dataLen-1)=='b')&&(dataLen%2!=0))) {
			dataLen--;
			s = s.substring(0,dataLen);
		}
                totalWritten += dataLen;
		Calendar now = new GregorianCalendar();
		Date trial = new Date();
		now.setTime(trial);
                datasend += dataLen;
                node.UpdateData(datasend, (new Date()).getTime());

		ls = "R "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
			" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
			now.get(Calendar.MINUTE)+":"+
			now.get(Calendar.SECOND)+
			"."+now.get(Calendar.MILLISECOND) + 
			" UDP "+ data.getAddress().getHostName()+" "+
			data.getPort()+" ";
		
		try {
			if (Constants.AudioStore) {
				out.write(s,0,s.length());
				out.flush();
			}
		} catch (IOException e) {
			System.out.println("UDPHandler: "+e);
		}
	}

	public void Close(int fileSize) {

		char x[] = {'x'};
		try {
			node.EndConn(datasend, (new Date()).getTime());
			if (verbose)
				System.out.println("Padding for "+(fileSize-totalWritten));
			if (Constants.AudioStore) {
				for (int i = totalWritten; i<fileSize; i++) {
					out.write(x,0,1);
				}
				out.close();
			}
		} catch (IOException e) {
			System.out.println("UDPHandler: "+e);
		}

		if (parent!=null) {
			parent.CallEnded(address, port);
		}

		Calendar now = new GregorianCalendar();
		Date trial = new Date();
		now.setTime(trial);
		ls = "C "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
			" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
			now.get(Calendar.MINUTE)+":"+
			now.get(Calendar.SECOND)+
			"."+now.get(Calendar.MILLISECOND) + 
			" UDP "+ address+" "+ port + " "+fileSize;

		if (verbose) System.out.println(ls);
		
		if (Constants.Logging)
			try {
			log.write(ls+"\n",0,ls.length()+1);
			log.flush();
			log.close();
		} catch (IOException e) {
			System.out.println("UDPHandler: "+e);
		}

	}

}
