import java.net.*;
import java.io.*;
import java.util.*;

public class TCPServer extends Thread {
	ServerSocket socket;
	Socket clientSocket = null;
	int port;
	byte[] buffer = new byte[32];
	String s;
	InetAddress group;
	FileWriter out;

	public static void main(String[] argv) {
		FileWriter outfile = null;

		if (Constants.Logging)
		  try {
		    outfile = new FileWriter(Constants.LogDir+"tcp.log", true);
		  } catch (Exception e) {
		    System.out.println("TCPServer: "+e);
		  }
		TCPServer tcp = new TCPServer(Constants.tcpSISport, outfile);
		tcp.start();
	}

	public TCPServer(int portNo, FileWriter outfile) {
		// Updates local variables, creates new log files if
		// necessary
		port = portNo;
		if (outfile==null && Constants.Logging) {
		  try {
		    out = new FileWriter(""+portNo+".log", true);
		  } catch (Exception e) {
		    e.printStackTrace();
		    System.out.println("TCPServer: "+e);
		    System.exit(-1);
		  }
		} else {
		  out = outfile;
		}
	}

	public void run() {
		try {
		  socket = new ServerSocket(port);
		} catch (IOException e) {
		  e.printStackTrace();
		  System.out.println("TCPServer.run "+e);
		}

		while (true) {
		  ProcessPacket();
		}
	}

	public void ProcessPacket() {
                int apptype=PacketType.UnKnown;

		try {
		  clientSocket = socket.accept();
		} catch (IOException e) {
		  System.out.println("TCPServer.accept "+e);
		}

                switch (port) {

		case Constants.tcpSISport:
			apptype = PacketType.SIS;
			break;

		case Constants.tcpVIMSport:
			apptype = PacketType.VIMS;
			break;

		case Constants.tcpALSport:
			apptype = PacketType.ALS;
			break;

		default:
			System.out.println("Unknown port " +port+" while accepting connection");
			new Throwable().printStackTrace();
			System.exit(-1);
			break;
                }

		new TCPHandler(apptype, clientSocket,"CATtest", out).start();
	}
}
