import java.net.*;
import java.io.*;
import java.util.*;

/* send a file to the server using TCP.

   I did not write this code.  I am not responsible.... I have
   attempted to fix and document stuff as possible and required -dam

   - open a connection to the server port, write the name of file to
   send over 
   - read from connection a port number (in ascii), called the data
   port

   foreach TCPSendData()
    =  notify PCTD of connection start
    =  open connection to data port
    =  send data, sending PCTD updates
    =  close data connection


    For ALS data, we keep sending the same file again and again...
    for ALS data, we don't send PCTD the start and end, since we have
    no way to know how many total bytes will be xfered.  By not having
    the sender begin and end messages, we make the vizualizer show N/A
    in the percent rcvd column, while is exactly what we want.  the
    number of bytes received will be correctly displayed, since it
    comes from the receiver's updates (which are still being sent)

   */



public class TCPSend {
  int port; 
  Socket socket;
  Socket dataSock;
  InetAddress addr;
  DatagramPacket packet;
  FileWriter log;
  Calendar now = new GregorianCalendar();
  String s = new String("");
  boolean SingleFile = false;
  BufferedWriter out;
  BufferedReader in;
  BufferedOutputStream outFile;
  boolean success = false;
  

  private boolean verbose = false;
  private ConnData conn = null;
  private long totalwritten=0;

  // The port is : 12348 as defined by the tcpIMAGEport in the Constants.java
  public static void main(String[] argv) {
	  if (argv.length!=3) {
		  System.out.println("Incorrect number of arguments !");
		  System.out.println();
		  System.out.println("Syntax: TCPServer IPAddr PortNo FileName");
		  System.out.println("Example: TCPServer 204.194.28.131 11111 test.dat");
		  System.exit(-1);
	  }
	  System.out.println("Sending file "+argv[2]+" to "+argv[0]+":"+argv[1]);
	  Integer X = new Integer(argv[1]);
	  int PortNumber = X.intValue();
	  TCPSend tcp = new TCPSend(argv[0], PortNumber, null);

	  // A patch added by Yannis because we need initially to send to the 
	  // begin message to the visualizer the size. If it is zero then we will
	  // check it in the send Data method and get the filesize
	  // I know it is bad ;-)
      
	  tcp.sendData(argv[2], 0);
	  tcp.close();
  }

  public TCPSend(String hostname, int serverport, FileWriter logFile) {
	  // Open (or append) a new log file
	  // If logFile != null, use this file instead
	  if (logFile==null && Constants.Logging) {
		  SingleFile = false;
		  try {
			  log = new FileWriter(Constants.LogDir+hostname+":"+serverport+".log", true);
		  } catch (Exception e) {
			  e.printStackTrace();
			  System.out.println("TCPServer: opening log: "+e);
			  System.exit(-1);
		  }
	  } else {
		  SingleFile = true;
		  log = logFile;
	  }

	  // Try to find the address and prepare the socket
	  this.port = serverport;

	  if (verbose)
		  System.out.println(" Ok in the TCP SEND up to now with hostname " + hostname);

	  int count = 0;
	  while ((!success)&&(count<3)) {
		  System.out.println("LOOP "+count);
		  success = true;
		  count++;
		  try {
			  addr = InetAddress.getByName(hostname);
		  } catch (UnknownHostException e) {
			  success = false;
			  e.printStackTrace();
			  System.out.println("TCPSend: gethostname :"+e);
		  }
		  try {
			  socket = new Socket(addr, port);
		  } catch (Exception e) {
			  success = false;
			  e.printStackTrace();
			  System.out.println("TCPSend: socket: "+e);
		  }
		  if (!success) gotoSleep(1000);
	  }

	  if (!success) {
		  System.out.println("Give up trying to "+hostname);
		  return;
	  } 

	  // Write start message
	  Date trial = new Date();
	  now.setTime(trial);
	  s = "O "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
		  " "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
		  ":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
		  " "+addr.getHostName()+" "+serverport;
	  if (Constants.Logging) {
		  try {
			  log.write(s+'\n');
			  log.flush();
		  } catch (Exception e) {
			  System.out.println("TCPSend error: "+e);
		  }
	  }
	  if (verbose) System.out.println(s);
	  
	  // Open the char socket
	  try {
		  out= new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
		  in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
	  } catch (Exception e) {
		  System.out.println("TCPSend file&socket: "+e);
	  }
  }

  public void sendData(String inFile, long pfilesize) {
	  int type = PacketType.UnKnown;
	  long filesize = 0;
	  Node node = null;
	  FileInputStream inputFile = null;

	  if (!success) {
		  return;
	  }
	  if (pfilesize == 0) {
		  FileInputStream tempfile;

		  try {
			  tempfile = new FileInputStream(inFile);
			  filesize = tempfile.available(); 
			  tempfile.close();
		  } catch (Exception e) {
			  e.printStackTrace();
			  System.out.println(e.getMessage());
			  System.exit(-1);
		  }
	  } else {
		  filesize = pfilesize;
	  }

	  switch(port) {
	  case Constants.tcpVIMSport:
		  type = PacketType.VIMS;
		  break;
	  case Constants.tcpSISport:
		  type = PacketType.SIS;
		  break;
	  case Constants.tcpALSport:
		  type = PacketType.ALS;
		  break;
	  default:
		  System.out.println("Unknown destination port "+port);
		  System.out.println("  dying...");
		  new Throwable("unknown port").printStackTrace();
		  System.exit(-1);
	  }

	  // Open the file
	  try {
		  inputFile = new FileInputStream(inFile);
	  } catch (Exception e) {
		  System.out.println("TCPSend file&socket: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }

	  // Send the filename
	  try {
		  out.write(inFile, 0, inFile.length());
		  out.newLine();
		  out.flush();
	  } catch (Exception e) {
		  System.out.println("TCPSend fname: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }

	  // Get the data socket number
	  Integer SockNo = null;
	  try {
		  SockNo = new Integer(in.readLine());
	  } catch (Exception e) {
		  System.out.println("TCPSend get sockno: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }

	  // Open the data socket and create the stream
	  // Setup byte stream, send the data and close stream
	  try {
		  dataSock = new Socket(addr, SockNo.intValue());
		  outFile = new BufferedOutputStream(dataSock.getOutputStream());
	  } catch (Exception e) {
		  System.out.println("TCPSend stream setup: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }


	  if (PacketType.ALS != type) {
		  // tell PCTD connection is starting
		  conn = new ConnData(type, ConnMode.Sender, ConnStatus.Begin,
				      socket.getLocalPort(),socket.getInetAddress().getHostAddress(),
				      filesize, (new Date()).getTime());
		  
		  node = new Node(conn.type, conn.mode, conn.status, conn.port,
				  conn.correspondent, conn.bytes, conn.updatetime);
	  }

	  int count;
	  boolean done = false;
	  try {
		  while (!done) {
			  while ((count = inputFile.read())!=-1) {
				  outFile.write(count);
				  totalwritten++;
			  }
			  done = true;
			  if (PacketType.ALS == type) {
				  // close and reopen the file and keep sending
				  done = false;
				  inputFile.close();
				  inputFile = new FileInputStream(inFile);
			  }			  
		  }
	  } catch (Exception e) {
		  System.out.println("TCPSend stream writing: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }


	  if (PacketType.ALS != type) {
		  // Tell PCTD we're done
		  node.EndConn(totalwritten, (new Date()).getTime());
	  }


	  try {
		  inputFile.close();
		  outFile.close();
		  dataSock.close();
	  } catch (Exception e) {
		  System.out.println("TCPSend stream close: "+e);
	  }

	  // Write to log file
	  Date trial = new Date();
	  now.setTime(trial);
	  s = "S "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
		  " "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
		  ":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
		  " "+addr.getHostName()+" "+port+" "+inFile;
	  if (Constants.Logging) {
		  try {
			  log.write(s+'\n');
			  log.flush();
		  } catch (Exception e) {
			  System.out.println("TCPSend log write: "+e);
		  }
	  }

	  if (verbose) System.out.println(s);

  }

  public void close() {

	  if (!success) {
		  return;
	  }

	  // Write finish message
	  Date trial = new Date();
	  now.setTime(trial);
	  s = "C "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
		  " "+now.get(Calendar.HOUR_OF_DAY)+":"+now.get(Calendar.MINUTE)+
		  ":"+now.get(Calendar.SECOND)+"."+now.get(Calendar.MILLISECOND)+
		  " "+addr.getHostName()+" "+port;
	  if (Constants.Logging) {
		  try {
			  log.write(s+'\n');
			  log.flush();
		  } catch (Exception e) {
			  System.out.println("TCPSend log write: "+e);
		  }
	  }
	  if (verbose) System.out.println(s);

      // Close the log file if we're responsible
	  if (!SingleFile) {
		  if (Constants.Logging)
			  try {
			  log.close();
		  } catch (Exception e) {
			  System.out.println("TCPSend log close: "+e);
		  }
	  }

	  // Close the socket
	  try {
		  out.close();
		  in.close();
		  socket.close();
	  } catch (Exception e) {
		  System.out.println("TCPSend socket close: "+e);
		  e.printStackTrace();
		  System.exit(-1);
	  }
  }

  private boolean gotoSleep(long howlong) {
	  try {
		  if (verbose) System.out.println(" Sleeping for " + howlong);
		  Thread.currentThread().sleep(howlong);
		  if (verbose) {
			  System.out.println(" **************************** ");
			  System.out.println(" WOKE UP");
			  System.out.println(" **************************** ");
		  }

	  } catch(InterruptedException e) {
		  return (true);
	  }
	  return false;
  }

}
