import java.net.*;
import java.io.*;
import java.util.*;

public class TCPHandler extends Thread {

        private static final boolean verbose = true;

	private Socket socket = null;
	private Socket dataSock = null;
	private String name = "";
	String fName;
	String ls;
	FileWriter log;
	FileOutputStream outFile;
	Calendar now = new GregorianCalendar();
	BufferedReader in = null;
	BufferedWriter out = null;
	BufferedInputStream inFile = null;
 
        int apptype;
	ConnData conn = null;
	Node node = null;

	public TCPHandler(int ptype,Socket socket,String name, FileWriter log) {
		super("TCPHandler");
		this.socket = socket;
		this.name = name; // Name of the application
		this.log = log;
		apptype = ptype;
 	}

	public void run() {
		if ((log == null)&&(Constants.Logging)) {
			try {
				log = new FileWriter(Constants.LogDir+socket.getInetAddress().getHostName()+
						     ":"+socket.getPort()+name+".log",true);
			} catch (Exception e) {
				System.out.println("TCPHandler :"+e);
			}
		}

		// Log down start time
		Date trial = new Date();
		now.setTime(trial);
		ls = "A "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
			" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
			now.get(Calendar.MINUTE)+":"+
			now.get(Calendar.SECOND)+
			"."+now.get(Calendar.MILLISECOND) + 
			" TCP "+ socket.getInetAddress().getHostName()+" "+
			socket.getPort();
		// System.out.println(ls);

		// Check whether to log
		if (Constants.Logging)
			try {
			log.write(ls+"\n",0,ls.length()+1);
			log.flush();
		} catch (Exception e) {
			System.out.println("TCPHandler :"+e);
		}

		// *****************************
		// TCP Stream processing here !!
		// *****************************

		// Create the input/output stream association
		try {
			in = new BufferedReader(new InputStreamReader(
								      socket.getInputStream()));
			out= new BufferedWriter(new OutputStreamWriter(
								       socket.getOutputStream()));
		} catch (Exception e) {
			System.out.println("TCPHandler i/o stream setup: "+e);
		}

		// Repeat reading the line as a string that contain the file name
		// Until the socket is closed by the client
		try {
			while ((fName = in.readLine())!= null) {

				// Write down the filename for log
				ls = ""+socket.getPort()+" Filename is: "+fName;
				System.out.println(ls);
				// Check whether to log
				if (Constants.Logging)
					try {
					log.write(ls+"\n",0,ls.length()+1);
					log.flush();
				} catch (Exception e) {
					System.out.println("TCPHandler log write :"+e);
				}

				conn = new ConnData(apptype, ConnMode.Receiver,
						    ConnStatus.Begin, socket.getPort(),
						    socket.getInetAddress().getHostAddress(), 0, 
						    (new Date()).getTime());

				// Open a new socket for data transfer
				// and notify the client about it
				try {
					ServerSocket servSock = new ServerSocket(0);
					ls = ""+servSock.getLocalPort();
					out.write(ls,0,ls.length());
					out.newLine();
					out.flush();
					ls = socket.getPort()+" Dataport is: "+ls;
					System.out.println(ls);
					if (Constants.Logging) {
						log.write(ls+"\n",0,ls.length()+1);
						log.flush();
					}
					dataSock = servSock.accept();
					servSock.close();
				} catch (Exception e) {
					System.out.println("TCPHandler datasock: "+e);
				}

				try {
					inFile = new BufferedInputStream(dataSock.getInputStream());
				} catch (Exception e) {
					e.printStackTrace();
					System.out.println("TCPHandler stream setup: "+e);
					System.exit(-1);
				}
				byte tmp[] = null;
				int count=0;
				int dataInt;
				node = new Node(conn.type, conn.mode, conn.status, conn.port,
						conn.correspondent, conn.bytes, conn.updatetime);
				try {
					while ((dataInt=inFile.read()) != -1) {
						count++;
						if (count % Constants.BlockSize == 0) {
							if (verbose) System.out.println(""+(count / Constants.BlockSize)+"K written");
							node.UpdateData(count, (new Date()).getTime());
						}
					}
				} catch (Exception e) {
					System.out.println("TCPHandler stream write: "+e);
				}

				// we haven't sent an update reflecting the last data
				if (count % Constants.BlockSize !=0 ) {
					node.UpdateData(count, (new Date()).getTime());
				}

				// Close the socket
				try {
					node.EndConn(count, (new Date()).getTime());
					inFile.close();
					dataSock.close();
				} catch (Exception e) {
					System.out.println("TCPHandler datasock: "+e);
					e.printStackTrace();
					System.exit(-1);
				}

				if (Constants.Logging) {
					// Log this transfer
					ls = "R "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
						" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
						now.get(Calendar.MINUTE)+":"+
						now.get(Calendar.SECOND)+
						"."+now.get(Calendar.MILLISECOND) + 
						" TCP "+ socket.getInetAddress().getHostName()+" "+
						fName;
					try {
						log.write(ls+"\n",0,ls.length()+1);
						log.flush();
					} catch (Exception e) {
						System.out.println("TCPHandler :"+e);
					}
				}

			}
		} catch (Exception e) {
			System.out.println("TCPHandler: "+e);
		}

		// Log down finish time
		trial = new Date();
		now.setTime(trial);
		ls = "T "+now.get(Calendar.MONTH)+"/"+now.get(Calendar.DATE)+
			" "+ now.get(Calendar.HOUR_OF_DAY)+":"+
			now.get(Calendar.MINUTE)+":"+
			now.get(Calendar.SECOND)+
			"."+now.get(Calendar.MILLISECOND) + 
			" TCP "+ socket.getInetAddress().getHostName()+" "+
			socket.getPort();
		if (Constants.Logging)
			try {
			log.write(ls+"\n",0,ls.length()+1);
			log.flush();
		} catch (Exception e) {
			System.out.println("TCPHandler: "+e);
		}
	}

	private boolean gotoSleep(long howlong) {
		try {
			if (verbose) System.out.println(" Sleeping for " + howlong);
			sleep(howlong);
			if (verbose) {
				System.out.println(" **************************** ");
				System.out.println(" WOKE UP");
				System.out.println(" **************************** ");
			}

		} catch(InterruptedException e) {
			return (true);
		}

		return (false);
	}

}
