//The main module that handles voice application data

import java.io.*;
import java.net.*;
import java.util.*;

public class SIS extends Thread {

 private SisParameters sisparams;
 private TCPServer tcp;
 private Hashtable HourThread; //which nodes have been called within an hour
 private List TimerList;

 public SIS () {

   Parser sisparser = new Parser();

   try {
     sisparams = sisparser.getSis();
   }
   catch(IOException e) {
     System.out.println(e.getMessage());
     System.exit(0);
   }

   HourThread = new Hashtable();
   TimerList = new List();
 }

 public void run() {
   long startT, endT, currentT;
   int hourcallcounter, destnode, inputfile, combinations, partialcounter;
   SISThread mythread;
   SISThreadData ThreadData;
   String myKey;
   long leftSleep, rightSleep; //ranges where I have to sleep. The diff is the
                               //amount of ms

// Start the UDP Server which is responsible for serving call and file
// tranfer requests
   tcp = new TCPServer(Constants.tcpSISport, null);
   tcp.start();

   System.out.println(" OK with the Server");
// Check if we can initiate calls

   if (sisparams.status_enabled == 0) {
        System.out.println(" Will not initiate any calls\n");
   }
   else {
     System.out.println(" Total = " + sisparams.nch);


     TimerList.GenerateData(sisparams.nch);
     //TimerList.print();

     while(true) {
        startT = ((new Date()).getTime());
        currentT = startT;
        hourcallcounter = 0;
        partialcounter = 0; // counter used in case the combinations are less
                            // than the maximum calls per hour
        HourThread.clear();
        combinations = sisparams.ncbe * sisparams.nfiles;

        leftSleep = 0;
        rightSleep = TimerList.getNext(); 
        System.out.println(" Sleeping for " + (rightSleep - leftSleep));
        gotoSleep((rightSleep - leftSleep));
        leftSleep = rightSleep;

        while(((currentT - startT) < Constants.hourtimer) &&
              (hourcallcounter < sisparams.nch)) {
// Select randomly a destination node and a file
          destnode= Math.round((sisparams.ncbe-1)*(new Random().nextFloat())); 
          inputfile=Math.round((sisparams.nfiles-1)*(new Random().nextFloat())); 
//Construct a key for the HashTable
          myKey = new String(((CallBook)sisparams.cbook.elementAt(destnode)).address+((Files)sisparams.files.elementAt(inputfile)).name);

          ThreadData = new SISThreadData(((CallBook)sisparams.cbook.elementAt(destnode)).address, ((Files)sisparams.files.elementAt(inputfile)).name);

          if (HourThread.containsKey(myKey) == false) {
            HourThread.put(myKey, ThreadData);
          }
          else {
            gotoSleep(1); //without this line GUI is not able to start.
                          //else it is a spin loop.
            continue;
          }
          System.out.println(myKey);
          
          mythread = new SISThread(
                      ((CallBook)sisparams.cbook.elementAt(destnode)).address,
                       Constants.tcpSISport,
                      ((Files)sisparams.files.elementAt(inputfile)).name,
                      ((Files)sisparams.files.elementAt(inputfile)).length);
          mythread.start();

          System.out.println(" SIS THread launched");

          hourcallcounter++;
          partialcounter++;
          currentT = ((new Date()).getTime());
          if ((partialcounter == combinations)&&(combinations <sisparams.nch)){
            HourThread.clear();
            partialcounter=0;
          }
          rightSleep = TimerList.getNext(); 
          System.out.println(" Sleeping for " + (rightSleep - leftSleep));
          gotoSleep((rightSleep - leftSleep));
          leftSleep = rightSleep;
        }
        if (hourcallcounter == sisparams.nch) {
          System.out.println(" Going to sleep for a long time...");
          try {
            sleep(Constants.hourtimer - (((new Date()).getTime())-startT));
          }
          catch(Exception e) {
            System.out.println(e.getMessage());
          }     
        }
     }
   }
 }

  private boolean gotoSleep(long howlong) {
    try {
      sleep(howlong);
    }
    catch(InterruptedException e) {
      return (true);
    }

    return (false);
  }

}
