/*
	A basic extension of the java.awt.Dialog class
 */

import java.awt.*;
import java.awt.event.*;

public class QuitDialog extends Dialog
{
	public QuitDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setLayout(null);
		setSize(insets().left + insets().right + 337,insets().top + insets().bottom + 135);
		yesButton = new java.awt.Button(" Yes ");
		yesButton.setBounds(insets().left + 72,insets().top + 80,79,22);
		yesButton.setFont(new Font("Dialog", Font.BOLD, 12));
		add(yesButton);
		noButton = new java.awt.Button("  No  ");
		noButton.setBounds(insets().left + 185,insets().top + 80,79,22);
		noButton.setFont(new Font("Dialog", Font.BOLD, 12));
		add(noButton);
		label1 = new java.awt.Label("Do you really want to quit?",Label.CENTER);
		label1.setBounds(78,33,180,23);
		add(label1);
		setTitle("A Basic Application - Quit");
		setResizable(false);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		noButton.addActionListener(lSymAction);
		yesButton.addActionListener(lSymAction);
		//}}
	}

	public void addNotify()
	{
	    // Record the size of the window prior to calling parents addNotify.
	    Dimension d = getSize();
	    
		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

	public QuitDialog(Frame parent, String title, boolean modal)
	{
		this(parent, modal);
		setTitle(title);
	}

	public synchronized void show()
	{
		Rectangle bounds = getParent().bounds();
		Rectangle abounds = bounds();

		move(bounds.x + (bounds.width - abounds.width)/ 2,
			 bounds.y + (bounds.height - abounds.height)/2);

		super.show();
	}

    // Used for addNotify check.
	boolean fComponentsAdjusted = false;

	//{{DECLARE_CONTROLS
	java.awt.Button yesButton;
	java.awt.Button noButton;
	java.awt.Label label1;
	//}}

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == QuitDialog.this)
				QuitDialog_WindowClosing(event);
		}
	}

	void QuitDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
           dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == noButton)
				noButton_Clicked(event);
			else if (object == yesButton)
				yesButton_Clicked(event);
		}
	}

	void yesButton_Clicked(java.awt.event.ActionEvent event)
	{
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((java.awt.Window)getParent(), WindowEvent.WINDOW_CLOSING));
	}

	void noButton_Clicked(java.awt.event.ActionEvent event)
	{
	    dispose();
	}

}
