/* 
This file Parses the configuration file.
The methods are invoked by individual Application classes, and parameters are returned
*/

import java.io.*;
import java.net.*;
import java.util.*;

public class Parser {

	private String whoami, filename;
	private static final int verbose = 0;
	public static void main(String[] args) throws IOException {
	}
 
	public Parser() {
		DatagramSocket tempsocket;

		try {
			tempsocket = new DatagramSocket();
			whoami = new String(tempsocket.getLocalAddress().getLocalHost().getHostName());
			
			tempsocket.close();
			filename = new String();
			filename = "config_"+whoami+".txt";
		}
		catch(Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}	

	/* get INTERVAL for updates to the "vizd" daemon */
	/* --------------------------------------------- */
	public UpdateInterval getInterval () throws IOException
	{
		int i,j,k;
        
		String s1,s2,sleft,sright,sbook;
    
		BufferedReader cReader = new BufferedReader(new FileReader(filename));

		UpdateInterval ui = new UpdateInterval();
    
		s1 = new String("null");
		if(!(s1.endsWith("interval")))
			{
				s1 = cReader.readLine();
				j = s1.indexOf(':'); 
				s1 = s1.substring(j+1);
				s1 = s1.trim();
				Integer interval = new Integer(s1);
				ui.interval = interval.intValue();
			}
    
		return ui;

	}
  
	/* for VOICE application */
	/*-----------------------*/
	public VoiceParameters getVoice() throws IOException
	{
		int i,j,k;
		int status_enabled=0;
		String s1,s2,s3,s4,s5,s6,s7,s8,sleft,sright,sbook;
   
		BufferedReader cReader = new BufferedReader(new FileReader(filename));
		System.out.println("Screening the Voice Configuration File");
    
		s1 = new String("null");
		while(!(s1.endsWith("voice")))
			{
				s1 = cReader.readLine();
				s1 = s1.trim();
				s1 = s1.toLowerCase();
			}

		s2 = new String(cReader.readLine());
		j = s2.indexOf(':'); 
		s2 = s2.substring(j+1);
		s2 = s2.trim();
		Integer parameters = new Integer(s2);
		if (verbose > 0) System.out.println("NumOfParams : "+parameters);

		s3 = new String(cReader.readLine());
		s3 = s3.trim();
		s3 = s3.toLowerCase();
		if (s3.endsWith("enabled")) { 
			status_enabled = 1; 
			System.out.println("Status: Enabled");
		}
		else if (s3.endsWith("disabled")) { 
			status_enabled = 0;
			System.out.println("Status: Disabled");
		} else { 
			System.out.println("Error in processing configuration file: (Voice_Appln) Status Expected");
			System.exit(0);
		}

		s4 = new String(cReader.readLine());
		j = s4.indexOf(':'); 
		s4 = s4.substring(j+1);
		s4 = s4.trim();
		Integer nch = new Integer(s4);
		if (verbose > 0) System.out.println("NumOfCallsPerHour : "+nch);
   
		s5 = new String(cReader.readLine());
		j = s5.indexOf(':'); 
		s5 = s5.substring(j+1);
		s5 = s5.trim();
		Integer ncbe = new Integer(s5);
		if (verbose > 0)  System.out.println("NumOfCallBookEntries : "+ncbe);

		VoiceParameters vp = new VoiceParameters();
		vp.status_enabled = status_enabled;
		vp.parameters = parameters.intValue();
		vp.nch = nch.intValue();
		vp.ncbe = ncbe.intValue();
    
		for (i=0; i<vp.ncbe; i++)
			{
				sbook = new String(cReader.readLine());
				sbook = sbook.trim();
				sbook = sbook.toLowerCase();
				j = sbook.indexOf('/'); 

				sright = new String(sbook.substring(j+1));
				sright = sright.trim();

				sleft = new String(sbook.substring(0,(sbook.length()-sright.length()-1)));


				CallBook cbook_entry = new CallBook();
				cbook_entry.name = sleft;
				cbook_entry.address = sright;
      
				vp.cbook.addElement(cbook_entry);
				if (verbose > 0) {
					System.out.println("VectorLength = "+vp.cbook.size());
					System.out.println("i = "+i);
					System.out.println("InetAddr : "+((CallBook) vp.cbook.elementAt(i)).address);
					System.out.println("HostName : "+((CallBook) vp.cbook.elementAt(i)).name);
				}
			}

		s6 = new String(cReader.readLine());
		j = s6.indexOf(':'); 
		s6 = s6.substring(j+1);
		s6 = s6.trim();
		Integer nfiles = new Integer(s6);
		if (verbose > 0) System.out.println("NumOfFiles : "+nfiles);
		vp.nfiles = nfiles.intValue();

		for (i=0; i<nfiles.intValue(); i++)
			{
				String sfiles = new String(cReader.readLine());
				sfiles = sfiles.trim();
				j = sfiles.indexOf(';'); 

				sright = new String(sfiles.substring(j+1));
				sright = sright.trim();

				sleft = new String(sfiles.substring(0,(sfiles.length()-sright.length()-1)));


				Files file1 = new Files();
				file1.name = sleft;
				Integer temp = new Integer(sright);
				file1.length = temp.intValue();
      
				vp.files.addElement(file1);

				if (verbose > 0) {
					System.out.println("VectorLength = "+vp.files.size());
					System.out.println("i = "+i);
					System.out.println("FileName : "+((Files) vp.files.elementAt(i)).name);
					System.out.println("FileLength : "+((Files) vp.files.elementAt(i)).length);
				}
			}

		s7 = new String(cReader.readLine());
		j = s7.indexOf(':'); 
		s7 = s7.substring(j+1);
		s7 = s7.trim();

		Integer nrates = new Integer(s7);
		if (verbose > 0) System.out.println("NumOfRates : "+nrates);
		vp.nrates = nrates.intValue();
	        int max_rate = 0;

		for (i=0; i<nrates.intValue(); i++)
			{
				String tempS = new String(cReader.readLine());
				if (verbose > 0) System.out.println(" S =" + tempS.trim());
				Integer rate1 = new Integer(tempS.trim());

				vp.rates.addElement(rate1);

				if (rate1.intValue() > max_rate) max_rate = rate1.intValue();

				if (verbose > 0) {
					System.out.println("VectorLength = "+vp.rates.size());
					System.out.println("i = "+i);
					System.out.println("Rate: "+(Integer) vp.rates.elementAt(i));
				}
			}

		s8 = new String(cReader.readLine());
		j = s8.indexOf(':'); 
		s8 = s8.substring(j+1);
		s8 = s8.trim();
		Integer interval = new Integer(s8);
		if (verbose > 0)  
			System.out.println("Silent Time Interval in full-duplex voice call: "+interval);
		vp.interval = interval.intValue();
   
		/* check data for constraints */
		Enumeration files = vp.files.elements();
		while (files.hasMoreElements()) {
			Files f = (Files) files.nextElement();
			if (f.length < vp.interval * max_rate * Constants.voice_pkt_size) {
				System.out.println("File '" + f.name + "' is too short.  Must be at least "
						   + vp.interval * max_rate * Constants.voice_pkt_size + " bytes");
				System.exit(-1);
			}
		}
		return vp;
	}

	/* for SIS application */
	/*-----------------------*/
	public SisParameters getSis() throws IOException
	{
		int i,j,k;
		int status_enabled=0;
    
		String s1,s2,s3,s4,s5,s6,sleft,sright,sbook;
    
		BufferedReader cReader = new BufferedReader(new FileReader(filename));
		System.out.println("Screening the SIS Configuration File");
    
		s1 = new String("null");
		while(!(s1.endsWith("sis")))
			{
				s1 = cReader.readLine();
				s1 = s1.trim();
				s1 = s1.toLowerCase();
			}

		s2 = new String(cReader.readLine());
		j = s2.indexOf(':'); 
		s2 = s2.substring(j+1);
		s2 = s2.trim();
		Integer parameters = new Integer(s2);
		if (verbose > 0) System.out.println("NumOfParams : "+parameters);

		s3 = new String(cReader.readLine());
		s3 = s3.trim();
		s3 = s3.toLowerCase();
		if (s3.endsWith("enabled")) { status_enabled = 1; System.out.println("Status: Enabled");}
		else if (s3.endsWith("disabled")) { status_enabled = 0;System.out.println("Status: Disabled");}
		else { System.out.println("Error in processing configuration file: (Sis_Appln) Status Expected");
		System.exit(0);
		}

		s4 = new String(cReader.readLine());
		j = s4.indexOf(':'); 
		s4 = s4.substring(j+1);
		s4 = s4.trim();
		Integer nch = new Integer(s4);
		if (verbose > 0)  System.out.println("NumOfCallsPerHour : "+nch);
   
		s5 = new String(cReader.readLine());
		j = s5.indexOf(':'); 
		s5 = s5.substring(j+1);
		s5 = s5.trim();
		Integer ncbe = new Integer(s5);
		if (verbose > 0)  System.out.println("NumOfCallBookEntries : "+ncbe);

		SisParameters sisp = new SisParameters();
		sisp.status_enabled = status_enabled;
		sisp.parameters = parameters.intValue();
		sisp.nch = nch.intValue();
		sisp.ncbe = ncbe.intValue();
    
		for (i=0; i<sisp.ncbe; i++) {
			sbook = new String(cReader.readLine());
			sbook = sbook.trim();
			sbook = sbook.toLowerCase();
			j = sbook.indexOf('/'); // 47 represents fwd_slash(/) in the ASCII char set
			sright = new String(sbook.substring(j+1));
			sright = sright.trim();
			sleft = new String(sbook.substring(0,(sbook.length()-sright.length()-1)));

			CallBook cbook_entry = new CallBook();
			cbook_entry.name = sleft;
			cbook_entry.address = sright;
      
			sisp.cbook.addElement(cbook_entry);
			if (verbose > 0) {
				System.out.println("VectorLength = "+sisp.cbook.size());
				System.out.println("i = "+i);
				System.out.println("InetAddr : "+((CallBook) sisp.cbook.elementAt(i)).address);
				System.out.println("HostName : "+((CallBook) sisp.cbook.elementAt(i)).name);
			}
		}

		s6 = new String(cReader.readLine());
		j = s6.indexOf(':'); 
		s6 = s6.substring(j+1);
		s6 = s6.trim();
		Integer nfiles = new Integer(s6);
		if (verbose > 0) System.out.println("NumOfFiles : "+nfiles);
		sisp.nfiles = nfiles.intValue();

		for (i=0; i<nfiles.intValue(); i++) {
			String sfiles = new String(cReader.readLine());
			sfiles = sfiles.trim();
			sfiles = sfiles.toLowerCase();
			j = sfiles.indexOf(';'); 

			sright = new String(sfiles.substring(j+1));
			sright = sright.trim();

			sleft = new String(sfiles.substring(0,(sfiles.length()-sright.length()-1)));


			Files file1 = new Files();
			file1.name = sleft;
			Integer temp = new Integer(sright);
			file1.length = temp.intValue();
      
			sisp.files.addElement(file1);
			if (verbose > 0) {
				System.out.println("VectorLength = "+sisp.files.size());
				System.out.println("i = "+i);
				System.out.println("FileName : "+((Files) sisp.files.elementAt(i)).name);
				System.out.println("FileLength : "+((Files) sisp.files.elementAt(i)).length);
			}
		}

		return sisp;
	}



	/* for VIMS application */
	/*-----------------------*/
	public VimsParameters getVims() throws IOException
	{
		int i,j,k;
		int status_enabled=0;
    
		String s1,s2,s3,s4,s5,s6,sleft,sright,sbook;
    
		BufferedReader cReader = new BufferedReader(new FileReader(filename));
		System.out.println("Screening the VIMS Configuration File");
    
		s1 = new String("null");
		while(!(s1.endsWith("vims"))) {
			s1 = cReader.readLine();
			s1 = s1.trim();
			s1 = s1.toLowerCase();
		}

		s2 = new String(cReader.readLine());
		j = s2.indexOf(':'); 
		s2 = s2.substring(j+1);
		s2 = s2.trim();
		Integer parameters = new Integer(s2);
		if (verbose > 0) System.out.println("NumOfParams : "+parameters);

		s3 = new String(cReader.readLine());
		s3 = s3.trim();
		s3 = s3.toLowerCase();
		if (s3.endsWith("enabled")) { 
			status_enabled = 1; 
			System.out.println("Status: Enabled");
		}
		else if (s3.endsWith("disabled")) { 
			status_enabled = 0;
			System.out.println("Status: Disabled");
		} else { 
			System.out.println("Error in processing configuration file: (Vims_Appln) Status Expected");
			System.exit(0);
		}

		s4 = new String(cReader.readLine());
		j = s4.indexOf(':'); 
		s4 = s4.substring(j+1);
		s4 = s4.trim();
		Integer nch = new Integer(s4);
		if (verbose > 0) System.out.println("NumOfCallsPerHour : "+nch);
   
		s5 = new String(cReader.readLine());
		j = s5.indexOf(':'); 
		s5 = s5.substring(j+1);
		s5 = s5.trim();
		Integer ncbe = new Integer(s5);
		if (verbose > 0) System.out.println("NumOfCallBookEntries : "+ncbe);

		VimsParameters vimsp = new VimsParameters();
		vimsp.status_enabled = status_enabled;
		vimsp.parameters = parameters.intValue();
		vimsp.nch = nch.intValue();
		vimsp.ncbe = ncbe.intValue();
    
		for (i=0; i<vimsp.ncbe; i++) {
			sbook = new String(cReader.readLine());
			sbook = sbook.trim();
			sbook = sbook.toLowerCase();
			j = sbook.indexOf('/'); 
      
			sright = new String(sbook.substring(j+1));
			sright = sright.trim();
      
			sleft = new String(sbook.substring(0,(sbook.length()-sright.length()-1)));
      
			
			CallBook cbook_entry = new CallBook();
			cbook_entry.name = sleft;
			cbook_entry.address = sright;
			
			vimsp.cbook.addElement(cbook_entry);

			if (verbose > 0) {
				System.out.println("VectorLength = "+vimsp.cbook.size());
				System.out.println("i = "+i);
				System.out.println("InetAddr : "+((CallBook) vimsp.cbook.elementAt(i)).address);
				System.out.println("HostName : "+((CallBook) vimsp.cbook.elementAt(i)).name);
			}
		}

		s6 = new String(cReader.readLine());
		j = s6.indexOf(':'); 
		s6 = s6.substring(j+1);
		s6 = s6.trim();
		Integer nfiles = new Integer(s6);
		if (verbose > 0) System.out.println("NumOfFiles : "+nfiles);
		vimsp.nfiles = nfiles.intValue();

		for (i=0; i<nfiles.intValue(); i++) {
			String sfiles = new String(cReader.readLine());
			sfiles = sfiles.trim();
			sfiles = sfiles.toLowerCase();
			j = sfiles.indexOf(';'); 
			
			sright = new String(sfiles.substring(j+1));
			sright = sright.trim();

			sleft = new String(sfiles.substring(0,(sfiles.length()-sright.length()-1)));


			Files file1 = new Files();
			file1.name = sleft;
			Integer temp = new Integer(sright);
			file1.length = temp.intValue();
			
			vimsp.files.addElement(file1);

			if (verbose > 0) {
				System.out.println("VectorLength = "+vimsp.files.size());
				System.out.println("i = "+i);
				System.out.println("FileName : "+((Files) vimsp.files.elementAt(i)).name);
				System.out.println("FileLength : "+((Files) vimsp.files.elementAt(i)).length);
			}
		}

		return vimsp;
	}


}

