/*
 * Main Application will connect with the GUI
 * And spawn the Appropriate threads for handling the different kind of
 * applications
 */



public class MainApp {

	static final boolean GUI = false;
	private static Voice VoiceApp;
	// private static SIS SISApp;
	private static VIMS VIMSApp;
	private static TCPServer ALSServer;
  
	private static ViewerFrame AppGui;

public static void main(String argv[]) {
	int i;

	// Roy's command line processing
	for (i = 0; i<argv.length; i++) {
		if (argv[i].startsWith("-d")) {
			// full logs (def: no logs)
			Constants.Logging = true;
		}
		if (argv[i].startsWith("-r")) {
			// save audio data files (def: don't save)
			Constants.AudioStore = true;
		}
		if (argv[i].startsWith("-f")) { 
			// the directory to store all logs (def: current)
			i++;
			if (i>=argv.length) { 
				// not enough parameters ?!?
				System.out.println("-f command line doesn't contain directory names !");
				System.exit(0);
			}
			Constants.LogDir = argv[i];
			if (!Constants.LogDir.endsWith("/"))
				Constants.LogDir += "/";
		}
	}
	if (Constants.Logging)
		System.out.println("Full logs");
	else
		System.out.println("No logs");
	if (Constants.AudioStore)
		System.out.println("Audio files saved");
	else
		System.out.println("Audio files are not saved");
	if (Constants.LogDir.length()!=0)
		System.out.println("All logs and data stored at :"+Constants.LogDir);
	else
		System.out.println("All logs (if any) will be stored in current directory");

    
	VoiceApp = new Voice();
	//    SISApp = new SIS();
	VIMSApp = new VIMS();

	ALSServer = new TCPServer(Constants.tcpALSport, null);
	ALSServer.start();

	if (GUI) {
		AppGui = new ViewerFrame(VoiceApp);
		AppGui.show();
	}

	VoiceApp.start();

	//    SISApp.start();
	VIMSApp.start();
}
}



