import java.net.*;
import java.io.*;
import java.util.*;

public class ControlHandler extends Thread {
	private static final boolean verbose = false;
	private Socket socket = null;
	private Socket dataSock = null;
	private String name = "";
	String ls;
	String portNo;
	BufferedReader in = null;
	UDPServer parent = null;
	UDPHandler handler = null;
        String sizeSt;
        Integer IntFileSize;
        int fileSize;

	public ControlHandler(UDPServer udps, Socket socket) {
		this.socket = socket;
		parent = udps;
 	}

	public void run() {
		
		// Create the input stream association
		try {
			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		} catch (Exception e) {
			System.out.println("ControlHandler i/o stream setup: "+e);
			System.exit(-1);
		}

		// Repeat reading the line as a string that contain the port no
		// Until the socket is closed by the client
		try {
			while ((portNo = in.readLine())!= null) {

				ls = "Closing voice "+socket.getInetAddress().getHostName()+
					" port "+portNo;

				// The next line should contain the filesize
				if ((sizeSt = in.readLine())!=null) {
					IntFileSize = new Integer(sizeSt);
					fileSize = IntFileSize.intValue();
					if(verbose) System.out.println("filesize is: "+fileSize);
				}
				
				handler = (UDPHandler) parent.voiceHandle.get(""
                                                             +socket.getInetAddress().getHostName()+portNo);
				if (handler != null) {
					handler.Close(fileSize);
				} else {
					System.out.println("ControlHandler wrong port :"+
							   socket.getInetAddress().getHostName()+" "+portNo);
				}

			}
		} catch (Exception e) {
			System.out.println("TCPHandler: "+e);
			System.exit(-1);
		}
		
	}
}

