import java.io.*; 
import java.net.*; 
import java.util.*; 

public class CommThread extends Thread {


  private static final int verbose = 2;

  private DatagramSocket serverSocket;
  private int application;
  private char mode;
  private char status;
  private int clientport;
  private InetAddress correspondent;
  private long updatetime;
  private Node MyNode;
  private long bytes;
  private int commInterval;

  public CommThread (int papplication, char pmode, char pstatus,
               int pclientport, InetAddress pcorrespondent, 
               long pbytes, long ptime, Node pnode) 
  { 

	  Parser parser;
	  UpdateInterval Interval;
	  
	  application = papplication;    
	  mode = pmode;    
	  status = pstatus;    
	  clientport = pclientport;    
	  try {
		  correspondent = InetAddress.getByName(pcorrespondent.getHostAddress());
	  } catch (UnknownHostException e) {
		  e.printStackTrace();
		  System.out.println("ERROR " + e.getMessage());
		  return;
	  }

	  MyNode = pnode;
	  bytes = pbytes;
	  updatetime = ptime;

	  try {
		  serverSocket = new DatagramSocket(); 
	  } catch (Exception e) { 
		  e.printStackTrace();
		  System.out.println("ERROR " + e.getMessage());
		  return;
	  }

	  parser = new Parser();
	  try {
		  Interval = parser.getInterval();
		  commInterval = Interval.interval;
	  } catch(IOException e) {
		  e.printStackTrace();
		  System.out.println("ERROR: can't get interval " + e.getMessage());
		  commInterval = 2;
	  }
  }

  private void NotifyPCTD() 
  {
	  int i;

	  ByteArrayOutputStream pkt_data = new ByteArrayOutputStream();
	  DataOutputStream pkt_stream = new DataOutputStream(pkt_data);


	  if (verbose > 2) {
		  System.out.println("app: "+application);
		  System.out.println("mode: "+mode);
		  System.out.println("status: "+status);
		  System.out.println("clientport: "+clientport);
		  System.out.println("addr: "+correspondent.getHostName());
		  System.out.println("bytes: "+bytes);
		  System.out.println("time: "+updatetime);
	  } else if (verbose > 1) {
		  System.out.println("Notify PCTD - app: "+application+" mode: "+mode
				     +" status: "+status+" bytes: "+bytes);
	  }

		  
		/* the packet format is

		   0                   1                   2                   3
		   0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   | Application   |   Mode        | Status          |    rsvd     |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |        client port            |           reserved            |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |        correspondent address                                  |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |                   bytes                                       |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |           seconds since epoch                                 |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |                  microseconds                                 |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

		   */


	  try {
		  pkt_data.reset();
		  pkt_stream.writeByte(application);
		  pkt_stream.writeByte(mode);
		  pkt_stream.writeByte(status);
		  pkt_stream.writeByte(0x00); //pad
		  pkt_stream.writeShort(clientport);
		  pkt_stream.writeByte(0x00); //pad
		  pkt_stream.writeByte(0x00); //pad
		  pkt_stream.write(correspondent.getAddress(),0,4);

		  pkt_stream.writeInt((int) bytes);
		  pkt_stream.writeInt((int) (updatetime/1000));
		  pkt_stream.writeInt((int) 0);

		  if (verbose > 2) {
			  System.out.println("Data to PCTD is");
			  for (i=0; i< pkt_data.size(); i++) {
				  String curByte = Integer.toHexString((byte) pkt_data.toByteArray()[i]);
				  curByte = "0"+curByte;
				  curByte = curByte.substring(curByte.length() - 2);
				  System.out.print(curByte + " ");
			  }
			  System.out.println("Done");
		  }

		  DatagramPacket sendPacket 
			  = new DatagramPacket(pkt_data.toByteArray(), pkt_data.size(), 
					       InetAddress.getByName(Constants.LocalHost), 
					       Constants.Visport);
 
		  serverSocket.send(sendPacket);


	  } catch(java.io.IOException e)   {
	          e.printStackTrace();
		  System.out.println("ERROR " + e.getMessage());
	  }
  }

  public void run() 
  {
	  if (mode == ConnMode.Sender) {

		  // build and send a packet telling PCTD we're starting
		  NotifyPCTD();
		  
		  // rexmit 2 secs later for robustness
		  gotoSleep(2*1000);
		  NotifyPCTD();

		  // just loop around till we're killed 
		  while (true) {	
			  gotoSleep(10 * 1000);
		  }
      
	  } else if (mode == ConnMode.Receiver) {
		  
		  // tell PCTD we're starting
		  NotifyPCTD();

		  // rexmit 2 secs later for robustness
		  gotoSleep(2*1000);
		  NotifyPCTD();

		  // loop and send updates every commInterval secs
		  while(true) { 
			  if (verbose > 2) System.out.println("CommThread: sending to PCTD");

			  status = ConnStatus.Update; 
			  bytes = MyNode.GetBytes();
			  updatetime = MyNode.GetTime();
			  NotifyPCTD();
			  gotoSleep(commInterval*1000); 
		  }

	  } else {
		  System.out.println("Uknown mode " + mode);
		  return;
	  }
  }

  public void Terminate() {
	  if (verbose > 2) System.out.println("CommThread:  dying now ");
	  this.stop();

	  bytes = MyNode.GetBytes();
	  updatetime = MyNode.GetTime();
	  status = ConnStatus.End;
	  NotifyPCTD();
	  
	  // rexmit 2 secs later for robustness
	  gotoSleep(2*1000);
	  status = ConnStatus.End;
	  NotifyPCTD();

	  // rexmit 2 secs later for robustness
	  gotoSleep(2*1000);
	  status = ConnStatus.End;
	  NotifyPCTD();
  }


  private boolean gotoSleep(long howlong) {
	  try {
		  sleep(howlong);
	  } catch(InterruptedException e) {
		  return (true);
	  }    
	  return (false);
  }  
}; 
