/* Prototypes of target machine for GNU compiler.  MIPS version.
   Copyright (C) 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998,
   1999, 2001 Free Software Foundation, Inc.
   Contributed by A. Lichnewsky (lich@inria.inria.fr).
   Changed by Michael Meissner	(meissner@osf.org).
   64 bit r4000 support by Ian Lance Taylor (ian@cygnus.com) and
   Brendan Eich (brendan@microunity.com).

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef GCC_SS_PROTOS_H
#define GCC_SS_PROTOS_H


/* Functions in ss.c called from outside ss.c */
extern int ss_address_cost (rtx addr);
extern void ss_output_lineno (FILE *stream, int line);
extern int ss_debugger_offset (rtx addr, int offset);
extern void ss_output_filename (FILE *stream, const char* name);
extern void 		ss_asm_file_start (FILE *stream);
extern void		ss_asm_file_end (FILE *file);
extern void		init_cumulative_args ( CUMULATIVE_ARGS *cum,	/* argument info to initialize */
	tree fntype,		/* tree ptr for function decl */
	rtx libname);		/* SYMBOL_REF of library name or 0 */

void		abort_with_insn (rtx insn, char *reason);
int		arith32_operand (rtx op, enum machine_mode mode);
int		arith_operand (rtx op, enum machine_mode mode);
int		cmp_op (rtx op, enum machine_mode mode);
int		cmp2_op (rtx op, enum machine_mode mode);
long		compute_frame_size (int size);
int		epilogue_reg_mentioned_p (rtx insn);
void		expand_block_move ( rtx operands[]);
int		equality_op (rtx op, enum machine_mode mode);
int		fcmp_op (rtx op, enum machine_mode mode);
void		final_prescan_insn (rtx insn, rtx opvec[], int noperands);
int		fpsw_register_operand (rtx op, enum machine_mode mode);
struct rtx_def *	function_arg (CUMULATIVE_ARGS *cum, enum machine_mode mode, tree type, int named);
void		function_arg_advance (CUMULATIVE_ARGS *cum, enum machine_mode mode, tree type, int named);
int		function_arg_partial_nregs (CUMULATIVE_ARGS *cum, enum machine_mode mode, tree type, int named);
void		function_epilogue (FILE *file, int size);
void		function_prologue (FILE* file, int size);
int uns_arith_operand (rtx op, enum machine_mode mode);
void function_prologue (FILE *file, int size);
void function_epilogue (FILE *file, int size);
int ss_legitimate_address_p (enum machine_mode mode,
     rtx xinsn,
     int strict);
int
ss_reg_mode_ok_for_base_p (rtx reg,
     enum machine_mode mode,
     int strict);
     
/* Functions to change what output section we are using.  */
extern void		rdata_section PARAMS ((void));
extern void		sdata_section PARAMS ((void));
extern void		sbss_section PARAMS ((void));




#ifdef RTX_CODE
extern rtx		gen_int_relational PARAMS ((enum rtx_code, rtx, rtx,
						    rtx,int *));
extern void		gen_conditional_branch PARAMS ((rtx *, enum rtx_code));
#endif

#endif /* ! GCC_SS_PROTOS_H */
