%test here is assumed to be the test split images
src = 'test/';
target = 'testOutput/';
if ~exist(target)
    mkdir(target);
end

addpaths();

if ~exist('data')
    data = loadProgramData();
end


cache = makeCache();
names = dir([src '/*.jpg']);

%run the algorithm on all the images
for nameI=1:numel(names)
    name = names(nameI).name;

    %if we've already handled it or another worker's handling it, continue
    if exist([target '/' name '.dense.png']) || isLocked([target '/' name '.dense.png.lock'])
        continue;
    end

    %otherwise, load it and run the method
    I = imread([src name]);

    %One can obtain slightly better results by a smart focal length estimate than
    %the one from default auto-calibration or a fixed proxy (both shown below),
    %although in my experience, this does not change the ordering of results.
    %
    %This focal length is used only for producing normals post-vp-estimation; 
    %to replace the vanishing point estimator you must modify run3DP.m
    %
    %Note: Although we provide the estimator used in Lee et al. NIPS 2010,
    %the code produces substantially worse estimates overall. 

    %options = struct('denseThresholds',[0.55],'makeRectifiedCopies',true,'sparseThresholds',[0.55],'focalLength',YOUR_FOCAL_LENGTH);

    %Not specifying the focal length parameter will use the estimated one from 
    %autocalibration for normal ccomputation, whose results are slightly 
    %different from the paper (on average 0.5 degrees/percentage point 
    %difference) but the ordering does not change.

    %options = struct('denseThresholds',[0.55],'makeRectifiedCopies',true,'sparseThresholds',[0.55]);

    
    %This will produce the same results as the webpage. This has the effect of
    %preventing absurd estimates of focal length from autocalibration, which 
    %occurs in a small fraction of cases (~5%).
    options = struct('denseThresholds',[0.55],'makeRectifiedCopies',true,'sparseThresholds',[0.55],'focalLength',size(I,1));

    [nd,cache,detections] = run3DP(I, data, options, cache);

    %visualize the predictions
    visSparse = visualizeNormal(nd.sparseMaps{end},nd.sparseMasks{end},I);
    visSparseRectify = visualizeNormal(nd.rectifiedSparseMaps{end},nd.sparseMasks{end},I);
    visDense = visualizeNormal(nd.denseMaps{end});
    visDenseRectify = visualizeNormal(nd.rectifiedDenseMaps{end});

    %write the output
    imwrite(visSparse, [target '/' name '.sparse.png']);
    imwrite(visSparseRectify, [target '/' name '.sparseRectify.png']);
    imwrite(visDenseRectify, [target '/' name '.denseRectify.png']);
    imwrite(visDense, [target '/' name '.dense.png']);
    %save the matfile
    save([target '/' name '.mat'],'nd','detections');

    %release the mutex
    unlock([target '/' name '.dense.png.lock']);
end
