function [splits, thresh] = splitOnAspect(cls, allImages, splitAspects)
% Split the data into three aspect ratio classes.
% Length of splitAspects+1 determines the numbers of splits and the values
% determine the aspect ratio's to split on. Use all zero's to get equal 
% split in terms of the number of elements.

numSplit = length(splitAspects) + 1;
aspects = zeros(1, length(allImages));
aspInd = 0;
for i = 1 : length(allImages)
  [present position] = ismember(cls, ...
    {allImages(i).annotation.object.name});
  if present
    bbox = getBoundingBox(allImages(i).annotation.object(position));
    aspInd = aspInd + 1;
    aspects(aspInd) = abs((bbox(1) - bbox(3)) / (bbox(2) - bbox(4)));
  else
    error('%d data does not have an object of class %s', i, cls);
  end
end
[aspectVals, sortAspect] = sort(aspects, 'ascend');
splits = cell(1, numSplit);
splitInd = 0;
thresh = splitAspects;
if splitAspects(1) == 0
  range = ceil(length(aspects) / numSplit);
  disp('Splits');
  for i = 1 : range : length(aspects)
    if i + range - 1 <= length(aspects)
      splitInd = splitInd + 1;
      splits{splitInd} = sortAspect(i:i+range-1);
      fprintf('%d (%f, %f)\n', range, aspectVals(i), aspectVals(i+range-1));
      thresh(splitInd) = aspectVals(i+range-1);
    else
      splitInd = splitInd + 1;
      splits{splitInd} = sortAspect(i:end);
      fprintf('%d (%f, %f)\n', length(aspects)-i+1, aspectVals(i), ...
        aspectVals(end));
    end
  end
else
  initAsp = 0;
  splitAspects = sort(splitAspects, 'ascend');
  for i = 1 : length(splitAspects)
    inds = find(aspectVals <= splitAspects(i));
    splits{i} = sortAspect(initAsp + 1 : inds(end));
    initAsp = length(inds);
    fprintf('%d (<=%f)\n', length(splits{i}), splitAspects(i));
  end
  if initAsp < length(aspectVals)
    splits{numSplit} = sortAspect(aspectVals>splitAspects(end));
    fprintf('%d (>%f)\n', length(splits{numSplit}), splitAspects(end));
  end
end
