function [name, ext] = getFileNameParts(fullName)
% Get the identifier part of the file name.
% e.g. for /a/b/c/d.txt the name would be 'd'
lastSlash = find(fullName=='/', 1, 'last');
fName = fullName(lastSlash+1:end);
fileInd = find(fName=='.', 1, 'last');
name = fName(1:fileInd-1);
ext = fName(fileInd+1:end);
end