function freqs = calculateFrequency(data, names)
% Counts the frequency for each object in 'data' identified by 'names'.
freqs = zeros(length(names), 1);
for i = 1 : length(data)
  objs = {data(i).annotation.object.name};
  [~, inds] = ismember(objs, names);
  inds = inds(inds>0);
  freqs(inds) = freqs(inds) + 1;
end
end