function [patData, assnClust] = generateIterTopNPatches(topN, ...
  selectedClusters, canoSize, patchImgDir)

if ~exist(patchImgDir, 'dir')
  mkdir(patchImgDir);
end
topN = reshape(topN, [], 1);
[pats, assnClust, patData] = getAppendedPatches(topN, selectedClusters);
generatePatchImagesAll(patchImgDir, canoSize, pats);
end

function [pats, assignedClust, data] = getAppendedPatches(topN, ...
  selectedClusters)
pats = cellfun(@(x) x.meta', topN, 'UniformOutput', false);
scores = cellfun(@(x) x.scores', topN, 'UniformOutput', false);
imgIds  = cellfun(@(x) x.imgIds', topN, 'UniformOutput', false);
clustIds = cell(size(pats));
for i = 1 : length(pats)
  clustIds{i} = ones(size(pats{i})) * selectedClusters(i);
end
pats = cell2mat(pats);
assignedClust = cell2mat(clustIds);
data.scores = cell2mat(scores);
data.imgIds = cell2mat(imgIds);
end
