function [relLoc, c1Sc, imgs, relInd] = displayRelativeLocationsPair(cl1, ...
  cl2, imgSet, c1NmsThresh, detResDir1, detResDir2, refDirection, distFn)
% displays the pairs.
% refDirection is in polar

results1 = PresenceDetectionResults(detResDir1);
results2 = PresenceDetectionResults(detResDir2);
[relLoc c1Sc imgs relInd] = computePairRelation(cl1, ...
  cl2, results1, results2, imgSet, c1NmsThresh, refDirection, distFn);

end

function [relLoc, c1Sc, imgs, relInd] = computePairRelation(cl1, cl2, ...
  results1, results2, imgSet, c1NmsThresh, refDirection, distFn)
pairRelation = cell(2 * length(imgSet), 1);
pairC1Scores = cell(2 * length(imgSet), 1);
pairImgs = cell(2 * length(imgSet), 1);
pairRelInds = cell(2 * length(imgSet), 1);
pairInd = 0;
pBar = createProgressBar();
for i = 79 % : length(imgSet)
  i
  pBar(i, length(imgSet));
  rs1 = results1.getPosResult(imgSet(i));
  d1 = rs1.firstLevel.detections(cl1);
  d1 = doNmsForCl1(d1, c1NmsThresh);
  rs2 = results2.getPosResult(imgSet(i));
  d2 = rs2.firstLevel.detections(cl2);
  if ~isempty(d1.metadata) && ~isempty(d2.metadata)
    b1 = getBoxesForPedro(d1.metadata);
    b2 = getBoxesForPedro(d2.metadata);
    sc1 = b1(:, 3) - b1(:, 1);
    sc2 = b2(:, 3) - b2(:, 1);
    for j = 1 : size(b1, 1)
      b1t = repmat(b1(j, :), size(b2, 1), 1);
      sc1t = ones(size(b2, 1), 1) * sc1(j);
      [b1trfor, b2trfor] = transformWithBox1AsCano(b1t, b2);
      metrfor = [mean(b2trfor(:, [1 3]), 2) mean(b2trfor(:, [2 4]), 2)];
      fe = [metrfor sc2 ./ sc1t];
      pairInd = pairInd + 1;
      pairC1Scores{pairInd} = ones(size(fe, 1), 1) * d1.decision(j);
      pairImgs{pairInd} = ones(size(fe, 1), 1) * imgSet(i);
      pairRelation{pairInd} = fe;
      pairRelInds{pairInd} = [ones(size(b2, 1), 1).* j (1:size(b2, 1))'];
      % Compute distances
      polarCood = transformRelativeBoxToPolar(pairRelation{pairInd});
      dists = pdist2(polarCood, refDirection, distFn);
      
      d = d1.metadata(j);
      mnx = mean([d.x1 d.x2]);
      mny = mean([d.y1 d.y2]);
      w = d.y2 - d.y1;
      newRefDir = refDirection;
      newRefDir(1) = newRefDir(1) * w;
      [nx, ny] = pol2cart(newRefDir(2), newRefDir(1));
      
      % Draw stuff
      clf;
      displayPatcheInContext(d1.metadata(j), 'k');
      hold on;
      line([mnx mnx+nx], [mny mny+ny], 'Color', 'r',  'LineWidth', 4);
      numColors = 100;
      clrs = jet(numColors);
      alpha = 3;
      thisDist = exp(-dists) .* exp(alpha.*(1 + d2.decision));
      [d2.decision dists thisDist]
      [unused, srtInds] = sort(thisDist);
      for k1 = 1 : length(d2.metadata)
        k = srtInds(k1);
        clrInd = 1 + floor((thisDist(k) / 2*alpha )* (numColors - 1));
        clrInd(clrInd > numColors) = numColors;
        displayPatchBox(d2.metadata(k), thisDist(k), clrs(clrInd, :));
      end
      hold off;
      disp('Press any key.');
      pause;
    end
%     keyboard;
  end
end

relLoc = pairRelation(1 : pairInd);
c1Sc = pairC1Scores(1 : pairInd);
imgs = pairImgs(1 : pairInd);
relInd = pairRelInds(1 : pairInd);
end

function nmsD = doNmsForCl1(d, thresh)
nmsD = d;
picks = doNmsForImg(d.metadata, d.decision, thresh);
nmsD.metadata = d.metadata(picks);
nmsD.decision = d.decision(picks);
end
