function visualizeDetectionResult(testSet, cluster, results, detectors, ...
  selectedClusters)

clustInd = find(selectedClusters==cluster);
% Order the images by detection scores, so that we see the best detection
% first.
[inds, scores] = getScoreOrdered(results, clustInd);
testSet = testSet(inds);
results = results(inds);

for i = 1 : length(testSet)
  i
  if isempty(results{i}.firstLevel.detections(clustInd).metadata)
    continue;
  end
  I = im2double(imread(results{i}.firstLevel.imagePath));
  
  img = testSet(i);
  locSpace = detectors.getLocationSpaceForImage(img);
  [distribution, dist2L] = detectors.doVotingForResult( ...
    results{i}, clustInd, locSpace);
  a = sum(sum(distribution, 3), 4);
  
  detections = results{i}.firstLevel.detections;
  met = detections(clustInd).metadata;
  descVals = detections(clustInd).decision;
  tmpbox = zeros(length(met), 5);
  for k = 1 : length(met)
    tmpbox(k, 1:4) = [met(k).x1 met(k).y1 met(k).x2 met(k).y2];
    tmpbox(k, 5) = descVals(k);
  end
  picks = nms(tmpbox, 0.5);
  boxes = tmpbox(picks, :);
        
  % display
  subplot(2, 1, 1);
  imshow(I);
  axis equal;
  displayBoxes(boxes);
  subplot(2, 1, 2);
  [rows, cols, dims] = size(I);
  a = imresize(a, [rows, cols]);
  imagesc(a);
  displayBoxes(boxes);
  axis equal;
  title(sprintf('%.3f', max(boxes(:, 5))));
  keyboard;
end

end

function displayBoxes(boxes)
hold on;
for j = 1 : size(boxes, 1)
  selCol = 'r';
  rectangle('Position', [boxes(j, 1) boxes(j, 2) ...
    boxes(j, 3)-boxes(j, 1) boxes(j, 4)-boxes(j, 2)], ...
    'EdgeColor', selCol, ...
    'LineWidth', 2);
  text(boxes(j, 1), boxes(j, 2) - 12, sprintf('%.3f', ...
    boxes(j, 5)), ...
    'BackgroundColor', selCol, ...
    'Color', 'k', ...
    'FontSize', 5);
end
hold off;
end
