function [allOverlaps, scores] = getOverlapsWithClusterDetections( ...
  testSet, imageIds, clusters, results, detectors, selectedClusters, ...
  homeImgs)
% Compute the overlap of detections with the ground truth bounding boxes.

if length(imageIds) ~=length(testSet) || ...
    length(imageIds) ~= length(results)
  error('Incorrect data passed as argument');
end

primaryCat = detectors.params.category;
[unused, clustInds] = ismember(clusters, selectedClusters);

allOverlaps = cell(size(clusters));
scores = cell(size(clusters));
for i = 1 : length(testSet)
  i
  img = testSet(i);
  rows = img.annotation.imagesize.nrows;
  cols = img.annotation.imagesize.ncols;
  canoScale = getCanonicalScale( ...
    detectors.params.imageCanonicalSize, rows, cols);
  [pedPos unused] = convertDataSun09ToPedro(primaryCat, img, ...
      [], false, homeImgs);
  posPoints = convertPatchToLocationSpaceCoods(pedPos);
  canoPosPoints = convertLocationsToCano(posPoints, canoScale);
  
  for k = 1 : length(clustInds)
    clustInd = clustInds(k);
    clustMeta = results{i}.firstLevel.detections(clustInd).metadata;
    clustScore = results{i}.firstLevel.detections(clustInd).decision;
    if isempty(clustMeta)
      continue;
    end
    clustBoxes = getBoxesForPedro(clustMeta);
    posBoxes = convertLocationToBoxCoods(canoPosPoints);
    overlaps = computeOverlap(clustBoxes, posBoxes, 'pedro');
    overlaps = max(overlaps, [], 2);
    allOverlaps{k} = [allOverlaps{k}; overlaps];
    scores{k} = [scores{k}; clustScore];
  end
end
end
