function gmm = getMixtureForVotes(votes, space)
factor = getCanonicalFactor(space);
xyVar = (20*factor)^2;
szVar = (30*factor)^2;
asVar = 0.3^2;

sigmaLoc = [ ...
  xyVar 0 0 0; ...
  0 xyVar 0 0; ...
  0 0 szVar 0; ...
  0 0 0 asVar; ...
];

% sigmaLoc = [ ...
%   xyVar 0; ...
%   0 xyVar; ...
% ];

muLoc = votes;
sigLoc = repmat(sigmaLoc, [1, 1, size(muLoc, 1)]);
proportion = ones(1, size(muLoc, 1)) / size(muLoc, 1);
gmm = gmdistribution(muLoc, sigLoc, proportion);
end

function factor = getCanonicalFactor(space)
lowDim = min(space.rows, space.cols);
factor = lowDim / space.imageCanonicalSize;
end