function writeSunImages(data, outDir, imgHome, prefix, resize)
if ~exist(outDir, 'dir')
  mkdir(outDir);
end

if nargin < 5
  resize = false;
end

for i = 1 : length(data)
  thisImg = data(i).annotation;
  imPath = [imgHome thisImg.folder '/' thisImg.filename];
  I = imread(imPath);
  if resize
    I = resizeImg(I);
  end
  imwrite(I, sprintf('%s/%s%.4d.jpg', outDir, prefix, i));
end
end

function I = resizeImg(img)
[nrows, ncols, chans] = size(img);
factor = 200 / nrows;
I = imresize(img, factor);
end
