%input/output
src = 'test//';
target = 'testOutput/';
if ~exist(target)
    mkdir(target);
end

addpaths();

%load the data
if ~exist('data')
    data = loadProgramData();
end

cache = makeCache();
names = dir([src '/*.jpg']);

%run the algorithm on all the images
for nameI=1:numel(names)
    name = names(nameI).name;

    %if we've already handled it or another worker's handling it, continue
    if exist([target '/' name '.dense.png']) || isLocked([target '/' name '.dense.png.lock'])
        continue;
    end

    %otherwise, load it and run the method
    I = imread([src name]);
    options = struct('denseThresholds',[0.55],'makeRectifiedCopies',true,'sparseThresholds',[0.85, 0.75, 0.65]);
    [nd,cache,detections] = run3DP(I, data, options, cache);

    %visualize the predictions
    visSparse = visualizeNormal(nd.sparseMaps{end},nd.sparseMasks{end},I);
    visSparseRectify = visualizeNormal(nd.rectifiedSparseMaps{end},nd.sparseMasks{end},I);
    visDense = visualizeNormal(nd.denseMaps{end});
    visDenseRectify = visualizeNormal(nd.rectifiedDenseMaps{end});

    %write the output
    imwrite(visSparse, [target '/' name '.sparse.png']);
    imwrite(visSparseRectify, [target '/' name '.sparseRectify.png']);
    imwrite(visDenseRectify, [target '/' name '.denseRectify.png']);
    imwrite(visDense, [target '/' name '.dense.png']);
    save([target '/' name '.det.mat'],'detections');

    %release the mutex
    unlock([target '/' name '.dense.png.lock']);
end
