function flatDetections = flattenDetections(detections)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code

    %Take a detection result from the detector code and convert 
    %it into a flat matrix with rows of the form 
    % [modelId, score, minX, minY, maxX, maxY]

    numDetections = detections.firstLevel.numDetections;
    %get to the actual detection structure, which is 1 x NumDetectors
    detectionStruct = detections.firstLevel.detections;
  
    %each row: [model id, score, minX, minY, maxX, maxY]
    flatDetections = zeros(numDetections,6);
    nextEntry = 1;
    for modelId=1:numel(detectionStruct)
        modelDetections = detectionStruct(modelId);
        for detectId=1:numel(detectionStruct(modelId).metadata)
            detect = modelDetections.metadata(detectId);
            flatDetections(nextEntry,:) = [ modelId, 
                                            modelDetections.decision(detectId),
                                            min(detect.x1,detect.x2),
                                            min(detect.y1,detect.y2),
                                            max(detect.x1,detect.x2),
                                            max(detect.y1,detect.y2)];
            
            nextEntry = nextEntry + 1;
        end 
    end

end
