function storeNextIterationData(topN, trainAllPos, validSetPos, ...
  validSetNeg, selectedClusters, homeImgs, nextIterDir, params)

[positivePatchesPerImg, locationInfo, posFeatures, positivePatches, ...
  posPatchIndexes, assignedClustVote, assignedClustTrain, ...
  selectedClusters] = ...
  prepareDetectedPatchClusters(topN, ...
    10, 5, params, trainAllPos, validSetPos, selectedClusters, ...
    homeImgs);
assignedClust = assignedClustTrain;
centers = calculateClusterCenters(selectedClusters, assignedClust, ...
  posFeatures);
save([nextIterDir 'POSITIVE_PATCHES'], 'positivePatchesPerImg', ...
  'locationInfo');
save([nextIterDir 'FIG_PATCH_CLUSTERS_REF'], 'assignedClust', ...
  'centers', 'params', 'selectedClusters', 'positivePatches', ...
  'posFeatures', 'posPatchIndexes');
save([nextIterDir 'POS_CALC_FEATURES'], 'posFeatures', ...
  'positivePatches', 'posPatchIndexes', 'params');

debug.assignedClustVote = assignedClustVote;
debug.assignedClustTrain = assignedClustTrain;

saveInfoForWarpProcessing(nextIterDir, assignedClust, ...
  centers, selectedClusters, posFeatures, positivePatches, ...
  validSetPos, validSetNeg, params, debug);

end