function warpFirstTrainScript(instanceId, procDir, outputDir)
try
  % Warp instance script
  globals;

  % Initialize instance some variables
  rand('twister', instanceId);
  pause(rand(1,1) * 10);
  
  if exist('procDir', 'var')
    PROCESSING_DIR = procDir;
  else
    outputDir = [PROCESSING_DIR 'firstTrainDir/'];
  end
  
  if ~exist(outputDir, 'dir')
    mkdir(outputDir);
  end

  % Load processing data
  fprintf('Loading data ...  ');
  clusterInformation = loadAndCheck( ...
    [PROCESSING_DIR 'CLUSTER_PROCESSING_INFO'], 'clusterInformation');
  fprintf('Done\n');

  pause(rand(1,1) * 10);
  % Load negatives
  fprintf('Loading negatives ...  ');
  load([PROCESSING_DIR 'NEG_CALC_FEATURES'], 'negFeatures', ...
    'negCorrespImgs');
  load([PROCESSING_DIR 'FIG_PATCH_CLUSTERS_REF.mat'], 'params');
  load([PROCESSING_DIR 'TRAINING_DATA'], 'trainSetNeg', 'validSetNeg');
  [negToUse, unused] = ismember(negCorrespImgs, trainSetNeg);
  negFeatures = negFeatures(negToUse, :);
  fprintf('Done\n');

  % Start processing the clusters
  selectedClusters = clusterInformation.clustersToProcess;
  selectedClusters = selectedClusters(randperm(length(selectedClusters)));
  assignedClust = clusterInformation.assignedClusters;
  autoClust = AutoClust(instanceId);
  doneFirstTrain = false;
  while ~doneFirstTrain
    autoClust.firstTrainClusters(assignedClust, selectedClusters, ...
          clusterInformation.posFeatures, negFeatures, outputDir, ...
          params.svmflags);
     if instanceId == 1
       doneFirstTrain = waitTillExists( ...
         getAllFileNames(selectedClusters, outputDir));
     else
       doneFirstTrain = true;
     end
  end
catch exception
  displayStackTrace(exception);
end
end

function names = getAllFileNames(selectedClusters, outputDir)
names = cell(size(selectedClusters));
for i = 1 : length(selectedClusters)
  clustId = selectedClusters(i);
  names{i} = [outputDir sprintf('%d', clustId) '_det.mat'];
end
end
