function [nb1a, nb2a, nb1b, nb2b] = postProcessBoxes(allData, boxes1A, ...
    boxes2A, boxes1B, boxes2B, gmm, threshPercent, primaryCat)
% Post process the boxes. Elimate all the boxes that do not fall in the
% high probability box.
configure;
nb1a = boxes1A;
nb2a = boxes2A;
nb1b = boxes1B;
nb2b = boxes2B;
disp('Post-porcessing boxes.');
parfor i = 1 : length(allData)
  mask = getHighProbMask(allData(i).annotation, gmm, ...
      threshPercent, primaryCat);
  nb1a{i} = processBoxes(mask, nb1a{i});
  nb2a{i} = processBoxes(mask, nb2a{i});
  nb1b{i} = processBoxes(mask, nb1b{i});
  nb2b{i} = processBoxes(mask, nb2b{i});
end
end


function [newBoxes] = processBoxes(mask, boxes)
chosen = zeros(1, size(boxes, 1));
for i = 1 : size(boxes, 1)
  [cx cy] = getCenter(boxes(i, :));
  cx = max(1, floor(cx));
  cy = max(1, floor(cy));
  if mask(cy, cx) > 0
    chosen(i) = i;
  end
end
newBoxes = boxes(chosen(chosen>0), :);
end

function [cx cy] = getCenter(bb)
cx = (bb(1) + bb(3)) / 2;
cy = (bb(2) + bb(4)) / 2;
end
