function plotMixtures(selectedClusters, locMixture, scaleMixture, ...
  mixScore, detectorDir, ratios)
globals;

outputDir = [PROCESSING_DIR 'mixturePlots3/'];
if ~exist(outputDir, 'dir')
  mkdir(outputDir);
end

% Load detectors.
fprintf('Loading detectors ...  ');
models = cell(1, length(selectedClusters));
results = cell(1, length(selectedClusters));
for i = 1 : length(selectedClusters)
  clustId = selectedClusters(i);
  load([detectorDir sprintf('%d_det.mat', clustId)]);
  models{i} = model;
  results{i} = result;
end
fprintf('done\n');

[sortRatios, ratioInds] = sort(ratios, 'descend');
% Generate mixture plots
for j = 1 : length(ratioInds)
  i = ratioInds(j);
  [scores, m, n] = unique(mixScore{i});
  [vals, inds] = sort(scores, 'descend');
  sel = inds(1 : models{i}.info.numPositives);
  selScores = false(size(scores));
  selScores(sel) = true;
  selMix = selScores(n);
  selMixInds = find(selMix == true);
  
  clustInfo = sprintf('%d', selectedClusters(i));
  fig1 = figure(1); clf; hold on;
  plot(locMixture{i}(:, 1), locMixture{i}(:, 2), 'xb');
  plot(locMixture{i}(selMixInds, 1), locMixture{i}(selMixInds, 2), 'or');
  title(clustInfo);
  hold off;
  axis([-3 3 -3 3]);
  frame = getframe(fig1);
  imwrite(frame.cdata, [outputDir sprintf('/%d_%d_loc.jpg', ...
    j, selectedClusters(i))]);
  
  fig2 = figure(2); clf;
  plot(scaleMixture{i}(:), ones(size(scaleMixture{i})), ...
    'ob');
  title(clustInfo);
  axis([0 2 0 2]);
  frame = getframe(fig2);
  imwrite(frame.cdata, [outputDir sprintf('/%d_%d_scl.jpg', ...
    j, selectedClusters(i))]);
  close all;
end
end