function getTop100Detections(pedroBoxes, pedroAutoBoxes, data, ...
  homeImgs, procDir, outputDir, distribDir, pedroOut, autoOut, ...
  primaryCat, numToGenerate)
PROCESSING_DIR = procDir;
% globals;
autoImgIds = [];
pedroImgIds = [];
allAutoBoxes = [];
allPedroBoxes = [];
pedroStatus = {};
autoStatus = {};
autoInd = 0;
pedroInd = 0;
for i = 1 : length(data)
  autoImgIds = [autoImgIds; ones(size(pedroAutoBoxes{i}, 1), 1) * i];
  allAutoBoxes = [allAutoBoxes; pedroAutoBoxes{i}];
  pedroImgIds = [pedroImgIds; ones(size(pedroBoxes{i}, 1), 1) * i];
  allPedroBoxes = [allPedroBoxes; pedroBoxes{i}];
  for j = 1 : length(pedroOut(i).annotation.object)
    pedroInd = pedroInd + 1;
    pedroStatus{pedroInd} = pedroOut(i).annotation.object(j).detection;
  end
  for j = 1 : length(autoOut(i).annotation.object)
    autoInd = autoInd + 1;
    autoStatus{autoInd} = autoOut(i).annotation.object(j).detection;
  end
  if length(autoOut(i).annotation.object) ~= size(pedroAutoBoxes{i}, 1)
    keyboard;
  end
end

autoOutputDir = [outputDir '/auto/'];
pedroOutputDir = [outputDir '/pedro/'];
generateTopNImgs(allAutoBoxes, autoImgIds, data, homeImgs, ...
  autoOutputDir, autoStatus, primaryCat, numToGenerate, ...
  [PROCESSING_DIR distribDir]);

% We already have these generated, skip.
generateTopNImgs(allPedroBoxes, pedroImgIds, data, homeImgs, ...
  pedroOutputDir, pedroStatus, primaryCat, numToGenerate);
end

function generateTopNImgs(boxes, imgIds, data, imgHome, outputDir, ...
  status, primaryCat, numToGenerate, distribDir)
size(imgIds)
size(boxes)
if ~exist(outputDir, 'dir')
  mkdir(outputDir);
end
scores = boxes(:, 5);
[unused, inds] = sort(scores, 'descend');
toSel = min(length(inds), numToGenerate);
selectInds = inds(1:toSel);
outSuffix = 'distrib';
for i = 1 : length(selectInds)
  
  boxId = selectInds(i);
  imgPath = [imgHome data(imgIds(boxId)).annotation.folder '/' ...
    data(imgIds(boxId)).annotation.filename];
  I = imread(imgPath);
  [rows cols dims] = size(I);
  fig1 = figure(1);
%   showboxes(I, boxes(boxId, :));
  showBaselineBoxes(I, boxes(boxId, :), data(imgIds(boxId)), primaryCat, ...
    imgHome);
  title(sprintf('%f : %s', scores(boxId), status{boxId}));
  saveas(fig1, [outputDir sprintf('%d_%d.jpg', i, imgIds(boxId))], 'jpg');
  if exist('distribDir', 'var')
    load([distribDir sprintf('%d_', imgIds(boxId)) outSuffix '.mat']);
    sumDist = sum(sum(voteSpace.space, 4), 3);
%     sumDist = imresize(sumDist, [rows cols]);
    fig2 = figure(2); clf;
    imagesc(sumDist);
    axis equal;
    title(sprintf('%f', sum(sumDist(:))));
    saveas(fig2, [outputDir sprintf('%d_%d_prob.jpg', i, ...
      imgIds(boxId))], 'jpg');
  end
%   keyboard;
%   pause;
  close all;
end
end