function data = getDataSet(name, mode, CONFIG)
% Gets the appropriate data set.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
switch(name)
  case 'NYU'
    data.imgsHome = CONFIG.NYUDir;
    if(strcmp(mode, 'train'))
      data.data = getNYUShortData(data.imgsHome);
     end
  case 'NYUHN'
    data.imgsHome = CONFIG.NYUHNDir;
    if(strcmp(mode, 'train'))
      data.data = getNYUShortData(data.imgsHome);
     end
  case 'NYUShort'
    data.imgsHome = CONFIG.NYUShortDir;
    if(strcmp(mode, 'train'))
      data.data = getNYUShortData(data.imgsHome);
     end
  case 'TempDistractors'
    data.imgsHome = CONFIG.TempDistractorsDir;
    if(strcmp(mode,'train'))
      data.data = getNYUShortData(data.imgsHome);
    end
  case 'hayes6Million'
    data.imgsHome = CONFIG.hayes6MillImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.hayes6MillDataDir 'test.mat'], 'hayes6MillTestData');
      data.data = hayes6MillTestData;
    elseif strcmp(mode, 'train')
      load([CONFIG.hayes6MillDataDir 'train.mat'], 'hayes6MillTrainData');
      data.data = hayes6MillTrainData;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  otherwise
    error('Unrecognized dataset %s', name);
end
end
