function [pos, neg] = convertDataSun09ToPedro(cls, positives, ...
  negatives,  flippedPos, homeImages)

allObj(length(positives) * 1000).im = '';
numObj = 0;
names = {};
for i = 1 : length(positives)
	thisImg = positives(i).annotation;
  objNames = {thisImg.object.name};
  [unused, inds] = ismember(objNames, cls);
  inds = find(inds);
  for j = 1 : length(inds)
    thisObject = thisImg.object(inds(j));
    if ~strcmp(cls, thisObject.name)
      %disp(thisObject.name);
      continue;
    end
    numObj = numObj + 1;
    bbox = getBoundingBox(thisObject, thisImg);
    if sum(bbox==0) > 0
      error('%d, %d has 0', i, inds(j));
    end
    allObj(numObj).im = [homeImages thisImg.folder '/' thisImg.filename];
    allObj(numObj).x1 = bbox(1);
    allObj(numObj).y1 = bbox(2);
    allObj(numObj).x2 = bbox(3);
    allObj(numObj).y2 = bbox(4);
    allObj(numObj).flip = false;
    allObj(numObj).trunc = thisObject.crop;
    allObj(numObj).size = thisImg.imagesize;
		names{numObj} = thisObject.name;
    if flippedPos
      oldx1 = bbox(1);
      oldx2 = bbox(3);
      bbox(1) = thisImg.imagesize.ncols - oldx2 + 1;
      bbox(3) = thisImg.imagesize.ncols - oldx1 + 1;
      numObj = numObj + 1;
      allObj(numObj).im = [homeImages thisImg.folder '/' thisImg.filename];
      allObj(numObj).x1 = bbox(1);
      allObj(numObj).y1 = bbox(2);
      allObj(numObj).x2 = bbox(3);
      allObj(numObj).y2 = bbox(4);
      allObj(numObj).flip = true;
      allObj(numObj).trunc = thisObject.crop;
      allObj(numObj).size = thisImg.imagesize;
		  names{numObj} = thisObject.name;
    end
  end
end
pos = allObj(1:numObj);

if ~isempty(negatives)
  neg(length(negatives) * 1000).im = '';
end
negInd = 0;
for i = 1 : length(negatives)
	thisImg = negatives(i).annotation;
  negInd = negInd + 1;
	neg(negInd).im = [homeImages thisImg.folder '/' thisImg.filename];
  neg(negInd).flip = false;
  neg(negInd).size = thisImg.imagesize;
end
if isempty(negatives)
  neg = [];
else
  neg = neg(1:negInd);
end

% fprintf('Pos: %d, Neg: %d\n', length(pos), length(neg));

% No need to save yet.
%save([cachedir cls '_train_' year], 'pos', 'neg');
end