function actInds = computeActiveInds(mutualOverlaps, posTotRatio, topN, ...
  excessThresh)
b = mutualOverlaps;
mutOverScores = sum(b);
[vals, mutSelected] = sort(mutOverScores, 'descend');

%

normMutSelected = mutOverScores ./ max(mutOverScores);
normPosTotRatio = posTotRatio ./ max(posTotRatio);
combSc = normPosTotRatio + 0.1 * (normMutSelected.^0.33);
[~, combOrd] = sort(combSc, 'descend');

% SVM confidence scores

tn = topN;
svmConfidences = zeros(size(tn));
for i = 1 : length(tn)
  toSel = min(length(tn{i}.scores), 6);
  svmConfidences(i) = mean(tn{i}.scores(1:toSel));
end

% Uniqueness scores

tn = topN;
uniquenessReward = zeros(size(tn));
for i = 1 : length(tn)
  toSel = min(length(tn{i}.imgIds), 20);
  numUnique = length(unique(tn{i}.imgIds(1:toSel)));
  uniquenessReward(i) = min(numUnique / 15, 1);
end

% Combine all the measures.

normMutSelected = mutOverScores ./ max(mutOverScores);
normPosTotRatio = posTotRatio ./ max(posTotRatio);
[~, tinds] = sort(normPosTotRatio, 'descend');
selTinds = tinds(1:end);

combSc = normPosTotRatio(selTinds) ...
  + 0.2 * (normMutSelected(selTinds).^0.33) ...
  + 0.2 * svmConfidences(selTinds) ...
  + 0.2 * uniquenessReward(selTinds);
[~, combOrd] = sort(combSc, 'descend');
combOrd = selTinds(combOrd);

%

% selected = inds2(1:2000);
% selected = mutSelected30;
selected = combOrd;
% [selected, coInd] = sort(selected);
finalSel = [];
% excessThresh = 1;
% excessThresh = 4;

% mutOver = mutualOverlaps30;
mutOver = mutualOverlaps;
% scs = sum(mutOver);
% [~, selOrd] = sort(scs, 'descend');
curr = selected(1);
remaining = false(1, size(mutOver, 1));
remaining(selected) = true;
while true
  remaining(curr) = false;
  finalSel = [finalSel curr];
  r = mutOver(curr, :);
  s = r >= excessThresh;
  remaining(s) = false;
  if sum(remaining) < 1
    break;
  end
  
  flgs = remaining(selected);
  dx = find(flgs);
  curr = selected(dx(1));
end
actInds = finalSel;

end
