function [adj img_count] = calculateAdjacency(data, names)
% Creates the adjacency matrix for 'names' in 'data'. Adjacency here is
% just co-occurence.
adj = zeros(length(names));
total_obj = 0;
img_count = zeros(size(names));
for i = 1 : length(data)
  objs = {data(i).annotation.object.name};
  [pres inds] = ismember(objs, names);
  valid = find(pres);
  inds = inds(valid);
  total_obj = total_obj + length(inds);
  uniq = unique(inds);
  for j = 1 : length(uniq)
    img_count(uniq(j)) = img_count(uniq(j)) + 1;
  end
  for j = 1 : length(inds) - 1
    for k = j + 1 : length(inds)
      adj(inds(j), inds(k)) = adj(inds(j), inds(k)) + 1;
      adj(inds(k), inds(j)) = adj(inds(k), inds(j)) + 1;
    end
  end
end
fprintf('Total objects considered %d\n', total_obj);
end
  
  
