function bottom_100_masked(all, boxes1Cond, boxes1Base, numBottom, gmm, ...
    primaryCat, threshPercent)
% Creates jpg images for numTop images containing top numTop highest
% scoring bounding boxes.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

configure;
condMaxImgs = zeros(length(all));
baseMaxImgs = zeros(length(all));

for i  = 1 : length(all)
  cboxes = boxes1Cond{i};
  bboxes = boxes1Base{i};
  if ~isempty(cboxes)
    condMaxImgs(i) = max(cboxes(:, end));
  else
    condMaxImgs(i) = -1000;
  end
  if ~isempty(bboxes)
    baseMaxImgs(i) = max(bboxes(:, end));
  else
    baseMaxImgs(i) = -1000;
  end
end

[~, cminInds] = sort(condMaxImgs, 'descend');
[~, bminInds] = sort(baseMaxImgs, 'descend');

selCondInds = cminInds(end - numBottom + 1 : end);
selCond = all(selCondInds);
selBaseInds = bminInds(end - numBottom + 1 : end);
selBase = all(selBaseInds);

for i = 1 : length(selCond)
  img1Path = [HOMEIMAGES selCond(i).annotation.folder '/' ...
      selCond(i).annotation.filename];
  img2Path = [HOMEIMAGES selBase(i).annotation.folder '/' ...
      selBase(i).annotation.filename];
  imCond = im2double(imread(img1Path));
  mask = getHighProbMask(selCond(i).annotation, gmm, ...
      threshPercent, primaryCat);
  mask(mask<0) = 0;
  mask = mask ./ max(max(mask));
  imCond(:, :, 1) = imCond(:, :, 1) .* mask;
  imCond(:, :, 2) = imCond(:, :, 2) .* mask;
  imCond(:, :, 3) = imCond(:, :, 3) .* mask;
  
  imBase = im2double(imread(img2Path));  
  mask = getHighProbMask(selBase(i).annotation, gmm, ...
      threshPercent, primaryCat);
  mask(mask<0) = 0;
  mask = mask ./ max(max(mask));
  imBase(:, :, 1) = imBase(:, :, 1) .* mask;
  imBase(:, :, 2) = imBase(:, :, 2) .* mask;
  imBase(:, :, 3) = imBase(:, :, 3) .* mask;
  
  fig1 = figure(1); clf;
  myshowboxes(imCond, boxes1Cond{selCondInds(i)}, 5);
  title('Conditional');
  fig2 = figure(2); clf;
  myshowboxes(imBase, boxes1Base{selBaseInds(i)}, 5);
  title('Base');
  fig3 = figure(3); clf;
  LMplot(selCond(i), 1, HOMEIMAGES); title('Ground Truth');
  fig4 = figure(4); clf;
  LMplot(selBase(i), 1, HOMEIMAGES); title('Ground Truth');
  fig5 = figure(5); clf;
  myshowboxes(imCond, boxes1Base{selCondInds(i)}, 5);
  title('Base');
  fig6 = figure(6); clf;
  myshowboxes(imBase, boxes1Cond{selBaseInds(i)}, 5);
  title('Conditional');
  
  print(fig1, '-djpeg', '-r0', ...
      sprintf('bot100/cond/%d_cond.jpg', i));
  print(fig3, '-djpeg', '-r0', ...
      sprintf('bot100/cond/%d_gtht.jpg', i));
  print(fig5, '-djpeg', '-r0', ...
      sprintf('top100/cond/%d_base.jpg', i));
  
  print(fig2, '-djpeg', '-r0', ...
      sprintf('bot100/base/%d_base.jpg', i));
  print(fig4, '-djpeg', '-r0', ...
      sprintf('bot100/base/%d_gtht.jpg', i));
  print(fig6, '-djpeg', '-r0', ...
      sprintf('bot100/base/%d_cond.jpg', i));
  
end
