function [normalData, ids] = getDetectionNormals(clustMetadata)
    globals;

    normalSource = CONFIG.normals;

    numDetectors = size(clustMetadata,1);
    numImages = size(clustMetadata,2);    

    ids = -1*ones(numDetectors,numImages);

    normalData = {};
    normalFilenames = {};

    fprintf('Loading normal detections\n');
    for i=1:numDetectors
        fprintf('%d / %d\n', i, numDetectors);
        for j=1:numImages
            if numel(clustMetadata{i,j}) 
                imageFull = clustMetadata{i,j}(1).im; 
                [~,imageFilename,~] = fileparts(imageFull);
                normalFilename = [strrep(imageFilename,'rgb','nm') '.mat'];
                fileLocation = strcmp(normalFilename,normalFilenames);
                if sum(fileLocation) == 0
                    normalFilenames = [normalFilenames, normalFilename];
                    normalData{numel(normalData)+1} = load([normalSource '/' normalFilename]);
                    fileLocation = strcmp(normalFilename,normalFilenames);
                end
                ids(i,j) = find(fileLocation); 
            end
        end
    end
end
