function patchData = canonicalizePatchData(patches)
    canonicalSize = [80, 80];
    nPatches = numel(patches);
    %allocate
    patchData.patchValid = zeros([canonicalSize(1), canonicalSize(2), nPatches]);
    patchData.patchNx = zeros([canonicalSize(1), canonicalSize(2), nPatches]);
    patchData.patchNy = zeros([canonicalSize(1), canonicalSize(2), nPatches]);
    patchData.patchNz = zeros([canonicalSize(1), canonicalSize(2), nPatches]);

    %concatenate
    for i=1:numel(patches)
        p = patches{i};
        patchData.patchValid(:,:,i) = imresize_old(p.patchValid, canonicalSize) == 1;
        patchData.patchNx(:,:,i) = imresize_old(p.patchNx, canonicalSize);
        patchData.patchNy(:,:,i)= imresize_old(p.patchNy, canonicalSize);
        patchData.patchNz(:,:,i)= imresize_old(p.patchNz, canonicalSize);
    end
end

